/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.mixin;

import com.google.common.collect.Lists;
import com.minecraftabnormals.endergetic.common.entities.bolloom.BolloomBalloonEntity;
import com.minecraftabnormals.endergetic.core.interfaces.BalloonHolder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public final class EntityMixin
implements BalloonHolder {
    private List<BolloomBalloonEntity> balloons = Lists.newArrayList();
    @Shadow
    private UUID field_96093_i;
    @Shadow
    private World field_70170_p;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;setLocationAndAngles(DDDFF)V", shift=At.Shift.AFTER)}, method={"setPositionAndUpdate"})
    private void updateBalloonPositions(double x, double y, double z, CallbackInfo info) {
        ServerWorld world = (ServerWorld)this.field_70170_p;
        this.balloons.forEach(balloon -> {
            world.func_217464_b((Entity)balloon);
            balloon.field_184237_aG = true;
            balloon.updateAttachedPosition();
        });
    }

    @Inject(at={@At(value="RETURN")}, method={"detach"})
    private void detach(CallbackInfo info) {
        if (!this.getBalloons().isEmpty()) {
            this.detachBalloons();
        }
        if (this instanceof BolloomBalloonEntity) {
            ((BolloomBalloonEntity)((Object)this)).detachFromEntity();
        }
    }

    @Override
    public List<BolloomBalloonEntity> getBalloons() {
        return this.balloons.isEmpty() ? Collections.emptyList() : Lists.newArrayList(this.balloons);
    }

    @Override
    public void attachBalloon(BolloomBalloonEntity balloon) {
        this.balloons.add(balloon);
    }

    @Override
    public void detachBalloon(BolloomBalloonEntity balloonEntity) {
        this.balloons.remove((Object)balloonEntity);
    }

    @Override
    public void detachBalloons() {
        this.getBalloons().forEach(BolloomBalloonEntity::detachFromEntity);
    }
}

