/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.endergetic.core.registry.other;

import com.minecraftabnormals.endergetic.common.entities.bolloom.BalloonColor;
import java.util.Optional;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.DataSerializerEntry;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class EEDataSerializers {
    public static final DeferredRegister<DataSerializerEntry> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.DATA_SERIALIZERS, (String)"endergetic");
    public static final IDataSerializer<Optional<Vector3d>> OPTIONAL_VEC3D = new IDataSerializer<Optional<Vector3d>>(){

        public void write(PacketBuffer buf, Optional<Vector3d> value) {
            buf.writeBoolean(value.isPresent());
            if (value.isPresent()) {
                Vector3d vec3d = value.get();
                buf.writeDouble(vec3d.func_82615_a());
                buf.writeDouble(vec3d.func_82617_b());
                buf.writeDouble(vec3d.func_82616_c());
            }
        }

        public Optional<Vector3d> read(PacketBuffer buf) {
            return !buf.readBoolean() ? Optional.empty() : Optional.of(new Vector3d(buf.readDouble(), buf.readDouble(), buf.readDouble()));
        }

        public Optional<Vector3d> copyValue(Optional<Vector3d> value) {
            return value;
        }
    };
    public static final IDataSerializer<BalloonColor> BALLOON_COLOR = new IDataSerializer<BalloonColor>(){

        public void write(PacketBuffer buf, BalloonColor value) {
            buf.func_179249_a((Enum)value);
        }

        public BalloonColor read(PacketBuffer buf) {
            return (BalloonColor)buf.func_179257_a(BalloonColor.class);
        }

        public BalloonColor copyValue(BalloonColor value) {
            return value;
        }
    };

    static {
        SERIALIZERS.register("optional_vec3d", () -> new DataSerializerEntry(OPTIONAL_VEC3D));
        SERIALIZERS.register("balloon_color", () -> new DataSerializerEntry(BALLOON_COLOR));
    }
}

