/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.MobEntity;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.NodeProcessor;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import tcb.spiderstpo.common.entity.movement.AdvancedPathFinder;
import tcb.spiderstpo.common.entity.movement.AdvancedWalkNodeProcessor;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public class AdvancedGroundPathNavigator<T extends MobEntity>
extends GroundPathNavigator {
    protected AdvancedPathFinder field_179681_j;
    protected long field_188563_q;
    protected BlockPos field_188564_r;
    protected final T advancedPathFindingEntity;
    protected final boolean checkObstructions;
    protected int stuckCheckTicks = 0;
    protected int checkpointRange;

    public AdvancedGroundPathNavigator(T entity, World worldIn) {
        this(entity, worldIn, true);
    }

    public AdvancedGroundPathNavigator(T entity, World worldIn, boolean checkObstructions) {
        super(entity, worldIn);
        this.advancedPathFindingEntity = entity;
        this.checkObstructions = checkObstructions;
        if (this.field_179695_a instanceof AdvancedWalkNodeProcessor) {
            AdvancedWalkNodeProcessor processor = (AdvancedWalkNodeProcessor)this.field_179695_a;
            processor.setCheckObstructions(checkObstructions);
        }
    }

    public AdvancedPathFinder getAssignedPathFinder() {
        return this.field_179681_j;
    }

    protected final PathFinder func_179679_a(int maxExpansions) {
        this.field_179681_j = this.createPathFinder(maxExpansions);
        this.field_179695_a = this.field_179681_j.getNodeProcessor();
        return this.field_179681_j;
    }

    protected AdvancedPathFinder createPathFinder(int maxExpansions) {
        AdvancedWalkNodeProcessor nodeProcessor = new AdvancedWalkNodeProcessor();
        nodeProcessor.func_186317_a(true);
        return new AdvancedPathFinder((NodeProcessor)nodeProcessor, maxExpansions);
    }

    @Nullable
    protected Path func_225464_a(Set<BlockPos> waypoints, int padding, boolean startAbove, int checkpointRange) {
        HashSet<BlockPos> adjustedWaypoints = new HashSet<BlockPos>();
        for (BlockPos pos : waypoints) {
            adjustedWaypoints.add(pos.func_177982_a(-MathHelper.func_76123_f((float)this.field_75515_a.func_213311_cf()) + 1, -MathHelper.func_76123_f((float)this.field_75515_a.func_213302_cg()) + 1, -MathHelper.func_76123_f((float)this.field_75515_a.func_213311_cf()) + 1));
        }
        Path path = super.func_225464_a(adjustedWaypoints, padding, startAbove, checkpointRange);
        if (path != null && path.func_224770_k() != null) {
            this.checkpointRange = checkpointRange;
        }
        return path;
    }

    public void func_188554_j() {
        if (this.field_75513_b.func_82737_E() - this.field_188563_q > 20L) {
            if (this.field_188564_r != null) {
                this.field_75514_c = null;
                this.field_75514_c = this.func_179680_a(this.field_188564_r, this.checkpointRange);
                this.field_188563_q = this.field_75513_b.func_82737_E();
                this.field_188562_p = false;
            }
        } else {
            this.field_188562_p = true;
        }
    }

    protected void func_179677_a(Vector3d entityPos) {
        super.func_179677_a(entityPos);
        if (this.checkObstructions && this.field_75514_c != null && !this.field_75514_c.func_75879_b()) {
            Vector3d checkPos;
            Vector3d target = this.field_75514_c.func_75881_a(this.advancedPathFindingEntity, Math.min(this.field_75514_c.func_75874_d() - 1, this.field_75514_c.func_75873_e() + 0));
            Vector3d diff = target.func_178788_d(entityPos);
            int axis = 0;
            double maxDiff = 0.0;
            for (int i = 0; i < 3; ++i) {
                double d;
                switch (i) {
                    default: {
                        d = Math.abs(diff.field_72450_a);
                        break;
                    }
                    case 1: {
                        d = Math.abs(diff.field_72448_b);
                        break;
                    }
                    case 2: {
                        d = Math.abs(diff.field_72449_c);
                    }
                }
                if (!(d > maxDiff)) continue;
                axis = i;
                maxDiff = d;
            }
            int height = MathHelper.func_76141_d((float)(this.advancedPathFindingEntity.func_213302_cg() + 1.0f));
            int ceilHalfWidth = MathHelper.func_76123_f((float)(this.advancedPathFindingEntity.func_213311_cf() / 2.0f + 0.05f));
            switch (axis) {
                default: {
                    checkPos = new Vector3d(entityPos.field_72450_a + Math.signum(diff.field_72450_a) * (double)ceilHalfWidth, entityPos.field_72448_b, target.field_72449_c);
                    break;
                }
                case 1: {
                    checkPos = new Vector3d(entityPos.field_72450_a, entityPos.field_72448_b + (double)(diff.field_72448_b > 0.0 ? height + 1 : -1), target.field_72449_c);
                    break;
                }
                case 2: {
                    checkPos = new Vector3d(target.field_72450_a, entityPos.field_72448_b, entityPos.field_72449_c + Math.signum(diff.field_72449_c) * (double)ceilHalfWidth);
                }
            }
            Vector3d facingDiff = checkPos.func_178788_d(entityPos.func_72441_c(0.0, axis == 1 ? (double)(this.field_75515_a.func_213302_cg() / 2.0f) : 0.0, 0.0));
            Direction facing = Direction.func_176737_a((float)((float)facingDiff.field_72450_a), (float)((float)facingDiff.field_72448_b), (float)((float)facingDiff.field_72449_c));
            boolean blocked = false;
            AxisAlignedBB checkBox = this.advancedPathFindingEntity.func_174813_aQ().func_72321_a(Math.signum(diff.field_72450_a) * 0.2, Math.signum(diff.field_72448_b) * 0.2, Math.signum(diff.field_72449_c) * 0.2);
            block9: for (int yo = 0; yo < height; ++yo) {
                for (int xzo = -ceilHalfWidth; xzo <= ceilHalfWidth; ++xzo) {
                    VoxelShape collisionShape;
                    PathNodeType nodeType;
                    BlockPos pos = new BlockPos(checkPos.field_72450_a + (double)(axis != 0 ? xzo : 0), checkPos.field_72448_b + (double)(axis != 1 ? yo : 0), checkPos.field_72449_c + (double)(axis != 2 ? xzo : 0));
                    BlockState state = ((MobEntity)this.advancedPathFindingEntity).field_70170_p.func_180495_p(pos);
                    PathNodeType pathNodeType = nodeType = state.func_196957_g((IBlockReader)((MobEntity)this.advancedPathFindingEntity).field_70170_p, pos, PathType.LAND) ? PathNodeType.OPEN : PathNodeType.BLOCKED;
                    if (nodeType != PathNodeType.BLOCKED || (collisionShape = state.func_215700_a((IBlockReader)((MobEntity)this.advancedPathFindingEntity).field_70170_p, pos, ISelectionContext.func_216374_a(this.advancedPathFindingEntity)).func_197751_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())) == null || !collisionShape.func_197756_d().stream().anyMatch(aabb -> aabb.func_72326_a(checkBox))) continue;
                    blocked = true;
                    break block9;
                }
            }
            if (blocked) {
                ++this.stuckCheckTicks;
                if (this.stuckCheckTicks > ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).getMaxStuckCheckTicks()) {
                    ((IAdvancedPathFindingEntity)this.advancedPathFindingEntity).onPathingObstructed(facing);
                    this.stuckCheckTicks = 0;
                }
            } else {
                this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 2, 0);
            }
        } else {
            this.stuckCheckTicks = Math.max(this.stuckCheckTicks - 4, 0);
        }
    }
}

