/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.common.entity.movement;

import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.Region;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;
import tcb.spiderstpo.common.entity.movement.IAdvancedPathFindingEntity;

public class AdvancedWalkNodeProcessor
extends WalkNodeProcessor {
    protected static final PathNodeType[] PATH_NODE_TYPES = PathNodeType.values();
    protected static final Direction[] DIRECTIONS = Direction.values();
    protected static final Vector3i PX = new Vector3i(1, 0, 0);
    protected static final Vector3i NX = new Vector3i(-1, 0, 0);
    protected static final Vector3i PY = new Vector3i(0, 1, 0);
    protected static final Vector3i NY = new Vector3i(0, -1, 0);
    protected static final Vector3i PZ = new Vector3i(0, 0, 1);
    protected static final Vector3i NZ = new Vector3i(0, 0, -1);
    protected static final Vector3i PXPY = new Vector3i(1, 1, 0);
    protected static final Vector3i NXPY = new Vector3i(-1, 1, 0);
    protected static final Vector3i PXNY = new Vector3i(1, -1, 0);
    protected static final Vector3i NXNY = new Vector3i(-1, -1, 0);
    protected static final Vector3i PXPZ = new Vector3i(1, 0, 1);
    protected static final Vector3i NXPZ = new Vector3i(-1, 0, 1);
    protected static final Vector3i PXNZ = new Vector3i(1, 0, -1);
    protected static final Vector3i NXNZ = new Vector3i(-1, 0, -1);
    protected static final Vector3i PYPZ = new Vector3i(0, 1, 1);
    protected static final Vector3i NYPZ = new Vector3i(0, -1, 1);
    protected static final Vector3i PYNZ = new Vector3i(0, 1, -1);
    protected static final Vector3i NYNZ = new Vector3i(0, -1, -1);
    protected IAdvancedPathFindingEntity advancedPathFindingEntity;
    protected boolean startFromGround = true;
    protected boolean checkObstructions;
    protected int pathingSizeOffsetX;
    protected int pathingSizeOffsetY;
    protected int pathingSizeOffsetZ;
    protected EnumSet<Direction> pathableFacings = EnumSet.of(Direction.DOWN);
    protected Direction[] pathableFacingsArray;
    private final Long2LongMap pathNodeTypeCache = new Long2LongOpenHashMap();
    private final Long2ObjectMap<PathNodeType> rawPathNodeTypeCache = new Long2ObjectOpenHashMap();
    private final Object2BooleanMap<AxisAlignedBB> aabbCollisionCache = new Object2BooleanOpenHashMap();
    protected boolean alwaysAllowDiagonals = true;

    public void setStartPathOnGround(boolean startFromGround) {
        this.startFromGround = startFromGround;
    }

    public void setCheckObstructions(boolean checkObstructions) {
        this.checkObstructions = checkObstructions;
    }

    public void setCanPathWalls(boolean canPathWalls) {
        if (canPathWalls) {
            this.pathableFacings.add(Direction.NORTH);
            this.pathableFacings.add(Direction.EAST);
            this.pathableFacings.add(Direction.SOUTH);
            this.pathableFacings.add(Direction.WEST);
        } else {
            this.pathableFacings.remove(Direction.NORTH);
            this.pathableFacings.remove(Direction.EAST);
            this.pathableFacings.remove(Direction.SOUTH);
            this.pathableFacings.remove(Direction.WEST);
        }
    }

    public void setCanPathCeiling(boolean canPathCeiling) {
        if (canPathCeiling) {
            this.pathableFacings.add(Direction.UP);
        } else {
            this.pathableFacings.remove(Direction.UP);
        }
    }

    public void func_225578_a_(Region sourceIn, MobEntity mob) {
        super.func_225578_a_(sourceIn, mob);
        if (!(mob instanceof IAdvancedPathFindingEntity)) {
            throw new IllegalArgumentException("Only mobs that extend " + IAdvancedPathFindingEntity.class.getSimpleName() + " are supported. Received: " + mob.getClass().getName());
        }
        this.advancedPathFindingEntity = (IAdvancedPathFindingEntity)mob;
        this.pathingSizeOffsetX = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.func_213311_cf() / 2.0f + 1.0f)));
        this.pathingSizeOffsetY = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.func_213302_cg() + 1.0f)));
        this.pathingSizeOffsetZ = Math.max(1, MathHelper.func_76141_d((float)(this.field_186326_b.func_213311_cf() / 2.0f + 1.0f)));
        this.pathableFacingsArray = this.pathableFacings.toArray(new Direction[0]);
    }

    public void func_176163_a() {
        super.func_176163_a();
        this.pathNodeTypeCache.clear();
        this.rawPathNodeTypeCache.clear();
        this.aabbCollisionCache.clear();
        this.advancedPathFindingEntity.pathFinderCleanup();
    }

    private boolean checkAabbCollision(AxisAlignedBB aabb) {
        return (Boolean)this.aabbCollisionCache.computeIfAbsent((Object)aabb, p_237237_2_ -> !this.field_176169_a.func_226665_a__((Entity)this.field_186326_b, aabb));
    }

    public PathPoint func_186318_b() {
        BlockPos initialStartPos;
        int by;
        BlockPos.Mutable checkPos;
        double z;
        double x;
        block12: {
            x = this.field_186326_b.func_226277_ct_();
            double y = this.field_186326_b.func_226278_cu_();
            z = this.field_186326_b.func_226281_cx_();
            checkPos = new BlockPos.Mutable();
            by = MathHelper.func_76128_c((double)y);
            BlockState state = this.field_176169_a.func_180495_p((BlockPos)checkPos.func_189532_c(x, (double)by, z));
            if (!this.field_186326_b.func_230285_a_(state.func_204520_s().func_206886_c())) {
                if (this.func_186322_e() && this.field_186326_b.func_70090_H()) {
                    while (true) {
                        if (state.func_177230_c() != Blocks.field_150355_j && state.func_204520_s() != Fluids.field_204546_a.func_207204_a(false)) {
                            --by;
                            break block12;
                        }
                        state = this.field_176169_a.func_180495_p((BlockPos)checkPos.func_189532_c(x, (double)(++by), z));
                    }
                }
                if (this.field_186326_b.func_233570_aj_() || !this.startFromGround) {
                    by = MathHelper.func_76128_c((double)(y + Math.min(0.5, Math.max((double)(this.field_186326_b.func_213302_cg() - 0.1f), 0.0))));
                } else {
                    BlockPos blockpos = this.field_186326_b.func_233580_cy_();
                    while ((this.field_176169_a.func_180495_p(blockpos).func_196958_f() || this.field_176169_a.func_180495_p(blockpos).func_196957_g((IBlockReader)this.field_176169_a, blockpos, PathType.LAND)) && blockpos.func_177956_o() > 0) {
                        blockpos = blockpos.func_177977_b();
                    }
                    by = blockpos.func_177984_a().func_177956_o();
                }
            } else {
                while (this.field_186326_b.func_230285_a_(state.func_204520_s().func_206886_c())) {
                    state = this.field_176169_a.func_180495_p((BlockPos)checkPos.func_189532_c(x, (double)(++by), z));
                }
                --by;
            }
        }
        BlockPos startPos = initialStartPos = new BlockPos(x, (double)by, z);
        long packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_186326_b, startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p()));
        DirectionalPathPoint startPathPoint = this.openPoint(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p(), packed, false);
        startPathPoint.field_186287_m = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        startPathPoint.field_186286_l = this.field_186326_b.func_184643_a(startPathPoint.field_186287_m);
        startPos = this.findSuitableStartingPosition(startPos, startPathPoint);
        if (!initialStartPos.equals((Object)startPos)) {
            packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_186326_b, startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p()));
            startPathPoint = this.openPoint(startPos.func_177958_n(), startPos.func_177956_o(), startPos.func_177952_p(), packed, false);
            startPathPoint.field_186287_m = AdvancedWalkNodeProcessor.unpackNodeType(packed);
            startPathPoint.field_186286_l = this.field_186326_b.func_184643_a(startPathPoint.field_186287_m);
        }
        if (this.field_186326_b.func_184643_a(startPathPoint.field_186287_m) < 0.0f) {
            AxisAlignedBB aabb = this.field_186326_b.func_174813_aQ();
            if (this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72340_a, (double)by, aabb.field_72339_c)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72340_a, (double)by, aabb.field_72334_f)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72336_d, (double)by, aabb.field_72339_c)) || this.isSafeStartingPosition((BlockPos)checkPos.func_189532_c(aabb.field_72336_d, (double)by, aabb.field_72334_f))) {
                packed = this.removeNonStartingSides(this.getDirectionalPathNodeTypeCached(this.field_186326_b, checkPos.func_177958_n(), checkPos.func_177956_o(), checkPos.func_177952_p()));
                startPathPoint = this.openPoint(checkPos.func_177958_n(), checkPos.func_177956_o(), checkPos.func_177952_p(), packed, false);
                startPathPoint.field_186287_m = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                startPathPoint.field_186286_l = this.field_186326_b.func_184643_a(startPathPoint.field_186287_m);
            }
        }
        return startPathPoint;
    }

    private long removeNonStartingSides(long packed) {
        long newPacked = packed & 0xFFFFFFFF00000000L;
        for (Direction side : DIRECTIONS) {
            if (!AdvancedWalkNodeProcessor.unpackDirection(side, packed) || !this.isValidStartingSide(side)) continue;
            newPacked = AdvancedWalkNodeProcessor.packDirection(side, newPacked);
        }
        return newPacked;
    }

    protected boolean isValidStartingSide(Direction side) {
        Direction groundSide = this.advancedPathFindingEntity.getGroundSide();
        return side == groundSide || side.func_176740_k() != groundSide.func_176740_k();
    }

    protected BlockPos findSuitableStartingPosition(BlockPos pos, DirectionalPathPoint startPathPoint) {
        if (startPathPoint.getPathableSides().length == 0) {
            Direction avoidedOffset = this.advancedPathFindingEntity.getGroundSide().func_176734_d();
            for (int xo = -1; xo <= 1; ++xo) {
                for (int yo = -1; yo <= 1; ++yo) {
                    for (int zo = -1; zo <= 1; ++zo) {
                        BlockPos offsetPos;
                        long packed;
                        PathNodeType nodeType;
                        if (xo == avoidedOffset.func_82601_c() || yo == avoidedOffset.func_96559_d() || zo == avoidedOffset.func_82599_e() || (nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed = this.getDirectionalPathNodeTypeCached(this.field_186326_b, (offsetPos = pos.func_177982_a(xo, yo, zo)).func_177958_n(), offsetPos.func_177956_o(), offsetPos.func_177952_p()))) != PathNodeType.WALKABLE || !AdvancedWalkNodeProcessor.unpackDirection(packed)) continue;
                        return offsetPos;
                    }
                }
            }
        }
        return pos;
    }

    private boolean isSafeStartingPosition(BlockPos pos) {
        PathNodeType pathnodetype = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.field_186326_b, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
        return this.field_186326_b.func_184643_a(pathnodetype) >= 0.0f;
    }

    private boolean allowDiagonalPathOptions(PathPoint[] options) {
        return this.alwaysAllowDiagonals || options == null || options.length == 0 || (options[0] == null || options[0].field_186287_m == PathNodeType.OPEN || options[0].field_186286_l != 0.0f) && (options.length <= 1 || options[1] == null || options[1].field_186287_m == PathNodeType.OPEN || options[1].field_186286_l != 0.0f);
    }

    public int func_222859_a(PathPoint[] pathOptions, PathPoint currentPointIn) {
        int k;
        int k2;
        boolean foundDiagonal;
        boolean is3DPathing;
        int k3;
        DirectionalPathPoint currentPoint = currentPointIn instanceof DirectionalPathPoint ? (DirectionalPathPoint)currentPointIn : new DirectionalPathPoint(currentPointIn);
        int openedNodeCount = 0;
        int stepHeight = 0;
        PathNodeType nodeTypeAbove = AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeTypeCached(this.field_186326_b, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c));
        if (this.field_186326_b.func_184643_a(nodeTypeAbove) >= 0.0f) {
            stepHeight = MathHelper.func_76141_d((float)Math.max(1.0f, this.field_186326_b.field_70138_W));
        }
        double height = (double)currentPoint.field_75837_b - AdvancedWalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, (BlockPos)new BlockPos(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c));
        PathPoint[] pathsPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, PZ, this.checkObstructions);
        PathPoint[] pathsNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, NX, this.checkObstructions);
        PathPoint[] pathsPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, stepHeight, height, PX, this.checkObstructions);
        PathPoint[] pathsNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, NZ, this.checkObstructions);
        for (k3 = 0; k3 < pathsPZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsPZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPZ[k3];
        }
        for (k3 = 0; k3 < pathsNX.length; ++k3) {
            if (!this.isSuitablePoint(pathsNX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNX[k3];
        }
        for (k3 = 0; k3 < pathsPX.length; ++k3) {
            if (!this.isSuitablePoint(pathsPX[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsPX[k3];
        }
        for (k3 = 0; k3 < pathsNZ.length; ++k3) {
            if (!this.isSuitablePoint(pathsNZ[k3], currentPoint, this.checkObstructions)) continue;
            pathOptions[openedNodeCount++] = pathsNZ[k3];
        }
        PathPoint[] pathsNY = null;
        if (this.checkObstructions || this.pathableFacings.size() > 1) {
            pathsNY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, NY, this.checkObstructions);
            for (int k4 = 0; k4 < pathsNY.length; ++k4) {
                if (!this.isSuitablePoint(pathsNY[k4], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsNY[k4];
            }
        }
        PathPoint[] pathsPY = null;
        if (this.pathableFacings.size() > 1) {
            pathsPY = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, PY, this.checkObstructions);
            for (int k5 = 0; k5 < pathsPY.length; ++k5) {
                if (!this.isSuitablePoint(pathsPY[k5], currentPoint, this.checkObstructions)) continue;
                pathOptions[openedNodeCount++] = pathsPY[k5];
            }
        }
        boolean allowDiagonalNZ = this.allowDiagonalPathOptions(pathsNZ);
        boolean allowDiagonalPZ = this.allowDiagonalPathOptions(pathsPZ);
        boolean allowDiagonalPX = this.allowDiagonalPathOptions(pathsPX);
        boolean allowDiagonalNX = this.allowDiagonalPathOptions(pathsNX);
        boolean fitsThroughPoles = this.field_186326_b.func_213311_cf() < 0.5f;
        boolean bl = is3DPathing = this.pathableFacings.size() >= 3;
        if (allowDiagonalNZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - this.field_176168_c, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, NXNZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_176168_c == 1 && this.field_176166_e == 1)) {
                pathsNXNZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c - this.field_176166_e, stepHeight, height, NXNZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsNXNZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsNXNZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNXNZ[k2];
                }
            }
        }
        if (allowDiagonalNZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXNZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, stepHeight, height, PXNZ, this.checkObstructions);
            for (k = 0; k < pathsPXNZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsPXNZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXNZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalNX) {
            DirectionalPathPoint[] pathsNXPZ = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, NXPZ, this.checkObstructions);
            for (k = 0; k < pathsNXPZ.length; ++k) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNX, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsNXPZ[k], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsNXPZ[k];
            }
        }
        if (allowDiagonalPZ && allowDiagonalPX) {
            DirectionalPathPoint[] pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + this.field_176168_c, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, stepHeight, height, PXPZ, this.checkObstructions);
            foundDiagonal = false;
            for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                foundDiagonal = true;
            }
            if (!(foundDiagonal || this.field_176168_c == 1 && this.field_176166_e == 1)) {
                pathsPXPZ = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c + this.field_176166_e, stepHeight, height, PXPZ, this.checkObstructions);
                for (k2 = 0; k2 < pathsPXPZ.length; ++k2) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsPXPZ[k2], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPXPZ[k2];
                }
            }
        }
        if (this.pathableFacings.size() > 1) {
            int k6;
            int k7;
            boolean foundDiagonal2;
            boolean allowDiagonalPY = this.allowDiagonalPathOptions(pathsPY);
            boolean allowDiagonalNY = this.allowDiagonalPathOptions(pathsNY);
            if (allowDiagonalNY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsNYNX = this.getSafePoints(currentPoint.field_75839_a - this.field_176168_c, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, NXNY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNX, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176168_c == 1 && this.field_176165_d == 1)) {
                    pathsNYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b - this.field_176165_d, currentPoint.field_75838_c, stepHeight, height, NXNY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNX, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsNYNX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNX[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsNYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, stepHeight, height, PXNY, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsNYPX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPX[k6];
                }
            }
            if (allowDiagonalNY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsNYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - this.field_176165_d, currentPoint.field_75838_c - 1, stepHeight, height, NYNZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176165_d == 1 && this.field_176166_e == 1)) {
                    pathsNYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c - this.field_176166_e, stepHeight, height, NYNZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsNYNZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsNYNZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsNYNZ[k7];
                    }
                }
            }
            if (allowDiagonalNY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsNYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c + 1, stepHeight, height, NYPZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsNYPZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsNY, currentPoint.field_75839_a, currentPoint.field_75837_b - 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsNYPZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsNYPZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalNX) {
                DirectionalPathPoint[] pathsPYNX = this.getSafePoints(currentPoint.field_75839_a - 1, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, NXPY, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNX.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a - 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsPYNX[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNX[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPX) {
                DirectionalPathPoint[] pathsPYPX = this.getSafePoints(currentPoint.field_75839_a + this.field_176168_c, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, stepHeight, height, PXPY, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176168_c == 1 && this.field_176165_d == 1)) {
                    pathsPYPX = this.getSafePoints(currentPoint.field_75839_a + 1, currentPoint.field_75837_b + this.field_176165_d, currentPoint.field_75838_c, stepHeight, height, PXPY, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPX.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPX, currentPoint.field_75839_a + 1, currentPoint.field_75837_b, currentPoint.field_75838_c, pathsPYPX[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPX[k7];
                    }
                }
            }
            if (allowDiagonalPY && allowDiagonalNZ) {
                DirectionalPathPoint[] pathsPYNZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c - 1, stepHeight, height, PYNZ, this.checkObstructions);
                for (k6 = 0; k6 < pathsPYNZ.length; ++k6) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsNZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c - 1, pathsPYNZ[k6], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYNZ[k6];
                }
            }
            if (allowDiagonalPY && allowDiagonalPZ) {
                DirectionalPathPoint[] pathsPYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + this.field_176165_d, currentPoint.field_75838_c + 1, stepHeight, height, PYPZ, this.checkObstructions);
                foundDiagonal2 = false;
                for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                    if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                    pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    foundDiagonal2 = true;
                }
                if (!(foundDiagonal2 || this.field_176165_d == 1 && this.field_176166_e == 1)) {
                    pathsPYPZ = this.getSafePoints(currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c + this.field_176166_e, stepHeight, height, PYPZ, this.checkObstructions);
                    for (k7 = 0; k7 < pathsPYPZ.length; ++k7) {
                        if (!this.isSuitablePoint((DirectionalPathPoint[])pathsPY, currentPoint.field_75839_a, currentPoint.field_75837_b + 1, currentPoint.field_75838_c, (DirectionalPathPoint[])pathsPZ, currentPoint.field_75839_a, currentPoint.field_75837_b, currentPoint.field_75838_c + 1, pathsPYPZ[k7], currentPoint, this.checkObstructions, fitsThroughPoles, is3DPathing)) continue;
                        pathOptions[openedNodeCount++] = pathsPYPZ[k7];
                    }
                }
            }
        }
        return openedNodeCount;
    }

    protected boolean isTraversible(DirectionalPathPoint from, DirectionalPathPoint to) {
        if (this.func_186322_e() && (from.field_186287_m == PathNodeType.WATER || from.field_186287_m == PathNodeType.WATER_BORDER || from.field_186287_m == PathNodeType.LAVA || to.field_186287_m == PathNodeType.WATER || to.field_186287_m == PathNodeType.WATER_BORDER || to.field_186287_m == PathNodeType.LAVA)) {
            return true;
        }
        boolean dx = to.field_75839_a - from.field_75839_a != 0;
        boolean dy = to.field_75837_b - from.field_75837_b != 0;
        boolean dz = to.field_75838_c - from.field_75838_c != 0;
        boolean isDiagonal = (dx ? 1 : 0) + (dy ? 1 : 0) + (dz ? 1 : 0) > 1;
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 == d2) {
                    return true;
                }
                if (!isDiagonal) continue;
                Direction.Axis a1 = d1.func_176740_k();
                Direction.Axis a2 = d2.func_176740_k();
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Y || a1 == Direction.Axis.Y && a2 == Direction.Axis.X) {
                    return !dz;
                }
                if (a1 == Direction.Axis.X && a2 == Direction.Axis.Z || a1 == Direction.Axis.Z && a2 == Direction.Axis.X) {
                    return !dy;
                }
                if ((a1 != Direction.Axis.Z || a2 != Direction.Axis.Y) && (a1 != Direction.Axis.Y || a2 != Direction.Axis.Z)) continue;
                return !dx;
            }
        }
        return false;
    }

    protected static boolean isSharingDirection(DirectionalPathPoint from, DirectionalPathPoint to) {
        Direction[] fromDirections = from.getPathableSides();
        Direction[] toDirections = to.getPathableSides();
        for (int i = 0; i < fromDirections.length; ++i) {
            Direction d1 = fromDirections[i];
            for (int j = 0; j < toDirections.length; ++j) {
                Direction d2 = toDirections[j];
                if (d1 != d2) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint newPoint, DirectionalPathPoint currentPoint, boolean allowObstructions) {
        return newPoint != null && !newPoint.field_75842_i && (allowObstructions || newPoint.field_186286_l >= 0.0f || currentPoint.field_186286_l < 0.0f) && this.isTraversible(currentPoint, newPoint);
    }

    protected boolean isSuitablePoint(@Nullable DirectionalPathPoint[] newPoints1, int np1x, int np1y, int np1z, @Nullable DirectionalPathPoint[] newPoints2, int np2x, int np2y, int np2z, @Nullable DirectionalPathPoint newPointDiagonal, DirectionalPathPoint currentPoint, boolean allowObstructions, boolean fitsThroughPoles, boolean is3DPathing) {
        if (!is3DPathing) {
            if (!(newPointDiagonal == null || newPointDiagonal.field_75842_i || newPoints2 == null || newPoints2.length <= 0 || newPoints2[0] == null && (newPoints2.length <= 1 || newPoints2[1] == null) || newPoints1 == null || newPoints1.length <= 0 || newPoints1[0] == null && (newPoints1.length <= 1 || newPoints1[1] == null) || newPoints1[0] != null && newPoints1[0].field_186287_m == PathNodeType.WALKABLE_DOOR || newPoints2[0] != null && newPoints2[0].field_186287_m == PathNodeType.WALKABLE_DOOR || newPointDiagonal.field_186287_m == PathNodeType.WALKABLE_DOOR)) {
                boolean canPassPoleDiagonally = newPoints2[0] != null && newPoints2[0].field_186287_m == PathNodeType.FENCE && newPoints1[0] != null && newPoints1[0].field_186287_m == PathNodeType.FENCE && fitsThroughPoles;
                return (allowObstructions || newPointDiagonal.field_186286_l >= 0.0f) && (canPassPoleDiagonally || (newPoints2[0] != null && (allowObstructions || newPoints2[0].field_186286_l >= 0.0f) || newPoints2.length > 1 && newPoints2[1] != null && (allowObstructions || newPoints2[1].field_186286_l >= 0.0f)) && (newPoints1[0] != null && (allowObstructions || newPoints1[0].field_186286_l >= 0.0f) || newPoints1.length > 1 && newPoints1[1] != null && (allowObstructions || newPoints1[1].field_186286_l >= 0.0f)));
            }
        } else if (newPointDiagonal != null && !newPointDiagonal.field_75842_i && this.isTraversible(currentPoint, newPointDiagonal)) {
            long packed2 = this.getDirectionalPathNodeTypeCached(this.field_186326_b, np2x, np2y, np2z);
            PathNodeType pathNodeType2 = AdvancedWalkNodeProcessor.unpackNodeType(packed2);
            boolean open2 = pathNodeType2 == PathNodeType.OPEN || pathNodeType2 == PathNodeType.WALKABLE;
            long packed1 = this.getDirectionalPathNodeTypeCached(this.field_186326_b, np1x, np1y, np1z);
            PathNodeType pathNodeType1 = AdvancedWalkNodeProcessor.unpackNodeType(packed1);
            boolean open1 = pathNodeType1 == PathNodeType.OPEN || pathNodeType1 == PathNodeType.WALKABLE;
            return open1 != open2 || open1 && open2 && AdvancedWalkNodeProcessor.isSharingDirection(newPointDiagonal, currentPoint);
        }
        return false;
    }

    protected DirectionalPathPoint openPoint(int x, int y, int z, long packed, boolean isDrop) {
        int hash = PathPoint.func_75830_a((int)x, (int)y, (int)z);
        PathPoint point = (PathPoint)this.field_176167_b.computeIfAbsent(hash, key -> new DirectionalPathPoint(x, y, z, packed, isDrop));
        if (!(point instanceof DirectionalPathPoint)) {
            point = new DirectionalPathPoint(point);
            this.field_176167_b.put(hash, (Object)point);
        }
        return (DirectionalPathPoint)point;
    }

    @Nullable
    private DirectionalPathPoint[] getSafePoints(int x, int y, int z, int stepHeight, double height, Vector3i direction, boolean allowBlocked) {
        long initialPacked;
        DirectionalPathPoint directPathPoint = null;
        BlockPos pos = new BlockPos(x, y, z);
        double blockHeight = (double)y - AdvancedWalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, (BlockPos)new BlockPos(x, y, z));
        if (blockHeight - height > 1.125) {
            return new DirectionalPathPoint[0];
        }
        long packed = initialPacked = this.getDirectionalPathNodeTypeCached(this.field_186326_b, x, y, z);
        PathNodeType nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
        float malus = this.advancedPathFindingEntity.getPathingMalus((IBlockReader)this.field_176169_a, this.field_186326_b, nodeType, pos, direction, dir -> AdvancedWalkNodeProcessor.unpackDirection(dir, initialPacked));
        double halfWidth = (double)this.field_186326_b.func_213311_cf() / 2.0;
        DirectionalPathPoint[] result = new DirectionalPathPoint[1];
        if (malus >= 0.0f && (allowBlocked || nodeType != PathNodeType.BLOCKED)) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.field_186287_m = nodeType;
            directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
            if (directPathPoint.field_186287_m == PathNodeType.BLOCKED) {
                result = new DirectionalPathPoint[2];
                result[1] = directPathPoint;
                directPathPoint = null;
            }
        }
        if (nodeType == PathNodeType.WALKABLE) {
            result[0] = directPathPoint;
            return result;
        }
        if (directPathPoint == null && stepHeight > 0 && nodeType != PathNodeType.FENCE && nodeType != PathNodeType.UNPASSABLE_RAIL && nodeType != PathNodeType.TRAPDOOR && direction.func_177956_o() == 0 && Math.abs(direction.func_177958_n()) + Math.abs(direction.func_177956_o()) + Math.abs(direction.func_177952_p()) == 1) {
            double offsetZ;
            double offsetX;
            AxisAlignedBB enclosingAabb;
            DirectionalPathPoint[] pointsAbove = this.getSafePoints(x, y + 1, z, stepHeight - 1, height, direction, false);
            DirectionalPathPoint directionalPathPoint = directPathPoint = pointsAbove.length > 0 ? pointsAbove[0] : null;
            if (directPathPoint != null && (directPathPoint.field_186287_m == PathNodeType.OPEN || directPathPoint.field_186287_m == PathNodeType.WALKABLE) && this.field_186326_b.func_213311_cf() < 1.0f && this.checkAabbCollision(enclosingAabb = new AxisAlignedBB((offsetX = (double)(x - direction.func_177958_n()) + 0.5) - halfWidth, AdvancedWalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, (BlockPos)new BlockPos(offsetX, (double)(y + 1), offsetZ = (double)(z - direction.func_177956_o()) + 0.5)) + 0.001, offsetZ - halfWidth, offsetX + halfWidth, (double)this.field_186326_b.func_213302_cg() + AdvancedWalkNodeProcessor.func_197682_a((IBlockReader)this.field_176169_a, (BlockPos)new BlockPos(directPathPoint.field_75839_a, directPathPoint.field_75837_b, directPathPoint.field_75838_c)) - 0.002, offsetZ + halfWidth))) {
                directPathPoint = null;
            }
        }
        if (nodeType == PathNodeType.OPEN) {
            float bridingMalus;
            directPathPoint = null;
            AxisAlignedBB checkAabb = new AxisAlignedBB((double)x - halfWidth + 0.5, (double)y + 0.001, (double)z - halfWidth + 0.5, (double)x + halfWidth + 0.5, (double)((float)y + this.field_186326_b.func_213302_cg()), (double)z + halfWidth + 0.5);
            if (this.checkAabbCollision(checkAabb)) {
                result[0] = null;
                return result;
            }
            if (this.field_186326_b.func_213311_cf() >= 1.0f) {
                for (int i = 0; i < this.pathableFacingsArray.length; ++i) {
                    Direction pathableFacing = this.pathableFacingsArray[i];
                    long packedAtFacing = this.getDirectionalPathNodeTypeCached(this.field_186326_b, x + pathableFacing.func_82601_c() * this.pathingSizeOffsetX, y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? this.pathingSizeOffsetY : 0)), z + pathableFacing.func_82599_e() * this.pathingSizeOffsetZ);
                    PathNodeType nodeTypeAtFacing = AdvancedWalkNodeProcessor.unpackNodeType(packedAtFacing);
                    if (nodeTypeAtFacing != PathNodeType.BLOCKED) continue;
                    directPathPoint = this.openPoint(x, y, z, packedAtFacing, false);
                    directPathPoint.field_186287_m = PathNodeType.WALKABLE;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    result[0] = directPathPoint;
                    return result;
                }
            }
            boolean cancelFallDown = false;
            DirectionalPathPoint fallPathPoint = null;
            int fallDistance = 0;
            int preFallY = y;
            while (y > 0 && nodeType == PathNodeType.OPEN) {
                if (fallDistance++ >= Math.max(1, this.field_186326_b.func_82143_as()) || --y == 0) {
                    cancelFallDown = true;
                    break;
                }
                packed = this.getDirectionalPathNodeTypeCached(this.field_186326_b, x, y, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if ((this.field_186326_b.func_82143_as() > 0 && nodeType != PathNodeType.OPEN || nodeType == PathNodeType.WATER || nodeType == PathNodeType.LAVA) && malus >= 0.0f) {
                    fallPathPoint = this.openPoint(x, y, z, packed, true);
                    fallPathPoint.field_186287_m = nodeType;
                    fallPathPoint.field_186286_l = Math.max(fallPathPoint.field_186286_l, malus);
                    break;
                }
                if (!(malus < 0.0f)) continue;
                cancelFallDown = true;
            }
            boolean hasPathUp = false;
            if (this.pathableFacings.size() > 1) {
                packed = this.getDirectionalPathNodeTypeCached(this.field_186326_b, x, preFallY, z);
                nodeType = AdvancedWalkNodeProcessor.unpackNodeType(packed);
                malus = this.field_186326_b.func_184643_a(nodeType);
                if (nodeType != PathNodeType.OPEN && malus >= 0.0f) {
                    if (fallPathPoint != null) {
                        result = new DirectionalPathPoint[2];
                        result[1] = fallPathPoint;
                    }
                    result[0] = directPathPoint = this.openPoint(x, preFallY, z, packed, false);
                    directPathPoint.field_186287_m = nodeType;
                    directPathPoint.field_186286_l = Math.max(directPathPoint.field_186286_l, malus);
                    hasPathUp = true;
                }
            }
            if (fallPathPoint != null) {
                if (!hasPathUp) {
                    result[0] = directPathPoint = fallPathPoint;
                } else {
                    result = new DirectionalPathPoint[]{directPathPoint, fallPathPoint};
                }
            }
            if (fallPathPoint != null && (bridingMalus = this.advancedPathFindingEntity.getBridgePathingMalus(this.field_186326_b, new BlockPos(x, preFallY, z), fallPathPoint)) >= 0.0f) {
                result = new DirectionalPathPoint[2];
                result[0] = directPathPoint;
                DirectionalPathPoint bridgePathPoint = this.openPoint(x, preFallY, z, packed, false);
                bridgePathPoint.field_186287_m = PathNodeType.WALKABLE;
                bridgePathPoint.field_186286_l = Math.max(bridgePathPoint.field_186286_l, bridingMalus);
                result[1] = bridgePathPoint;
            }
            if (cancelFallDown && !hasPathUp) {
                result[0] = null;
                if (result.length == 2) {
                    result[1] = null;
                }
                return result;
            }
        }
        if (nodeType == PathNodeType.FENCE) {
            directPathPoint = this.openPoint(x, y, z, packed, false);
            directPathPoint.field_75842_i = true;
            directPathPoint.field_186287_m = nodeType;
            directPathPoint.field_186286_l = nodeType.func_186289_a();
        }
        result[0] = directPathPoint;
        return result;
    }

    protected long getDirectionalPathNodeTypeCached(MobEntity entitylivingIn, int x, int y, int z) {
        return this.pathNodeTypeCache.computeIfAbsent(BlockPos.func_218276_a((int)x, (int)y, (int)z), key -> this.getDirectionalPathNodeType((IBlockReader)this.field_176169_a, x, y, z, entitylivingIn, this.field_176168_c, this.field_176165_d, this.field_176166_e, this.func_186324_d(), this.func_186323_c()));
    }

    static long packDirection(Direction facing, long packed) {
        return packed | 1L << facing.ordinal();
    }

    static long packDirection(long packed1, long packed2) {
        return packed1 & 0xFFFFFFFF00000000L | packed1 & 0xFFFFFFFFL | packed2 & 0xFFFFFFFFL;
    }

    static boolean unpackDirection(Direction facing, long packed) {
        return (packed & 1L << facing.ordinal()) != 0L;
    }

    static boolean unpackDirection(long packed) {
        return (packed & 0xFFFFFFFFL) != 0L;
    }

    static long packNodeType(PathNodeType type, long packed) {
        return (long)type.ordinal() << 32 | packed & 0xFFFFFFFFL;
    }

    static PathNodeType unpackNodeType(long packed) {
        return PATH_NODE_TYPES[(int)(packed >> 32)];
    }

    public PathNodeType func_186319_a(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z, entity, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn));
    }

    protected long getDirectionalPathNodeType(IBlockReader blockaccessIn, int x, int y, int z, MobEntity entity, int xSize, int ySize, int zSize, boolean canBreakDoorsIn, boolean canEnterDoorsIn) {
        BlockPos pos = new BlockPos(entity.func_213303_ch());
        EnumSet<PathNodeType> applicablePathNodeTypes = EnumSet.noneOf(PathNodeType.class);
        long centerPacked = this.getDirectionalPathNodeType(blockaccessIn, x, y, z, xSize, ySize, zSize, canBreakDoorsIn, canEnterDoorsIn, applicablePathNodeTypes, PathNodeType.BLOCKED, pos);
        PathNodeType centerPathNodeType = AdvancedWalkNodeProcessor.unpackNodeType(centerPacked);
        if (applicablePathNodeTypes.contains(PathNodeType.FENCE)) {
            return AdvancedWalkNodeProcessor.packNodeType(PathNodeType.FENCE, centerPacked);
        }
        if (applicablePathNodeTypes.contains(PathNodeType.UNPASSABLE_RAIL)) {
            return AdvancedWalkNodeProcessor.packNodeType(PathNodeType.UNPASSABLE_RAIL, centerPacked);
        }
        PathNodeType selectedPathNodeType = PathNodeType.BLOCKED;
        for (PathNodeType applicablePathNodeType : applicablePathNodeTypes) {
            float p2;
            if (entity.func_184643_a(applicablePathNodeType) < 0.0f) {
                return AdvancedWalkNodeProcessor.packNodeType(applicablePathNodeType, centerPacked);
            }
            float p1 = entity.func_184643_a(applicablePathNodeType);
            if (!(p1 > (p2 = entity.func_184643_a(selectedPathNodeType))) && (p1 != p2 || selectedPathNodeType == PathNodeType.WALKABLE && applicablePathNodeType == PathNodeType.OPEN) && (p1 != p2 || selectedPathNodeType != PathNodeType.OPEN || applicablePathNodeType != PathNodeType.WALKABLE)) continue;
            selectedPathNodeType = applicablePathNodeType;
        }
        if (centerPathNodeType == PathNodeType.OPEN && entity.func_184643_a(selectedPathNodeType) == 0.0f) {
            return AdvancedWalkNodeProcessor.packNodeType(PathNodeType.OPEN, 0L);
        }
        return AdvancedWalkNodeProcessor.packNodeType(selectedPathNodeType, centerPacked);
    }

    protected long getDirectionalPathNodeType(IBlockReader blockaccessIn, int x, int y, int z, int xSize, int ySize, int zSize, boolean canOpenDoorsIn, boolean canEnterDoorsIn, EnumSet<PathNodeType> nodeTypeEnum, PathNodeType nodeType, BlockPos pos) {
        long packed = 0L;
        for (int ox = 0; ox < xSize; ++ox) {
            for (int oy = 0; oy < ySize; ++oy) {
                for (int oz = 0; oz < zSize; ++oz) {
                    int bx = ox + x;
                    int by = oy + y;
                    int bz = oz + z;
                    long packedAdjusted = this.getDirectionalPathNodeType(blockaccessIn, bx, by, bz);
                    PathNodeType adjustedNodeType = AdvancedWalkNodeProcessor.unpackNodeType(packedAdjusted);
                    adjustedNodeType = this.func_215744_a(blockaccessIn, canOpenDoorsIn, canEnterDoorsIn, pos, adjustedNodeType);
                    if (ox == 0 && oy == 0 && oz == 0) {
                        packed = AdvancedWalkNodeProcessor.packNodeType(adjustedNodeType, packedAdjusted);
                    }
                    nodeTypeEnum.add(adjustedNodeType);
                }
            }
        }
        return packed;
    }

    public PathNodeType func_186330_a(IBlockReader blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.unpackNodeType(this.getDirectionalPathNodeType(blockaccessIn, x, y, z));
    }

    protected long getDirectionalPathNodeType(IBlockReader blockaccessIn, int x, int y, int z) {
        return AdvancedWalkNodeProcessor.getDirectionalPathNodeType(this.rawPathNodeTypeCache, blockaccessIn, x, y, z, this.pathingSizeOffsetX, this.pathingSizeOffsetY, this.pathingSizeOffsetZ, this.pathableFacingsArray);
    }

    protected static PathNodeType getRawPathNodeTypeCached(Long2ObjectMap<PathNodeType> cache, IBlockReader blockaccessIn, BlockPos.Mutable pos) {
        return (PathNodeType)cache.computeIfAbsent(BlockPos.func_218276_a((int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p()), key -> AdvancedWalkNodeProcessor.func_237238_b_((IBlockReader)blockaccessIn, (BlockPos)pos));
    }

    protected static long getDirectionalPathNodeType(Long2ObjectMap<PathNodeType> rawPathNodeTypeCache, IBlockReader blockaccessIn, int x, int y, int z, int pathingSizeOffsetX, int pathingSizeOffsetY, int pathingSizeOffsetZ, Direction[] pathableFacings) {
        long packed = 0L;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        PathNodeType nodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos.func_181079_c(x, y, z));
        boolean isWalkable = false;
        if (nodeType == PathNodeType.OPEN && y >= 1) {
            for (int i = 0; i < pathableFacings.length; ++i) {
                Direction pathableFacing = pathableFacings[i];
                int checkHeight = pathableFacing.func_176740_k() != Direction.Axis.Y ? Math.min(4, pathingSizeOffsetY - 1) : 0;
                int cx = x + pathableFacing.func_82601_c() * pathingSizeOffsetX;
                int cy = y + (pathableFacing == Direction.DOWN ? -1 : (pathableFacing == Direction.UP ? pathingSizeOffsetY : 0));
                int cz = z + pathableFacing.func_82599_e() * pathingSizeOffsetZ;
                for (int yo = 0; yo <= checkHeight; ++yo) {
                    pos.func_181079_c(cx, cy + yo, cz);
                    PathNodeType offsetNodeType = AdvancedWalkNodeProcessor.getRawPathNodeTypeCached(rawPathNodeTypeCache, blockaccessIn, pos);
                    PathNodeType pathNodeType = nodeType = offsetNodeType != PathNodeType.WALKABLE && offsetNodeType != PathNodeType.OPEN && offsetNodeType != PathNodeType.WATER && offsetNodeType != PathNodeType.LAVA ? PathNodeType.WALKABLE : PathNodeType.OPEN;
                    if (offsetNodeType == PathNodeType.DAMAGE_FIRE) {
                        nodeType = PathNodeType.DAMAGE_FIRE;
                    }
                    if (offsetNodeType == PathNodeType.DAMAGE_CACTUS) {
                        nodeType = PathNodeType.DAMAGE_CACTUS;
                    }
                    if (offsetNodeType == PathNodeType.DAMAGE_OTHER) {
                        nodeType = PathNodeType.DAMAGE_OTHER;
                    }
                    if (offsetNodeType == PathNodeType.STICKY_HONEY) {
                        nodeType = PathNodeType.STICKY_HONEY;
                    }
                    if (nodeType != PathNodeType.WALKABLE) continue;
                    if (AdvancedWalkNodeProcessor.isColliderNodeType(offsetNodeType)) {
                        packed = AdvancedWalkNodeProcessor.packDirection(pathableFacing, packed);
                    }
                    isWalkable = true;
                }
            }
        }
        if (isWalkable) {
            nodeType = AdvancedWalkNodeProcessor.func_237232_a_((IBlockReader)blockaccessIn, (BlockPos.Mutable)pos.func_181079_c(x, y, z), (PathNodeType)PathNodeType.WALKABLE);
        }
        return AdvancedWalkNodeProcessor.packNodeType(nodeType, packed);
    }

    protected static boolean isColliderNodeType(PathNodeType type) {
        return type == PathNodeType.BLOCKED || type == PathNodeType.TRAPDOOR || type == PathNodeType.FENCE || type == PathNodeType.DOOR_WOOD_CLOSED || type == PathNodeType.DOOR_IRON_CLOSED || type == PathNodeType.LEAVES || type == PathNodeType.STICKY_HONEY || type == PathNodeType.COCOA;
    }
}

