/*
 * Decompiled with CFR 0.152.
 */
package tcb.spiderstpo.mixins;

import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapeSpliterator;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import org.apache.commons.lang3.tuple.Pair;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tcb.spiderstpo.common.CollisionSmoothingUtil;
import tcb.spiderstpo.common.Matrix4f;
import tcb.spiderstpo.common.entity.mob.IClimberEntity;
import tcb.spiderstpo.common.entity.mob.IEntityMovementHook;
import tcb.spiderstpo.common.entity.mob.IEntityReadWriteHook;
import tcb.spiderstpo.common.entity.mob.IEntityRegisterDataHook;
import tcb.spiderstpo.common.entity.mob.ILivingEntityDataManagerHook;
import tcb.spiderstpo.common.entity.mob.ILivingEntityJumpHook;
import tcb.spiderstpo.common.entity.mob.ILivingEntityLookAtHook;
import tcb.spiderstpo.common.entity.mob.ILivingEntityRotationHook;
import tcb.spiderstpo.common.entity.mob.ILivingEntityTravelHook;
import tcb.spiderstpo.common.entity.mob.IMobEntityLivingTickHook;
import tcb.spiderstpo.common.entity.mob.IMobEntityTickHook;
import tcb.spiderstpo.common.entity.mob.Orientation;
import tcb.spiderstpo.common.entity.mob.PathingTarget;
import tcb.spiderstpo.common.entity.movement.BetterSpiderPathNavigator;
import tcb.spiderstpo.common.entity.movement.ClimberJumpController;
import tcb.spiderstpo.common.entity.movement.ClimberLookController;
import tcb.spiderstpo.common.entity.movement.ClimberMoveController;
import tcb.spiderstpo.common.entity.movement.DirectionalPathPoint;

@Mixin(value={SpiderEntity.class})
public abstract class ClimberEntityMixin
extends CreatureEntity
implements IClimberEntity,
IMobEntityLivingTickHook,
ILivingEntityLookAtHook,
IMobEntityTickHook,
ILivingEntityRotationHook,
ILivingEntityDataManagerHook,
ILivingEntityTravelHook,
IEntityMovementHook,
IEntityReadWriteHook,
IEntityRegisterDataHook,
ILivingEntityJumpHook {
    private static final UUID SLOW_FALLING_ID = UUID.fromString("A5B6CF2A-2F7C-31EF-9022-7C3E7D5E6ABA");
    private static final AttributeModifier SLOW_FALLING = new AttributeModifier(SLOW_FALLING_ID, "Slow falling acceleration reduction", -0.07, AttributeModifier.Operation.ADDITION);
    private static final DataParameter<Float> MOVEMENT_TARGET_X;
    private static final DataParameter<Float> MOVEMENT_TARGET_Y;
    private static final DataParameter<Float> MOVEMENT_TARGET_Z;
    private static final ImmutableList<DataParameter<Optional<BlockPos>>> PATHING_TARGETS;
    private static final ImmutableList<DataParameter<Direction>> PATHING_SIDES;
    private static final DataParameter<Rotations> ROTATION_BODY;
    private static final DataParameter<Rotations> ROTATION_HEAD;
    private double prevAttachmentOffsetX;
    private double prevAttachmentOffsetY;
    private double prevAttachmentOffsetZ;
    private double attachmentOffsetX;
    private double attachmentOffsetY;
    private double attachmentOffsetZ;
    private Vector3d attachmentNormal = new Vector3d(0.0, 1.0, 0.0);
    private Vector3d prevAttachmentNormal = new Vector3d(0.0, 1.0, 0.0);
    private float prevOrientationYawDelta;
    private float orientationYawDelta;
    private double lastAttachmentOffsetX;
    private double lastAttachmentOffsetY;
    private double lastAttachmentOffsetZ;
    private Vector3d lastAttachmentOrientationNormal = new Vector3d(0.0, 1.0, 0.0);
    private int attachedTicks = 5;
    private Vector3d attachedSides = new Vector3d(0.0, 0.0, 0.0);
    private Vector3d prevAttachedSides = new Vector3d(0.0, 0.0, 0.0);
    private boolean canClimbInWater = false;
    private boolean canClimbInLava = false;
    private boolean isTravelingInFluid = false;
    private float collisionsInclusionRange = 2.0f;
    private float collisionsSmoothingRange = 1.25f;
    private Orientation orientation;
    private Pair<Direction, Vector3d> groundDirecton;
    private Orientation renderOrientation;
    private float nextStepDistance;
    private float nextFlap;
    private Vector3d preWalkingPosition;
    private double preMoveY;
    private Vector3d jumpDir;

    private ClimberEntityMixin(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(method={"<init>*"}, at={@At(value="RETURN")})
    private void onConstructed(CallbackInfo ci) {
        this.field_70138_W = 0.1f;
        this.orientation = this.calculateOrientation(1.0f);
        this.groundDirecton = this.getGroundDirection();
        this.field_70765_h = new ClimberMoveController<ClimberEntityMixin>(this);
        this.field_70749_g = new ClimberLookController<ClimberEntityMixin>(this);
        this.field_70767_i = new ClimberJumpController<ClimberEntityMixin>(this);
    }

    @Inject(method={"createNavigator(Lnet/minecraft/world/World;)Lnet/minecraft/pathfinding/PathNavigator;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCreateNavigator(World world, CallbackInfoReturnable<PathNavigator> ci) {
        BetterSpiderPathNavigator<ClimberEntityMixin> navigate = new BetterSpiderPathNavigator<ClimberEntityMixin>(this, world, false);
        navigate.func_212239_d(true);
        ci.setReturnValue(navigate);
    }

    @Override
    public void onRegisterData() {
        if (this.shouldTrackPathingTargets()) {
            this.field_70180_af.func_187214_a(MOVEMENT_TARGET_X, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(MOVEMENT_TARGET_Y, (Object)Float.valueOf(0.0f));
            this.field_70180_af.func_187214_a(MOVEMENT_TARGET_Z, (Object)Float.valueOf(0.0f));
            for (DataParameter pathingTarget : PATHING_TARGETS) {
                this.field_70180_af.func_187214_a(pathingTarget, Optional.empty());
            }
            for (DataParameter pathingSide : PATHING_SIDES) {
                this.field_70180_af.func_187214_a(pathingSide, (Object)Direction.DOWN);
            }
        }
        this.field_70180_af.func_187214_a(ROTATION_BODY, (Object)new Rotations(0.0f, 0.0f, 0.0f));
        this.field_70180_af.func_187214_a(ROTATION_HEAD, (Object)new Rotations(0.0f, 0.0f, 0.0f));
    }

    @Override
    public void onWrite(CompoundNBT nbt) {
        nbt.func_74780_a("SpidersTPO.AttachmentNormalX", this.attachmentNormal.field_72450_a);
        nbt.func_74780_a("SpidersTPO.AttachmentNormalY", this.attachmentNormal.field_72448_b);
        nbt.func_74780_a("SpidersTPO.AttachmentNormalZ", this.attachmentNormal.field_72449_c);
        nbt.func_74768_a("SpidersTPO.AttachedTicks", this.attachedTicks);
    }

    @Override
    public void onRead(CompoundNBT nbt) {
        this.prevAttachmentNormal = this.attachmentNormal = new Vector3d(nbt.func_74769_h("SpidersTPO.AttachmentNormalX"), nbt.func_74769_h("SpidersTPO.AttachmentNormalY"), nbt.func_74769_h("SpidersTPO.AttachmentNormalZ"));
        this.attachedTicks = nbt.func_74762_e("SpidersTPO.AttachedTicks");
        this.orientation = this.calculateOrientation(1.0f);
    }

    @Override
    public boolean canClimbInWater() {
        return this.canClimbInWater;
    }

    @Override
    public void setCanClimbInWater(boolean value) {
        this.canClimbInWater = value;
    }

    @Override
    public boolean canClimbInLava() {
        return this.canClimbInLava;
    }

    @Override
    public void setCanClimbInLava(boolean value) {
        this.canClimbInLava = value;
    }

    @Override
    public float getCollisionsInclusionRange() {
        return this.collisionsInclusionRange;
    }

    @Override
    public void setCollisionsInclusionRange(float range) {
        this.collisionsInclusionRange = range;
    }

    @Override
    public float getCollisionsSmoothingRange() {
        return this.collisionsSmoothingRange;
    }

    @Override
    public void setCollisionsSmoothingRange(float range) {
        this.collisionsSmoothingRange = range;
    }

    @Override
    public float getBridgePathingMalus(MobEntity entity, BlockPos pos, PathPoint fallPathPoint) {
        return -1.0f;
    }

    @Override
    public void onPathingObstructed(Direction facing) {
    }

    public int func_82143_as() {
        return 0;
    }

    @Override
    public float getMovementSpeed() {
        ModifiableAttributeInstance attribute = this.func_110148_a(Attributes.field_233821_d_);
        return attribute != null ? (float)attribute.func_111126_e() : 1.0f;
    }

    private static double calculateXOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetX) {
        if (other.field_72337_e > aabb.field_72338_b && other.field_72338_b < aabb.field_72337_e && other.field_72334_f > aabb.field_72339_c && other.field_72339_c < aabb.field_72334_f) {
            double dx;
            if (offsetX > 0.0 && other.field_72336_d <= aabb.field_72340_a) {
                double dx2 = aabb.field_72340_a - other.field_72336_d;
                if (dx2 < offsetX) {
                    offsetX = dx2;
                }
            } else if (offsetX < 0.0 && other.field_72340_a >= aabb.field_72336_d && (dx = aabb.field_72336_d - other.field_72340_a) > offsetX) {
                offsetX = dx;
            }
            return offsetX;
        }
        return offsetX;
    }

    private static double calculateYOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetY) {
        if (other.field_72336_d > aabb.field_72340_a && other.field_72340_a < aabb.field_72336_d && other.field_72334_f > aabb.field_72339_c && other.field_72339_c < aabb.field_72334_f) {
            double dy;
            if (offsetY > 0.0 && other.field_72337_e <= aabb.field_72338_b) {
                double dy2 = aabb.field_72338_b - other.field_72337_e;
                if (dy2 < offsetY) {
                    offsetY = dy2;
                }
            } else if (offsetY < 0.0 && other.field_72338_b >= aabb.field_72337_e && (dy = aabb.field_72337_e - other.field_72338_b) > offsetY) {
                offsetY = dy;
            }
            return offsetY;
        }
        return offsetY;
    }

    private static double calculateZOffset(AxisAlignedBB aabb, AxisAlignedBB other, double offsetZ) {
        if (other.field_72336_d > aabb.field_72340_a && other.field_72340_a < aabb.field_72336_d && other.field_72337_e > aabb.field_72338_b && other.field_72338_b < aabb.field_72337_e) {
            double dz;
            if (offsetZ > 0.0 && other.field_72334_f <= aabb.field_72339_c) {
                double dz2 = aabb.field_72339_c - other.field_72334_f;
                if (dz2 < offsetZ) {
                    offsetZ = dz2;
                }
            } else if (offsetZ < 0.0 && other.field_72339_c >= aabb.field_72334_f && (dz = aabb.field_72334_f - other.field_72339_c) > offsetZ) {
                offsetZ = dz;
            }
            return offsetZ;
        }
        return offsetZ;
    }

    private void updateWalkingSide() {
        Object avoidPathingFacing = null;
        AxisAlignedBB entityBox = this.func_174813_aQ();
        double closestFacingDst = Double.MAX_VALUE;
        Direction closestFacing = null;
        Vector3d weighting = new Vector3d(0.0, 0.0, 0.0);
        float stickingDistance = this.field_191988_bg != 0.0f ? 1.5f : 0.1f;
        for (Direction facing : Direction.values()) {
            if (avoidPathingFacing == facing) continue;
            List<AxisAlignedBB> collisionBoxes = this.getCollisionBoxes(entityBox.func_186662_g((double)0.2f).func_72321_a((double)((float)facing.func_82601_c() * stickingDistance), (double)((float)facing.func_96559_d() * stickingDistance), (double)((float)facing.func_82599_e() * stickingDistance)));
            double closestDst = Double.MAX_VALUE;
            for (AxisAlignedBB collisionBox : collisionBoxes) {
                switch (facing) {
                    case EAST: 
                    case WEST: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateXOffset(entityBox, collisionBox, (float)(-facing.func_82601_c()) * stickingDistance)));
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateYOffset(entityBox, collisionBox, (float)(-facing.func_96559_d()) * stickingDistance)));
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        closestDst = Math.min(closestDst, Math.abs(ClimberEntityMixin.calculateZOffset(entityBox, collisionBox, (float)(-facing.func_82599_e()) * stickingDistance)));
                    }
                }
            }
            if (closestDst < closestFacingDst) {
                closestFacingDst = closestDst;
                closestFacing = facing;
            }
            if (!(closestDst < Double.MAX_VALUE)) continue;
            weighting = weighting.func_178787_e(new Vector3d((double)facing.func_82601_c(), (double)facing.func_96559_d(), (double)facing.func_82599_e()).func_186678_a(1.0 - Math.min(closestDst, (double)stickingDistance) / (double)stickingDistance));
        }
        this.groundDirecton = closestFacing == null ? Pair.of((Object)Direction.DOWN, (Object)new Vector3d(0.0, -1.0, 0.0)) : Pair.of(closestFacing, (Object)weighting.func_72432_b().func_72441_c(0.0, (double)-0.001f, 0.0).func_72432_b());
    }

    @Override
    public Pair<Direction, Vector3d> getGroundDirection() {
        return this.groundDirecton;
    }

    @Override
    public Direction getGroundSide() {
        return (Direction)this.groundDirecton.getKey();
    }

    @Override
    public Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    public void setRenderOrientation(Orientation orientation) {
        this.renderOrientation = orientation;
    }

    @Override
    public Orientation getRenderOrientation() {
        return this.renderOrientation;
    }

    @Override
    public float getAttachmentOffset(Direction.Axis axis, float partialTicks) {
        switch (axis) {
            default: {
                return (float)(this.prevAttachmentOffsetX + (this.attachmentOffsetX - this.prevAttachmentOffsetX) * (double)partialTicks);
            }
            case Y: {
                return (float)(this.prevAttachmentOffsetY + (this.attachmentOffsetY - this.prevAttachmentOffsetY) * (double)partialTicks);
            }
            case Z: 
        }
        return (float)(this.prevAttachmentOffsetZ + (this.attachmentOffsetZ - this.prevAttachmentOffsetZ) * (double)partialTicks);
    }

    @Override
    public Vector3d onLookAt(EntityAnchorArgument.Type anchor, Vector3d vec) {
        Vector3d dir = vec.func_178788_d(this.func_213303_ch());
        dir = this.getOrientation().getLocal(dir);
        return dir;
    }

    @Override
    public void onTick() {
        block13: {
            ChunkManager.EntityTracker entityTracker;
            if (this.field_70170_p.field_72995_K || !(this.field_70170_p instanceof ServerWorld) || (entityTracker = (ChunkManager.EntityTracker)((ServerWorld)this.field_70170_p).func_72863_F().field_217237_a.field_219272_z.get(this.func_145782_y())) == null || entityTracker.field_219402_b.field_219472_n % entityTracker.field_219402_b.field_219462_d != 0) break block13;
            Orientation orientation = this.getOrientation();
            Vector3d look = orientation.getGlobal(this.field_70177_z, this.field_70125_A);
            this.field_70180_af.func_187227_b(ROTATION_BODY, (Object)new Rotations((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c));
            look = orientation.getGlobal(this.field_70759_as, 0.0f);
            this.field_70180_af.func_187227_b(ROTATION_HEAD, (Object)new Rotations((float)look.field_72450_a, (float)look.field_72448_b, (float)look.field_72449_c));
            if (this.shouldTrackPathingTargets()) {
                if (this.field_70702_br != 0.0f) {
                    Vector3d forwardVector = orientation.getGlobal(this.field_70177_z, 0.0f);
                    Vector3d strafeVector = orientation.getGlobal(this.field_70177_z + 90.0f, 0.0f);
                    Vector3d offset = forwardVector.func_186678_a((double)this.field_191988_bg).func_178787_e(strafeVector.func_186678_a((double)this.field_70702_br)).func_72432_b();
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_X, (Object)Float.valueOf((float)(this.func_226277_ct_() + offset.field_72450_a)));
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_Y, (Object)Float.valueOf((float)(this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + offset.field_72448_b)));
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_Z, (Object)Float.valueOf((float)(this.func_226281_cx_() + offset.field_72449_c)));
                } else {
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_X, (Object)Float.valueOf((float)this.func_70605_aq().func_179917_d()));
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_Y, (Object)Float.valueOf((float)this.func_70605_aq().func_179919_e()));
                    this.field_70180_af.func_187227_b(MOVEMENT_TARGET_Z, (Object)Float.valueOf((float)this.func_70605_aq().func_179918_f()));
                }
                Path path = this.func_70661_as().func_75505_d();
                if (path != null) {
                    int i = 0;
                    for (DataParameter pathingTarget : PATHING_TARGETS) {
                        DataParameter pathingSide = (DataParameter)PATHING_SIDES.get(i);
                        if (path.func_75873_e() + i < path.func_75874_d()) {
                            PathPoint point = path.func_75877_a(path.func_75873_e() + i);
                            this.field_70180_af.func_187227_b(pathingTarget, Optional.of(new BlockPos(point.field_75839_a, point.field_75837_b, point.field_75838_c)));
                            if (point instanceof DirectionalPathPoint) {
                                Direction dir = ((DirectionalPathPoint)point).getPathSide();
                                if (dir != null) {
                                    this.field_70180_af.func_187227_b(pathingSide, (Object)dir);
                                } else {
                                    this.field_70180_af.func_187227_b(pathingSide, (Object)Direction.DOWN);
                                }
                            }
                        } else {
                            this.field_70180_af.func_187227_b(pathingTarget, Optional.empty());
                            this.field_70180_af.func_187227_b(pathingSide, (Object)Direction.DOWN);
                        }
                        ++i;
                    }
                } else {
                    for (DataParameter pathingTarget : PATHING_TARGETS) {
                        this.field_70180_af.func_187227_b(pathingTarget, Optional.empty());
                    }
                    for (DataParameter pathingSide : PATHING_SIDES) {
                        this.field_70180_af.func_187227_b(pathingSide, (Object)Direction.DOWN);
                    }
                }
            }
        }
    }

    @Override
    public void onLivingTick() {
        this.updateWalkingSide();
    }

    public boolean func_70617_f_() {
        return false;
    }

    @Override
    @Nullable
    public Vector3d getTrackedMovementTarget() {
        if (this.shouldTrackPathingTargets()) {
            return new Vector3d((double)((Float)this.field_70180_af.func_187225_a(MOVEMENT_TARGET_X)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(MOVEMENT_TARGET_Y)).floatValue(), (double)((Float)this.field_70180_af.func_187225_a(MOVEMENT_TARGET_Z)).floatValue());
        }
        return null;
    }

    @Override
    @Nullable
    public List<PathingTarget> getTrackedPathingTargets() {
        if (this.shouldTrackPathingTargets()) {
            ArrayList<PathingTarget> pathingTargets = new ArrayList<PathingTarget>(PATHING_TARGETS.size());
            int i = 0;
            for (DataParameter key : PATHING_TARGETS) {
                BlockPos pos = ((Optional)this.field_70180_af.func_187225_a(key)).orElse(null);
                if (pos != null) {
                    pathingTargets.add(new PathingTarget(pos, (Direction)this.field_70180_af.func_187225_a((DataParameter)PATHING_SIDES.get(i))));
                }
                ++i;
            }
            return pathingTargets;
        }
        return null;
    }

    @Override
    public float getVerticalOffset(float partialTicks) {
        return 0.075f;
    }

    private void forEachCollisonBox(AxisAlignedBB aabb, VoxelShapes.ILineConsumer action) {
        int minChunkX = MathHelper.func_76128_c((double)(aabb.field_72340_a - 1.0E-7)) - 1 >> 4;
        int maxChunkX = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0E-7)) + 1 >> 4;
        int minChunkZ = MathHelper.func_76128_c((double)(aabb.field_72339_c - 1.0E-7)) - 1 >> 4;
        int maxChunkZ = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0E-7)) + 1 >> 4;
        int width = maxChunkX - minChunkX + 1;
        int depth = maxChunkZ - minChunkZ + 1;
        IBlockReader[] blockReaderCache = new IBlockReader[width * depth];
        World collisionReader = this.field_70170_p;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                blockReaderCache[cx - minChunkX + (cz - minChunkZ) * width] = collisionReader.func_225522_c_(cx, cz);
            }
        }
        ICollisionReader cachedCollisionReader = new ICollisionReader((ICollisionReader)collisionReader, blockReaderCache, minChunkX, minChunkZ, width){
            final /* synthetic */ ICollisionReader val$collisionReader;
            final /* synthetic */ IBlockReader[] val$blockReaderCache;
            final /* synthetic */ int val$minChunkX;
            final /* synthetic */ int val$minChunkZ;
            final /* synthetic */ int val$width;
            {
                this.val$collisionReader = iCollisionReader;
                this.val$blockReaderCache = iBlockReaderArray;
                this.val$minChunkX = n;
                this.val$minChunkZ = n2;
                this.val$width = n3;
            }

            public TileEntity func_175625_s(BlockPos pos) {
                return this.val$collisionReader.func_175625_s(pos);
            }

            public BlockState func_180495_p(BlockPos pos) {
                return this.val$collisionReader.func_180495_p(pos);
            }

            public FluidState func_204610_c(BlockPos pos) {
                return this.val$collisionReader.func_204610_c(pos);
            }

            public WorldBorder func_175723_af() {
                return this.val$collisionReader.func_175723_af();
            }

            public Stream<VoxelShape> func_230318_c_(Entity entity, AxisAlignedBB aabb, Predicate<Entity> predicate) {
                return this.val$collisionReader.func_230318_c_(entity, aabb, predicate);
            }

            public IBlockReader func_225522_c_(int chunkX, int chunkZ) {
                return this.val$blockReaderCache[chunkX - this.val$minChunkX + (chunkZ - this.val$minChunkZ) * this.val$width];
            }
        };
        Stream<VoxelShape> shapes = StreamSupport.stream(new VoxelShapeSpliterator(cachedCollisionReader, (Entity)this, aabb, this::canClimbOnBlock), false);
        shapes.forEach(shape -> shape.func_197755_b(action));
    }

    private List<AxisAlignedBB> getCollisionBoxes(AxisAlignedBB aabb) {
        ArrayList<AxisAlignedBB> boxes = new ArrayList<AxisAlignedBB>();
        this.forEachCollisonBox(aabb, (minX, minY, minZ, maxX, maxY, maxZ) -> boxes.add(new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ)));
        return boxes;
    }

    @Override
    public boolean canClimbOnBlock(BlockState state, BlockPos pos) {
        return true;
    }

    @Override
    public float getBlockSlipperiness(BlockPos pos) {
        BlockState offsetState = this.field_70170_p.func_180495_p(pos);
        return offsetState.func_177230_c().getSlipperiness(offsetState, (IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.91f;
    }

    private void updateOffsetsAndOrientation() {
        Vector3d direction = this.getOrientation().getGlobal(this.field_70177_z, this.field_70125_A);
        boolean isAttached = false;
        double baseStickingOffsetX = 0.0;
        double baseStickingOffsetY = this.getVerticalOffset(1.0f);
        double baseStickingOffsetZ = 0.0;
        Vector3d baseOrientationNormal = new Vector3d(0.0, 1.0, 0.0);
        if (!this.isTravelingInFluid && this.field_70122_E && this.func_184187_bx() == null) {
            Vector3d p = this.func_213303_ch();
            Vector3d s = p.func_72441_c(0.0, (double)(this.func_213302_cg() * 0.5f), 0.0);
            AxisAlignedBB inclusionBox = new AxisAlignedBB(s.field_72450_a, s.field_72448_b, s.field_72449_c, s.field_72450_a, s.field_72448_b, s.field_72449_c).func_186662_g((double)this.collisionsInclusionRange);
            Pair<Vector3d, Vector3d> attachmentPoint = CollisionSmoothingUtil.findClosestPoint(consumer -> this.forEachCollisonBox(inclusionBox, (VoxelShapes.ILineConsumer)consumer), s, this.attachmentNormal.func_186678_a(-1.0), this.collisionsSmoothingRange, 1.0f, 0.001f, 20, 0.05f, s);
            AxisAlignedBB entityBox = this.func_174813_aQ();
            if (attachmentPoint != null) {
                double dz;
                double dy;
                Vector3d attachmentPos = (Vector3d)attachmentPoint.getLeft();
                double dx = Math.max(entityBox.field_72340_a - attachmentPos.field_72450_a, attachmentPos.field_72450_a - entityBox.field_72336_d);
                if (Math.max(dx, Math.max(dy = Math.max(entityBox.field_72338_b - attachmentPos.field_72448_b, attachmentPos.field_72448_b - entityBox.field_72337_e), dz = Math.max(entityBox.field_72339_c - attachmentPos.field_72449_c, attachmentPos.field_72449_c - entityBox.field_72334_f))) < 0.5) {
                    isAttached = true;
                    this.lastAttachmentOffsetX = MathHelper.func_151237_a((double)(attachmentPos.field_72450_a - p.field_72450_a), (double)(-this.func_213311_cf() / 2.0f), (double)(this.func_213311_cf() / 2.0f));
                    this.lastAttachmentOffsetY = MathHelper.func_151237_a((double)(attachmentPos.field_72448_b - p.field_72448_b), (double)0.0, (double)this.func_213302_cg());
                    this.lastAttachmentOffsetZ = MathHelper.func_151237_a((double)(attachmentPos.field_72449_c - p.field_72449_c), (double)(-this.func_213311_cf() / 2.0f), (double)(this.func_213311_cf() / 2.0f));
                    this.lastAttachmentOrientationNormal = (Vector3d)attachmentPoint.getRight();
                }
            }
        }
        this.prevAttachmentOffsetX = this.attachmentOffsetX;
        this.prevAttachmentOffsetY = this.attachmentOffsetY;
        this.prevAttachmentOffsetZ = this.attachmentOffsetZ;
        this.prevAttachmentNormal = this.attachmentNormal;
        float attachmentBlend = (float)this.attachedTicks * 0.2f;
        this.attachmentOffsetX = baseStickingOffsetX + (this.lastAttachmentOffsetX - baseStickingOffsetX) * (double)attachmentBlend;
        this.attachmentOffsetY = baseStickingOffsetY + (this.lastAttachmentOffsetY - baseStickingOffsetY) * (double)attachmentBlend;
        this.attachmentOffsetZ = baseStickingOffsetZ + (this.lastAttachmentOffsetZ - baseStickingOffsetZ) * (double)attachmentBlend;
        this.attachmentNormal = baseOrientationNormal.func_178787_e(this.lastAttachmentOrientationNormal.func_178788_d(baseOrientationNormal).func_186678_a((double)attachmentBlend)).func_72432_b();
        this.attachedTicks = !isAttached ? Math.max(0, this.attachedTicks - 1) : Math.min(5, this.attachedTicks + 1);
        this.orientation = this.calculateOrientation(1.0f);
        Pair<Float, Float> newRotations = this.getOrientation().getLocalRotation(direction);
        float yawDelta = ((Float)newRotations.getLeft()).floatValue() - this.field_70177_z;
        float pitchDelta = ((Float)newRotations.getRight()).floatValue() - this.field_70125_A;
        this.prevOrientationYawDelta = this.orientationYawDelta;
        this.orientationYawDelta = yawDelta;
        this.field_70177_z = MathHelper.func_76142_g((float)(this.field_70177_z + yawDelta));
        this.field_70126_B = this.wrapAngleInRange(this.field_70126_B, this.field_70177_z);
        this.field_184626_bk = MathHelper.func_76138_g((double)(this.field_184626_bk + (double)yawDelta));
        this.field_70761_aq = MathHelper.func_76142_g((float)(this.field_70761_aq + yawDelta));
        this.field_70760_ar = this.wrapAngleInRange(this.field_70760_ar, this.field_70761_aq);
        this.field_70759_as = MathHelper.func_76142_g((float)(this.field_70759_as + yawDelta));
        this.field_70758_at = this.wrapAngleInRange(this.field_70758_at, this.field_70759_as);
        this.field_208001_bq = MathHelper.func_76138_g((double)(this.field_208001_bq + (double)yawDelta));
        this.field_70125_A = MathHelper.func_76142_g((float)(this.field_70125_A + pitchDelta));
        this.field_70127_C = this.wrapAngleInRange(this.field_70127_C, this.field_70125_A);
        this.field_70709_bj = MathHelper.func_76138_g((double)(this.field_70709_bj + (double)pitchDelta));
    }

    private float wrapAngleInRange(float angle, float target) {
        while (target - angle < -180.0f) {
            angle -= 360.0f;
        }
        while (target - angle >= 180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    @Override
    public Orientation calculateOrientation(float partialTicks) {
        Vector3d attachmentNormal = this.prevAttachmentNormal.func_178787_e(this.attachmentNormal.func_178788_d(this.prevAttachmentNormal).func_186678_a((double)partialTicks));
        Vector3d localZ = new Vector3d(0.0, 0.0, 1.0);
        Vector3d localY = new Vector3d(0.0, 1.0, 0.0);
        Vector3d localX = new Vector3d(1.0, 0.0, 0.0);
        float componentZ = (float)localZ.func_72430_b(attachmentNormal);
        float componentX = (float)localX.func_72430_b(attachmentNormal);
        float yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)componentX, (double)componentZ));
        localZ = new Vector3d(Math.sin(Math.toRadians(yaw)), 0.0, Math.cos(Math.toRadians(yaw)));
        localY = new Vector3d(0.0, 1.0, 0.0);
        localX = new Vector3d(Math.sin(Math.toRadians(yaw - 90.0f)), 0.0, Math.cos(Math.toRadians(yaw - 90.0f)));
        componentZ = (float)localZ.func_72430_b(attachmentNormal);
        float componentY = (float)localY.func_72430_b(attachmentNormal);
        componentX = (float)localX.func_72430_b(attachmentNormal);
        float pitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)MathHelper.func_76129_c((float)(componentX * componentX + componentZ * componentZ)), (double)componentY));
        Matrix4f m = new Matrix4f();
        m.multiply(new Matrix4f((float)Math.toRadians(yaw), 0.0f, 1.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(pitch), 1.0f, 0.0f, 0.0f));
        m.multiply(new Matrix4f((float)Math.toRadians(Math.signum(0.5f - componentY - componentZ - componentX) * yaw), 0.0f, 1.0f, 0.0f));
        localZ = m.multiply(new Vector3d(0.0, 0.0, -1.0));
        localY = m.multiply(new Vector3d(0.0, 1.0, 0.0));
        localX = m.multiply(new Vector3d(1.0, 0.0, 0.0));
        return new Orientation(attachmentNormal, localZ, localY, localX, componentZ, componentY, componentX, yaw, pitch);
    }

    @Override
    public float getTargetYaw(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        return (float)this.field_184626_bk;
    }

    @Override
    public float getTargetPitch(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        return (float)this.field_70709_bj;
    }

    @Override
    public float getTargetHeadYaw(float yaw, int rotationIncrements) {
        return (float)this.field_208001_bq;
    }

    @Override
    public void onNotifyDataManagerChange(DataParameter<?> key) {
        if (ROTATION_BODY.equals(key)) {
            Rotations rotation = (Rotations)this.field_70180_af.func_187225_a(ROTATION_BODY);
            Vector3d look = new Vector3d((double)rotation.func_179415_b(), (double)rotation.func_179416_c(), (double)rotation.func_179413_d());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.field_184626_bk = ((Float)rotations.getLeft()).floatValue();
            this.field_70709_bj = ((Float)rotations.getRight()).floatValue();
        } else if (ROTATION_HEAD.equals(key)) {
            Rotations rotation = (Rotations)this.field_70180_af.func_187225_a(ROTATION_HEAD);
            Vector3d look = new Vector3d((double)rotation.func_179415_b(), (double)rotation.func_179416_c(), (double)rotation.func_179413_d());
            Pair<Float, Float> rotations = this.getOrientation().getLocalRotation(look);
            this.field_208001_bq = ((Float)rotations.getLeft()).floatValue();
            this.field_208002_br = 3;
        }
    }

    private double getGravity() {
        boolean isFalling;
        if (this.func_189652_ae()) {
            return 0.0;
        }
        ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        boolean bl = isFalling = this.func_213322_ci().field_72448_b <= 0.0;
        if (isFalling && this.func_70644_a(Effects.field_204839_B)) {
            if (!gravity.func_180374_a(SLOW_FALLING)) {
                gravity.func_233767_b_(SLOW_FALLING);
            }
        } else if (gravity.func_180374_a(SLOW_FALLING)) {
            gravity.func_111124_b(SLOW_FALLING);
        }
        return gravity.func_111126_e();
    }

    private Vector3d getStickingForce(Pair<Direction, Vector3d> walkingSide) {
        double uprightness = Math.max(this.attachmentNormal.field_72448_b, 0.0);
        double gravity = this.getGravity();
        double stickingForce = gravity * uprightness + 0.08 * (1.0 - uprightness);
        return ((Vector3d)walkingSide.getRight()).func_186678_a(stickingForce);
    }

    @Override
    public void setJumpDirection(Vector3d dir) {
        this.jumpDir = dir != null ? dir.func_72432_b() : null;
    }

    @Override
    public boolean onJump() {
        if (this.jumpDir != null) {
            float jumpStrength = this.func_175134_bD();
            if (this.func_70644_a(Effects.field_76430_j)) {
                jumpStrength += 0.1f * (float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1);
            }
            Vector3d motion = this.func_213322_ci();
            Vector3d orthogonalMotion = this.jumpDir.func_186678_a(this.jumpDir.func_72430_b(motion));
            Vector3d tangentialMotion = motion.func_178788_d(orthogonalMotion);
            this.func_213293_j(tangentialMotion.field_72450_a + this.jumpDir.field_72450_a * (double)jumpStrength, tangentialMotion.field_72448_b + this.jumpDir.field_72448_b * (double)jumpStrength, tangentialMotion.field_72449_c + this.jumpDir.field_72449_c * (double)jumpStrength);
            if (this.func_70051_ag()) {
                Vector3d boost = this.getOrientation().getGlobal(this.field_70177_z, 0.0f).func_186678_a((double)0.2f);
                this.func_213317_d(this.func_213322_ci().func_178787_e(boost));
            }
            this.field_70160_al = true;
            ForgeHooks.onLivingJump((LivingEntity)this);
            return true;
        }
        return false;
    }

    @Override
    public boolean onTravel(Vector3d relative, boolean pre) {
        if (pre) {
            boolean canTravel = this.func_70613_aW() || this.func_184186_bw();
            this.isTravelingInFluid = false;
            FluidState fluidState = this.field_70170_p.func_204610_c(this.func_233580_cy_());
            if (!this.canClimbInWater && this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidState.func_206886_c())) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (!this.canClimbInLava && this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidState.func_206886_c())) {
                this.isTravelingInFluid = true;
                if (canTravel) {
                    return false;
                }
            } else if (canTravel) {
                this.travelOnGround(relative);
            }
            if (!canTravel) {
                this.func_233629_a_((LivingEntity)this, true);
            }
            this.updateOffsetsAndOrientation();
            return true;
        }
        this.updateOffsetsAndOrientation();
        return false;
    }

    private float getRelevantMoveFactor(float slipperiness) {
        return this.field_70122_E ? this.func_70689_ay() * (0.16277136f / (slipperiness * slipperiness * slipperiness)) : this.field_70747_aH;
    }

    private void travelOnGround(Vector3d relative) {
        boolean detachedZ;
        boolean isFalling;
        Orientation orientation = this.getOrientation();
        Vector3d forwardVector = orientation.getGlobal(this.field_70177_z, 0.0f);
        Vector3d strafeVector = orientation.getGlobal(this.field_70177_z + 90.0f, 0.0f);
        Vector3d upVector = orientation.getGlobal(this.field_70177_z, -90.0f);
        Pair<Direction, Vector3d> groundDirection = this.getGroundDirection();
        Vector3d stickingForce = this.getStickingForce(groundDirection);
        boolean bl = isFalling = this.func_213322_ci().field_72448_b <= 0.0;
        if (isFalling && this.func_70644_a(Effects.field_204839_B)) {
            this.field_70143_R = 0.0f;
        }
        float forward = (float)relative.field_72449_c;
        float strafe = (float)relative.field_72450_a;
        if (forward != 0.0f || strafe != 0.0f) {
            float f;
            float slipperiness = 0.91f;
            if (this.field_70122_E) {
                BlockPos offsetPos = new BlockPos(this.func_213303_ch()).func_177972_a((Direction)groundDirection.getLeft());
                slipperiness = this.getBlockSlipperiness(offsetPos);
            }
            if ((f = forward * forward + strafe * strafe) >= 1.0E-4f) {
                boolean isInnerCorner;
                f = Math.max(MathHelper.func_76129_c((float)f), 1.0f);
                f = this.getRelevantMoveFactor(slipperiness) / f;
                Vector3d movementOffset = new Vector3d(forwardVector.field_72450_a * (double)(forward *= f) + strafeVector.field_72450_a * (double)(strafe *= f), forwardVector.field_72448_b * (double)forward + strafeVector.field_72448_b * (double)strafe, forwardVector.field_72449_c * (double)forward + strafeVector.field_72449_c * (double)strafe);
                double px = this.func_226277_ct_();
                double py = this.func_226278_cu_();
                double pz = this.func_226281_cx_();
                Vector3d motion = this.func_213322_ci();
                AxisAlignedBB aabb = this.func_174813_aQ();
                this.func_213315_a(MoverType.SELF, movementOffset);
                Vector3d movementDir = new Vector3d(this.func_226277_ct_() - px, this.func_226278_cu_() - py, this.func_226281_cx_() - pz).func_72432_b();
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.func_213317_d(motion);
                Vector3d probeVector = new Vector3d(Math.abs(movementDir.field_72450_a) < 0.001 ? -Math.signum(upVector.field_72450_a) : 0.0, Math.abs(movementDir.field_72448_b) < 0.001 ? -Math.signum(upVector.field_72448_b) : 0.0, Math.abs(movementDir.field_72449_c) < 0.001 ? -Math.signum(upVector.field_72449_c) : 0.0).func_72432_b().func_186678_a(1.0E-4);
                this.func_213315_a(MoverType.SELF, probeVector);
                Vector3d collisionNormal = new Vector3d(Math.abs(this.func_226277_ct_() - px - probeVector.field_72450_a) > 1.0E-6 ? Math.signum(-probeVector.field_72450_a) : 0.0, Math.abs(this.func_226278_cu_() - py - probeVector.field_72448_b) > 1.0E-6 ? Math.signum(-probeVector.field_72448_b) : 0.0, Math.abs(this.func_226281_cx_() - pz - probeVector.field_72449_c) > 1.0E-6 ? Math.signum(-probeVector.field_72449_c) : 0.0).func_72432_b();
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.func_213317_d(motion);
                Vector3d surfaceMovementDir = movementDir.func_178788_d(collisionNormal.func_186678_a(collisionNormal.func_72430_b(movementDir))).func_72432_b();
                boolean bl2 = isInnerCorner = Math.abs(collisionNormal.field_72450_a) + Math.abs(collisionNormal.field_72448_b) + Math.abs(collisionNormal.field_72449_c) > (double)1.0001f;
                if (!isInnerCorner) {
                    movementDir = surfaceMovementDir;
                }
                stickingForce = stickingForce.func_178788_d(surfaceMovementDir.func_186678_a(surfaceMovementDir.func_72432_b().func_72430_b(stickingForce)));
                float moveSpeed = MathHelper.func_76129_c((float)(forward * forward + strafe * strafe));
                this.func_213317_d(this.func_213322_ci().func_178787_e(movementDir.func_186678_a((double)moveSpeed)));
            }
        }
        this.func_213317_d(this.func_213322_ci().func_178787_e(stickingForce));
        double px = this.func_226277_ct_();
        double py = this.func_226278_cu_();
        double pz = this.func_226281_cx_();
        Vector3d motion = this.func_213322_ci();
        this.func_213315_a(MoverType.SELF, motion);
        this.prevAttachedSides = this.attachedSides;
        this.attachedSides = new Vector3d(Math.abs(this.func_226277_ct_() - px - motion.field_72450_a) > 0.001 ? -Math.signum(motion.field_72450_a) : 0.0, Math.abs(this.func_226278_cu_() - py - motion.field_72448_b) > 0.001 ? -Math.signum(motion.field_72448_b) : 0.0, Math.abs(this.func_226281_cx_() - pz - motion.field_72449_c) > 0.001 ? -Math.signum(motion.field_72449_c) : 0.0);
        float slipperiness = 0.91f;
        if (this.field_70122_E) {
            this.field_70143_R = 0.0f;
            BlockPos offsetPos = new BlockPos(this.func_213303_ch()).func_177972_a((Direction)groundDirection.getLeft());
            slipperiness = this.getBlockSlipperiness(offsetPos);
        }
        motion = this.func_213322_ci();
        Vector3d orthogonalMotion = upVector.func_186678_a(upVector.func_72430_b(motion));
        Vector3d tangentialMotion = motion.func_178788_d(orthogonalMotion);
        this.func_213293_j(tangentialMotion.field_72450_a * (double)slipperiness + orthogonalMotion.field_72450_a * (double)0.98f, tangentialMotion.field_72448_b * (double)slipperiness + orthogonalMotion.field_72448_b * (double)0.98f, tangentialMotion.field_72449_c * (double)slipperiness + orthogonalMotion.field_72449_c * (double)0.98f);
        boolean detachedX = this.attachedSides.field_72450_a != this.prevAttachedSides.field_72450_a && Math.abs(this.attachedSides.field_72450_a) < 0.001;
        boolean detachedY = this.attachedSides.field_72448_b != this.prevAttachedSides.field_72448_b && Math.abs(this.attachedSides.field_72448_b) < 0.001;
        boolean bl3 = detachedZ = this.attachedSides.field_72449_c != this.prevAttachedSides.field_72449_c && Math.abs(this.attachedSides.field_72449_c) < 0.001;
        if (detachedX || detachedY || detachedZ) {
            float stepHeight = this.field_70138_W;
            this.field_70138_W = 0.0f;
            boolean prevOnGround = this.field_70122_E;
            boolean prevCollidedHorizontally = this.field_70123_F;
            boolean prevCollidedVertically = this.field_70124_G;
            this.func_213315_a(MoverType.SELF, new Vector3d(detachedX ? -this.prevAttachedSides.field_72450_a * 0.25 : 0.0, detachedY ? -this.prevAttachedSides.field_72448_b * 0.25 : 0.0, detachedZ ? -this.prevAttachedSides.field_72449_c * 0.25 : 0.0));
            Vector3d axis = this.prevAttachedSides.func_72432_b();
            Vector3d attachVector = upVector.func_186678_a(-1.0);
            attachVector = attachVector.func_178788_d(axis.func_186678_a(axis.func_72430_b(attachVector)));
            attachVector = Math.abs(attachVector.field_72450_a) > Math.abs(attachVector.field_72448_b) && Math.abs(attachVector.field_72450_a) > Math.abs(attachVector.field_72449_c) ? new Vector3d(Math.signum(attachVector.field_72450_a), 0.0, 0.0) : (Math.abs(attachVector.field_72448_b) > Math.abs(attachVector.field_72449_c) ? new Vector3d(0.0, Math.signum(attachVector.field_72448_b), 0.0) : new Vector3d(0.0, 0.0, Math.signum(attachVector.field_72449_c)));
            double attachDst = motion.func_72433_c() + (double)0.1f;
            AxisAlignedBB aabb = this.func_174813_aQ();
            motion = this.func_213322_ci();
            for (int i = 0; i < 2 && !this.field_70122_E; ++i) {
                this.func_213315_a(MoverType.SELF, attachVector.func_186678_a(attachDst));
            }
            this.field_70138_W = stepHeight;
            if (!this.field_70122_E) {
                this.func_174826_a(aabb);
                this.func_174829_m();
                this.func_213317_d(motion);
                this.field_70122_E = prevOnGround;
                this.field_70123_F = prevCollidedHorizontally;
                this.field_70124_G = prevCollidedVertically;
            } else {
                this.func_213317_d(Vector3d.field_186680_a);
            }
        }
        this.func_233629_a_((LivingEntity)this, true);
    }

    @Override
    public boolean onMove(MoverType type, Vector3d pos, boolean pre) {
        if (pre) {
            this.preWalkingPosition = this.func_213303_ch();
            this.preMoveY = this.func_226278_cu_();
        } else {
            if (Math.abs(this.func_226278_cu_() - this.preMoveY - pos.field_72448_b) > 1.0E-6) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            }
            this.field_70122_E |= this.field_70123_F || this.field_70124_G;
        }
        return false;
    }

    @Override
    public BlockPos getAdjustedOnPosition(BlockPos onPosition) {
        BlockPos posDown;
        BlockState stateDown;
        int z;
        int y;
        float verticalOffset = this.getVerticalOffset(1.0f);
        int x = MathHelper.func_76128_c((double)(this.func_226277_ct_() + this.attachmentOffsetX - (double)((float)this.attachmentNormal.field_72450_a * (verticalOffset + 0.2f))));
        BlockPos pos = new BlockPos(x, y = MathHelper.func_76128_c((double)(this.func_226278_cu_() + this.attachmentOffsetY - (double)((float)this.attachmentNormal.field_72448_b * (verticalOffset + 0.2f)))), z = MathHelper.func_76128_c((double)(this.func_226281_cx_() + this.attachmentOffsetZ - (double)((float)this.attachmentNormal.field_72449_c * (verticalOffset + 0.2f)))));
        if (this.field_70170_p.func_175623_d(pos) && this.attachmentNormal.field_72448_b < 0.0 && (stateDown = this.field_70170_p.func_180495_p(posDown = pos.func_177977_b())).collisionExtendsVertically((IBlockReader)this.field_70170_p, posDown, (Entity)this)) {
            return posDown;
        }
        return pos;
    }

    @Override
    public boolean getAdjustedCanTriggerWalking(boolean canTriggerWalking) {
        if (this.preWalkingPosition != null && this.canClimberTriggerWalking() && !this.func_184218_aH()) {
            Vector3d moved = this.func_213303_ch().func_178788_d(this.preWalkingPosition);
            this.preWalkingPosition = null;
            BlockPos pos = this.func_226268_ag_();
            BlockState state = this.field_70170_p.func_180495_p(pos);
            double dx = moved.field_72450_a;
            double dy = moved.field_72448_b;
            double dz = moved.field_72449_c;
            Vector3d tangentialMovement = moved.func_178788_d(this.attachmentNormal.func_186678_a(this.attachmentNormal.func_72430_b(moved)));
            this.field_70140_Q = (float)((double)this.field_70140_Q + tangentialMovement.func_72433_c() * 0.6);
            this.field_82151_R = (float)((double)this.field_82151_R + (double)MathHelper.func_76133_a((double)(dx * dx + dy * dy + dz * dz)) * 0.6);
            if (this.field_82151_R > this.nextStepDistance && !state.isAir((IBlockReader)this.field_70170_p, pos)) {
                this.nextStepDistance = this.func_203009_ad();
                if (this.func_70090_H()) {
                    ClimberEntityMixin controller = this.func_184207_aI() && this.func_184179_bs() != null ? this.func_184179_bs() : this;
                    float multiplier = controller == this ? 0.35f : 0.4f;
                    Vector3d motion = controller.func_213322_ci();
                    float swimStrength = MathHelper.func_76133_a((double)(motion.field_72450_a * motion.field_72450_a * (double)0.2f + motion.field_72448_b * motion.field_72448_b + motion.field_72449_c * motion.field_72449_c * (double)0.2f)) * multiplier;
                    if (swimStrength > 1.0f) {
                        swimStrength = 1.0f;
                    }
                    this.func_203006_d(swimStrength);
                } else {
                    this.func_180429_a(pos, state);
                }
            } else if (this.field_82151_R > this.nextFlap && this.func_191957_ae() && state.isAir((IBlockReader)this.field_70170_p, pos)) {
                this.nextFlap = this.func_191954_d(this.field_82151_R);
            }
        }
        return false;
    }

    @Override
    public boolean canClimberTriggerWalking() {
        return true;
    }

    static {
        Class<?> cls = MethodHandles.lookup().lookupClass();
        MOVEMENT_TARGET_X = EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187193_c);
        MOVEMENT_TARGET_Y = EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187193_c);
        MOVEMENT_TARGET_Z = EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187193_c);
        ImmutableList.Builder pathingTargets = ImmutableList.builder();
        ImmutableList.Builder pathingSides = ImmutableList.builder();
        for (int i = 0; i < 8; ++i) {
            pathingTargets.add((Object)EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187201_k));
            pathingSides.add((Object)EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187202_l));
        }
        PATHING_TARGETS = pathingTargets.build();
        PATHING_SIDES = pathingSides.build();
        ROTATION_BODY = EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187199_i);
        ROTATION_HEAD = EntityDataManager.func_187226_a(cls, (IDataSerializer)DataSerializers.field_187199_i);
    }
}

