/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.client.map.color.CustomBlockColor;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.RedstoneTorchBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.VineBlock;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;

public class ColorMapLoader
extends ReloadListener<JsonObject> {
    private static final Map<ResourceLocation, BlockColor> BLOCK_ID_TO_COLOR_MAP = new HashMap<ResourceLocation, BlockColor>();

    protected JsonObject prepare(IResourceManager resourceManager, IProfiler profiler) {
        Gson gson = new GsonBuilder().setLenient().create();
        JsonObject object = new JsonObject();
        for (String namespace : resourceManager.func_199001_a()) {
            try {
                for (IResource resource : resourceManager.func_199004_b(new ResourceLocation(namespace, "ftbchunks_block_colors.json"))) {
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.func_199027_b(), StandardCharsets.UTF_8);
                        Throwable throwable = null;
                        try {
                            for (Map.Entry entry : ((JsonObject)gson.fromJson((Reader)reader, JsonObject.class)).entrySet()) {
                                if (((String)entry.getKey()).startsWith("#")) {
                                    object.add("#" + namespace + ":" + ((String)entry.getKey()).substring(1), (JsonElement)entry.getValue());
                                    continue;
                                }
                                object.add(namespace + ":" + (String)entry.getKey(), (JsonElement)entry.getValue());
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (reader == null) continue;
                            if (throwable != null) {
                                try {
                                    ((Reader)reader).close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ((Reader)reader).close();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            catch (Exception exception) {
            }
        }
        return object;
    }

    protected void apply(JsonObject object, IResourceManager resourceManager, IProfiler profiler) {
        BLOCK_ID_TO_COLOR_MAP.clear();
        for (Map.Entry entry : FTBChunks.BLOCK_REGISTRY.entrySet()) {
            Block block = (Block)entry.getValue();
            ResourceLocation id = ((RegistryKey)entry.getKey()).func_240901_a_();
            if (id == null) continue;
            if (block instanceof AirBlock || block instanceof BushBlock || block instanceof FireBlock || block instanceof AbstractButtonBlock || block instanceof TorchBlock && !(block instanceof RedstoneTorchBlock)) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.IGNORED);
                continue;
            }
            if (block instanceof GrassBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.GRASS);
                continue;
            }
            if (block instanceof LeavesBlock || block instanceof VineBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, BlockColors.FOLIAGE);
                continue;
            }
            if (block instanceof FlowerPotBlock) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)6830637)));
                continue;
            }
            if (FTBCUtils.isRail(block)) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)0x888888)));
                continue;
            }
            if (block.func_235697_s_() != null) {
                BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.rgb((int)block.func_235697_s_().field_76291_p)));
                continue;
            }
            BLOCK_ID_TO_COLOR_MAP.put(id, new CustomBlockColor(Color4I.RED));
        }
        for (Map.Entry entry : object.entrySet()) {
            BlockColor col;
            if (!((JsonElement)entry.getValue()).isJsonPrimitive() || (col = BlockColors.getFromType(((JsonElement)entry.getValue()).getAsString())) == null) continue;
            BLOCK_ID_TO_COLOR_MAP.put(new ResourceLocation((String)entry.getKey()), col);
        }
    }

    public static BlockColor getBlockColor(ResourceLocation id) {
        return BLOCK_ID_TO_COLOR_MAP.getOrDefault(id, BlockColors.IGNORED);
    }
}

