/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.core.ExplosionFTBC;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManager;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.architectury.event.CompoundEventResult;
import me.shedaniel.architectury.event.EventResult;
import me.shedaniel.architectury.event.events.BlockEvent;
import me.shedaniel.architectury.event.events.CommandRegistrationEvent;
import me.shedaniel.architectury.event.events.EntityEvent;
import me.shedaniel.architectury.event.events.ExplosionEvent;
import me.shedaniel.architectury.event.events.InteractionEvent;
import me.shedaniel.architectury.event.events.PlayerEvent;
import me.shedaniel.architectury.hooks.PlayerHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.IntValue;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static FTBChunks instance;
    public static FTBChunksCommon PROXY;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final me.shedaniel.architectury.registry.Registry<Block> BLOCK_REGISTRY;
    public static boolean ranksMod;

    public FTBChunks() {
        PROXY = (FTBChunksCommon)EnvExecutor.getEnvSpecific(() -> FTBChunksClient::new, () -> FTBChunksCommon::new);
        ranksMod = Platform.isModLoaded((String)"ftbranks");
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.DELETED.register(this::teamDeleted);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        EntityEvent.ENTER_CHUNK.register(this::chunkChange);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        EntityEvent.LIVING_DEATH.register(this::playerDeath);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        PROXY.init();
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        FTBChunksAPI.manager = new ClaimedChunkManager(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        FTBChunksAPI.manager = null;
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayerEntity player = event.getPlayer();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.updateLimits(player);
        new LoginDataPacket(event.getTeam().manager.getId()).sendTo(player);
        SendGeneralDataPacket.send(data, player);
        SendVisiblePlayerListPacket.sendAll();
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunk claimedChunk : FTBChunksAPI.getManager().claimedChunks.values()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)claimedChunk.pos.dimension, (Object)claimedChunk.teamData.getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, claimedChunk));
        }
        for (Map.Entry entry : chunksToSend.entrySet()) {
            SendManyChunksPacket packet = new SendManyChunksPacket();
            packet.dimension = (RegistryKey)((Pair)entry.getKey()).getLeft();
            packet.teamId = (UUID)((Pair)entry.getKey()).getRight();
            packet.chunks = (List)entry.getValue();
            packet.sendTo(player);
        }
        for (ClaimedChunk claimedChunk : data.getClaimedChunks()) {
            ClaimedChunk chunk;
            if (!claimedChunk.isForceLoaded() || (chunk = FTBChunksAPI.getManager().claimedChunks.get(claimedChunk.getPos())) == null) continue;
            chunk.postSetForceLoaded(true);
        }
        if (data.getTeam().getOwner().equals(player.func_110124_au())) {
            data.setChunkLoadOffline(data.manager.config.getChunkLoadOffline(data, player));
        }
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        FTBChunksAPI.manager.getData(teamEvent.getTeam()).saveNow();
    }

    private void teamDeleted(TeamEvent teamEvent) {
        if (!teamEvent.getTeam().getType().isPlayer()) {
            CommandSource sourceStack = teamEvent.getTeam().manager.server.func_195573_aM();
            HashMap<RegistryKey, List> chunksToUnclaim = new HashMap<RegistryKey, List>();
            long now = System.currentTimeMillis();
            for (ClaimedChunk claimedChunk : FTBChunksAPI.manager.getData(teamEvent.getTeam()).getClaimedChunks()) {
                claimedChunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, null));
            }
            for (Map.Entry entry : chunksToUnclaim.entrySet()) {
                SendManyChunksPacket packet = new SendManyChunksPacket();
                packet.dimension = (RegistryKey)entry.getKey();
                packet.teamId = Util.field_240973_b_;
                packet.chunks = (List)entry.getValue();
                packet.sendToAll(sourceStack.func_197028_i());
            }
        }
    }

    public void loggedOut(ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        boolean canChunkLoadOffline = data.manager.config.getChunkLoadOffline(data, player);
        data.setChunkLoadOffline(canChunkLoadOffline);
        if (!canChunkLoadOffline) {
            for (ClaimedChunk chunk : data.getClaimedChunks()) {
                ClaimedChunk c = FTBChunksAPI.getManager().claimedChunks.get(chunk.getPos());
                if (c == null) {
                    return;
                }
                c.postSetForceLoaded(false);
            }
        }
    }

    private boolean checkPlayer(@Nullable Entity entity) {
        if (!FTBChunksAPI.isManagerLoaded() || FTBChunksAPI.getManager().config.disableProtection) {
            return false;
        }
        if (entity instanceof ServerPlayerEntity) {
            if (PlayerHooks.isFake((PlayerEntity)((ServerPlayerEntity)entity))) {
                return !FTBChunksAPI.getManager().config.disableAllFakePlayers;
            }
            return true;
        }
        return false;
    }

    private void printNoWildernessMessage(@Nullable Entity entity) {
        StringTextComponent component = new StringTextComponent("You need to claim this chunk to interact with blocks here!");
        if (entity instanceof PlayerEntity) {
            ((PlayerEntity)entity).func_146105_b((ITextComponent)component, true);
        } else if (entity != null) {
            entity.func_145747_a((ITextComponent)component, Util.field_240973_b_);
        }
    }

    public ActionResultType blockLeftClick(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        if (this.checkPlayer((Entity)player)) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(player.field_70170_p, pos));
            if (chunk != null) {
                if (!chunk.canEdit((ServerPlayerEntity)player, player.field_70170_p.func_180495_p(pos))) {
                    return ActionResultType.FAIL;
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness && !FTBChunksAPI.RIGHT_CLICK_BLACKLIST_TAG.func_230235_a_((Object)player.func_184586_b(hand).func_77973_b())) {
                this.printNoWildernessMessage((Entity)player);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType blockRightClick(PlayerEntity player, Hand hand, BlockPos pos, Direction face) {
        if (this.checkPlayer((Entity)player)) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(player.field_70170_p, pos));
            if (chunk != null) {
                if (!chunk.canInteract((ServerPlayerEntity)player, player.field_70170_p.func_180495_p(pos))) {
                    return ActionResultType.FAIL;
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness && !FTBChunksAPI.RIGHT_CLICK_BLACKLIST_TAG.func_230235_a_((Object)player.func_184586_b(hand).func_77973_b())) {
                this.printNoWildernessMessage((Entity)player);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResult<ItemStack> itemRightClick(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.checkPlayer((Entity)player) && !stack.func_222117_E()) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(player.field_70170_p, new BlockPos(player.func_174824_e(1.0f))));
            if (chunk != null) {
                if (!chunk.canRightClickItem((ServerPlayerEntity)player, stack)) {
                    return ActionResult.func_226251_d_((Object)stack);
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness && FTBChunksAPI.RIGHT_CLICK_BLACKLIST_TAG.func_230235_a_((Object)stack.func_77973_b())) {
                this.printNoWildernessMessage((Entity)player);
                return ActionResult.func_226251_d_((Object)stack);
            }
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public ActionResultType blockBreak(World level, BlockPos pos, BlockState blockState, ServerPlayerEntity player, @Nullable IntValue intValue) {
        if (this.checkPlayer((Entity)player)) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(level, pos));
            if (chunk != null) {
                if (!chunk.canEdit(player, blockState)) {
                    return ActionResultType.FAIL;
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness) {
                this.printNoWildernessMessage((Entity)player);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType blockPlace(World level, BlockPos pos, BlockState blockState, @Nullable Entity entity) {
        if (this.checkPlayer(entity)) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(level, pos));
            if (chunk != null) {
                if (entity != null && !chunk.canEdit((ServerPlayerEntity)entity, blockState)) {
                    return ActionResultType.FAIL;
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness) {
                this.printNoWildernessMessage(entity);
                return ActionResultType.FAIL;
            }
        }
        return ActionResultType.PASS;
    }

    public CompoundEventResult<ItemStack> fillBucket(PlayerEntity player, World level, ItemStack emptyBucket, @Nullable RayTraceResult target) {
        if (this.checkPlayer((Entity)player) && target instanceof BlockRayTraceResult) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(level, ((BlockRayTraceResult)target).func_216350_a()));
            if (chunk != null) {
                if (!chunk.canEdit((ServerPlayerEntity)player, level.func_204610_c(((BlockRayTraceResult)target).func_216350_a()).func_206883_i())) {
                    return CompoundEventResult.interrupt((Boolean)false, null);
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness) {
                this.printNoWildernessMessage((Entity)player);
                return CompoundEventResult.interrupt((Boolean)false, null);
            }
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(World world, BlockPos pos, BlockState blockState, float distance, Entity entity) {
        if (entity.field_70170_p instanceof ServerWorld && this.checkPlayer(entity)) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(entity.field_70170_p, pos));
            if (chunk != null) {
                if (!chunk.canEdit((ServerPlayerEntity)entity, blockState)) {
                    return EventResult.interrupt((Boolean)false);
                }
            } else if (FTBChunksAPI.getManager().config.noWilderness) {
                this.printNoWildernessMessage(entity);
                return EventResult.interrupt((Boolean)false);
            }
        }
        return EventResult.pass();
    }

    public void chunkChange(Entity entity, int chunkX, int chunkZ, int prevX, int prevZ) {
        if (!(entity instanceof ServerPlayerEntity) || PlayerHooks.isFake((PlayerEntity)((ServerPlayerEntity)entity))) {
            return;
        }
        if (!FTBTeamsAPI.isManagerLoaded() || !FTBChunksAPI.isManagerLoaded()) {
            return;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)entity;
        Team team = FTBTeamsAPI.getPlayerTeam((UUID)player.func_110124_au());
        if (team == null) {
            return;
        }
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
        if (data.prevChunkX != chunkX || data.prevChunkZ != chunkZ) {
            String s;
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((Entity)player));
            String string = s = chunk == null ? "-" : chunk.getTeamData().getTeamId().toString();
            if (!data.lastChunkID.equals(s)) {
                data.lastChunkID = s;
                if (chunk != null) {
                    player.func_146105_b(chunk.getTeamData().getTeam().getColoredName(), true);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("wilderness").func_240699_a_(TextFormatting.DARK_GREEN), true);
                }
            }
            data.prevChunkX = chunkX;
            data.prevChunkZ = chunkZ;
        }
    }

    public EventResult checkSpawn(LivingEntity entity, IWorld level, double x, double y, double z, SpawnReason type, @Nullable AbstractSpawner spawner) {
        if (!level.func_201670_d() && !(entity instanceof PlayerEntity) && level instanceof World) {
            switch (type) {
                case NATURAL: 
                case CHUNK_GENERATION: 
                case SPAWNER: 
                case STRUCTURE: 
                case JOCKEY: 
                case PATROL: {
                    ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos((World)level, new BlockPos(x, y, z)));
                    if (chunk == null || chunk.canEntitySpawn((Entity)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(World level, Explosion explosion) {
        if (level.func_201670_d() || explosion.func_180343_e().isEmpty() || !(explosion instanceof ExplosionFTBC)) {
            return true;
        }
        return ((ExplosionFTBC)explosion).getSourceFTBC() == null;
    }

    public void explosionDetonate(World level, Explosion explosion, List<Entity> affectedEntities) {
        if (this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.func_180343_e());
        explosion.func_180342_d();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.func_180343_e().add(pos);
        }
    }

    public ActionResultType playerDeath(LivingEntity entity, DamageSource source) {
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            RegistryKey dim = player.field_70170_p.func_234923_W_();
            int x = MathHelper.func_76128_c((double)player.func_226277_ct_());
            int y = MathHelper.func_76128_c((double)player.func_226278_cu_());
            int z = MathHelper.func_76128_c((double)player.func_226281_cx_());
            int num = player.func_147099_x().func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188069_A)) + 1;
            new PlayerDeathPacket((RegistryKey<World>)dim, x, y, z, num).sendTo((ServerPlayerEntity)entity);
        }
        return ActionResultType.PASS;
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksTeamData.ALLOW_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_EDIT_MODE);
        event.add((TeamProperty)FTBChunksTeamData.BLOCK_INTERACT_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        SendManyChunksPacket packet;
        CommandSource sourceStack = event.getTeam().manager.server.func_195573_aM();
        FTBChunksTeamData oldData = FTBChunksAPI.getManager().getData((Team)event.getPreviousTeam());
        FTBChunksTeamData newData = FTBChunksAPI.getManager().getData(event.getTeam());
        newData.updateLimits(event.getPlayer());
        HashMap<RegistryKey, List> chunksToSend = new HashMap<RegistryKey, List>();
        HashMap<RegistryKey, List> chunksToUnclaim = new HashMap<RegistryKey, List>();
        int chunks = 0;
        long now = System.currentTimeMillis();
        int total = 0;
        for (ClaimedChunk claimedChunk : oldData.getClaimedChunks()) {
            if (total >= newData.maxClaimChunks) {
                claimedChunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, null));
            } else {
                claimedChunk.teamData = newData;
                chunksToSend.computeIfAbsent(claimedChunk.pos.dimension, s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, claimedChunk.pos.x, claimedChunk.pos.z, claimedChunk));
                ++chunks;
            }
            ++total;
        }
        if (chunks == 0) {
            return;
        }
        for (Map.Entry entry : chunksToSend.entrySet()) {
            packet = new SendManyChunksPacket();
            packet.dimension = (RegistryKey)entry.getKey();
            packet.teamId = newData.getTeamId();
            packet.chunks = (List)entry.getValue();
            packet.sendToAll(sourceStack.func_197028_i());
        }
        for (Map.Entry entry : chunksToUnclaim.entrySet()) {
            packet = new SendManyChunksPacket();
            packet.dimension = (RegistryKey)entry.getKey();
            packet.teamId = Util.field_240973_b_;
            packet.chunks = (List)entry.getValue();
            packet.sendToAll(sourceStack.func_197028_i());
        }
        LOGGER.info("Transferred " + chunks + "/" + total + " chunks from " + oldData + " to " + newData);
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(event.getTeam());
        data.updateLimits(event.getTo());
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = Registries.get((String)MOD_ID).get(Registry.field_239711_l_);
        ranksMod = false;
    }
}

