/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.util.UUIDTypeAdapter;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamArgument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.DimensionArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.GameProfileArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class FTBChunksCommands {
    public static void registerCommands(CommandDispatcher<CommandSource> dispatcher, Commands.EnvironmentType selection) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"ftbchunks").then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"claim").executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> FTBChunksCommands.claim((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius_in_blocks")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim").executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> FTBChunksCommands.unclaim((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius_in_blocks")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"load").executes(context -> FTBChunksCommands.load((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> FTBChunksCommands.load((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius_in_blocks")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload").executes(context -> FTBChunksCommands.unload((CommandSource)context.getSource(), 0))).then(Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> FTBChunksCommands.unload((CommandSource)context.getSource(), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius_in_blocks")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unclaim_all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197034_c(2))).executes(context -> FTBChunksCommands.unclaimAll((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"))))).executes(context -> FTBChunksCommands.unclaimAll((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h().func_146103_bH()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unload_all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"players", (ArgumentType)GameProfileArgument.func_197108_a()).requires(source -> source.func_197034_c(2))).executes(context -> FTBChunksCommands.unloadAll((CommandSource)context.getSource(), GameProfileArgument.func_197109_a((CommandContext)context, (String)"players"))))).executes(context -> FTBChunksCommands.unloadAll((CommandSource)context.getSource(), Collections.singleton(((CommandSource)context.getSource()).func_197035_h().func_146103_bH()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"info").executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos((World)((CommandSource)context.getSource()).func_197023_e(), new BlockPos(((CommandSource)context.getSource()).func_197036_d()))))).then(Commands.func_197056_a((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos((World)((CommandSource)context.getSource()).func_197023_e(), new BlockPos(IntegerArgumentType.getInteger((CommandContext)context, (String)"x"), 0, IntegerArgumentType.getInteger((CommandContext)context, (String)"z")))))).then(Commands.func_197056_a((String)"dimension", (ArgumentType)DimensionArgument.func_212595_a()).executes(context -> FTBChunksCommands.info((CommandSource)context.getSource(), new ChunkDimPos(DimensionArgument.func_212592_a((CommandContext)context, (String)"dimension").func_234923_W_(), IntegerArgumentType.getInteger((CommandContext)context, (String)"x") >> 4, IntegerArgumentType.getInteger((CommandContext)context, (String)"z") >> 4)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"admin").requires(source -> source.func_197034_c(2))).then(Commands.func_197057_a((String)"bypass_protection").executes(context -> FTBChunksCommands.bypassProtection(((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"extra_claim_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"get").executes(context -> FTBChunksCommands.getExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.addExtraClaimChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))))).then(Commands.func_197057_a((String)"extra_force_load_chunks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197057_a((String)"get").executes(context -> FTBChunksCommands.getExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"))))).then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> FTBChunksCommands.setExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"number", (ArgumentType)IntegerArgumentType.integer()).executes(context -> FTBChunksCommands.addExtraForceLoadChunks((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), IntegerArgumentType.getInteger((CommandContext)context, (String)"number")))))))).then(Commands.func_197057_a((String)"claim_server").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"server_team", (ArgumentType)TeamArgument.create()).executes(context -> FTBChunksCommands.claimServer((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"server_team"), 0))).then(Commands.func_197056_a((String)"radius_in_blocks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(context -> FTBChunksCommands.claimServer((CommandSource)context.getSource(), TeamArgument.get((CommandContext)context, (String)"server_team"), IntegerArgumentType.getInteger((CommandContext)context, (String)"radius_in_blocks")))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"block_color").requires(source -> source.func_197028_i().func_71264_H())).executes(context -> FTBChunks.PROXY.blockColor())));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"chunks").redirect((CommandNode)command));
    }

    private static int bypassProtection(ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.bypassProtection = !data.bypassProtection;
        return 1;
    }

    private static void forEachChunk(CommandSource source, int r, ChunkCallback callback) throws CommandSyntaxException {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(source.func_197035_h());
        RegistryKey dimId = source.func_197023_e().func_234923_W_();
        int ox = MathHelper.func_76128_c((double)source.func_197036_d().field_72450_a) >> 4;
        int oz = MathHelper.func_76128_c((double)source.func_197036_d().field_72449_c) >> 4;
        ArrayList<ChunkDimPos> list = new ArrayList<ChunkDimPos>();
        r = Math.max(1, r >> 4);
        for (int z = -r; z <= r; ++z) {
            for (int x = -r; x <= r; ++x) {
                list.add(new ChunkDimPos(dimId, ox + x, oz + z));
            }
        }
        list.sort(Comparator.comparingDouble(o -> MathUtils.distSq((double)ox, (double)oz, (double)o.x, (double)o.z)));
        for (ChunkDimPos pos : list) {
            callback.accept(data, pos);
        }
    }

    private static int claim(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        long now = System.currentTimeMillis();
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.claim(source, pos, false);
            if (result.isSuccess()) {
                result.setClaimedTime(now);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Claimed " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " claimed " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int unclaim(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            if (data.unclaim(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unclaimed " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unclaimed " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int load(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        long now = System.currentTimeMillis();
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.load(source, pos, false);
            if (result.isSuccess()) {
                result.setForceLoadedTime(now);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Loaded " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " loaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int unload(CommandSource source, int r) throws CommandSyntaxException {
        int[] success = new int[1];
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            if (data.unload(source, pos, false).isSuccess()) {
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Unloaded " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " unloaded " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static int unclaimAll(CommandSource source, Collection<GameProfile> players) {
        for (GameProfile profile : players) {
            FTBChunksTeamData data = FTBChunksAPI.getManager().getData(FTBTeamsAPI.getPlayerTeam((UUID)profile.getId()));
            if (data == null) continue;
            for (ClaimedChunk c : data.getClaimedChunks()) {
                data.unclaim(source, c.getPos(), false);
            }
            data.save();
        }
        return 1;
    }

    private static int unloadAll(CommandSource source, Collection<GameProfile> players) {
        for (GameProfile profile : players) {
            Team team = FTBTeamsAPI.getPlayerTeam((UUID)profile.getId());
            if (team == null) continue;
            FTBChunksTeamData data = FTBChunksAPI.getManager().getData(team);
            for (ClaimedChunk c : data.getClaimedChunks()) {
                data.unload(source, c.getPos(), false);
            }
        }
        return 1;
    }

    private static int info(CommandSource source, ChunkDimPos pos) {
        source.func_197030_a((ITextComponent)new StringTextComponent("Location: " + pos), true);
        ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(pos);
        if (chunk == null) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Chunk not claimed!"), true);
            return 0;
        }
        source.func_197030_a((ITextComponent)new StringTextComponent("Owner: ").func_230529_a_(chunk.getTeamData().getTeam().getColoredName()).func_240702_b_(" / " + UUIDTypeAdapter.fromUUID((UUID)chunk.getTeamData().getTeamId())), true);
        if (source.func_197034_c(2)) {
            source.func_197030_a((ITextComponent)new StringTextComponent("Force Loaded: " + chunk.isForceLoaded()), true);
        }
        return 1;
    }

    private static int getExtraClaimChunks(CommandSource source, ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int setExtraClaimChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraClaimChunks = Math.max(0, i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int addExtraClaimChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraClaimChunks = Math.max(0, data.extraClaimChunks + i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraClaimChunks), false);
        return 1;
    }

    private static int getExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int setExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraForceLoadChunks = Math.max(0, i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int addExtraForceLoadChunks(CommandSource source, ServerPlayerEntity player, int i) {
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        data.extraForceLoadChunks = Math.max(0, data.extraForceLoadChunks + i);
        data.save();
        SendGeneralDataPacket.send(data, player);
        source.func_197030_a((ITextComponent)new StringTextComponent("").func_230529_a_(player.func_145748_c_()).func_240702_b_(" == " + data.extraForceLoadChunks), false);
        return 1;
    }

    private static int claimServer(CommandSource source, Team team, int r) throws CommandSyntaxException {
        if (!team.getType().isServer()) {
            return 0;
        }
        int[] success = new int[1];
        long now = System.currentTimeMillis();
        FTBChunksCommands.forEachChunk(source, r, (data, pos) -> {
            ClaimResult result = data.claim(source, pos, false);
            if (result.isSuccess()) {
                result.setClaimedTime(now);
                success[0] = success[0] + 1;
            }
        });
        source.func_197030_a((ITextComponent)new StringTextComponent("Claimed " + success[0] + " chunks!"), false);
        FTBChunks.LOGGER.info(source.func_197037_c() + " claimed " + success[0] + " chunks at " + new ChunkDimPos((Entity)source.func_197035_h()));
        return success[0];
    }

    private static interface ChunkCallback {
        public void accept(FTBChunksTeamData var1, ChunkDimPos var2) throws CommandSyntaxException;
    }
}

