/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBRanksIntegration;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.FolderName;

public class FTBChunksWorldConfig {
    public static final FolderName CONFIG_FILE_PATH = LevelResourceHooks.create((String)"serverconfig/ftbchunks-server.json5");
    @Comment(value="Disables fake players like miners and auto-clickers")
    public boolean disableAllFakePlayers = false;
    @Comment(value="Max claimed chunks.\nYou can override this with FTB Ranks 'ftbchunks.max_claimed' permission")
    public int maxClaimedChunks = 500;
    @Comment(value="Max force loaded chunks.\nYou can override this with FTB Ranks 'ftbchunks.max_force_loaded' permission")
    public int maxForceLoadedChunks = 25;
    @Comment(value="Allow players to load chunks while they are offline")
    public boolean chunkLoadOffline = true;
    @Comment(value="Disables all land protection. Useful for private servers where everyone is trusted and claims are only used for forceloading")
    public boolean disableProtection = false;
    @Comment(value="Forced modes won't let players change their ally settings")
    public AllyMode allyMode = AllyMode.DEFAULT;
    @Comment(value="Blacklist for dimensions where chunks can't be claimed. Add \"minecraft:the_end\" to this list if you want to disable chunk claiming in The End")
    public List<String> claimDimensionBlacklist = new ArrayList<String>();
    public transient Set<RegistryKey<World>> claimDimensionBlacklistSet = new HashSet<RegistryKey<World>>();
    @Comment(value="Patches vanilla chunkloading to allow random block ticks and other environment updates in chunks where no players are nearby. With this off farms and other things won't work. Disable in case this causes issues")
    public boolean patchChunkLoading = true;
    @Comment(value="Requires you to claim chunks in order to edit and interact with blocks")
    public boolean noWilderness = false;
    private static final Jankson JANKSON = Jankson.builder().build();

    public static FTBChunksWorldConfig init(MinecraftServer server) {
        FTBChunksWorldConfig instance = new FTBChunksWorldConfig();
        Path configPath = server.func_240776_a_(CONFIG_FILE_PATH);
        if (Files.exists(configPath, new LinkOption[0])) {
            try {
                instance = (FTBChunksWorldConfig)JANKSON.fromJson(JANKSON.load(configPath.toFile()), FTBChunksWorldConfig.class);
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        for (String s : instance.claimDimensionBlacklist) {
            instance.claimDimensionBlacklistSet.add((RegistryKey<World>)RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(s)));
        }
        instance.save(server);
        return instance;
    }

    public void save(MinecraftServer server) {
        Path configPath = server.func_240776_a_(CONFIG_FILE_PATH);
        try {
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);
            writer.write(JANKSON.toJson((Object)this).toJson(true, true));
            writer.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public int getMaxClaimedChunks(FTBChunksTeamData playerData, ServerPlayerEntity player) {
        if (FTBChunks.ranksMod) {
            return FTBRanksIntegration.getMaxClaimedChunks(player, this.maxClaimedChunks) + playerData.getExtraClaimChunks();
        }
        return this.maxClaimedChunks + playerData.getExtraClaimChunks();
    }

    public int getMaxForceLoadedChunks(FTBChunksTeamData playerData, ServerPlayerEntity player) {
        if (FTBChunks.ranksMod) {
            return FTBRanksIntegration.getMaxForceLoadedChunks(player, this.maxForceLoadedChunks) + playerData.getExtraForceLoadChunks();
        }
        return this.maxForceLoadedChunks + playerData.getExtraForceLoadChunks();
    }

    public boolean getChunkLoadOffline(FTBChunksTeamData playerData, ServerPlayerEntity player) {
        if (FTBChunks.ranksMod) {
            return FTBRanksIntegration.getChunkLoadOffline(player, this.chunkLoadOffline);
        }
        return this.chunkLoadOffline;
    }

    public boolean patchChunkLoading(ServerWorld world, ChunkPos pos) {
        if (this.patchChunkLoading) {
            ClaimedChunk chunk = FTBChunksAPI.getManager().getChunk(new ChunkDimPos(world.func_234923_W_(), pos));
            return chunk != null && chunk.isForceLoaded();
        }
        return false;
    }
}

