/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import architectury_inject_FTBChunks1165_common_4031bd59716c4cb7b7104a31589ef581.PlatformMethods;
import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksCommon;
import dev.ftb.mods.ftbchunks.client.EntityIcons;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.FTBChunksRenderTypes;
import dev.ftb.mods.ftbchunks.client.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.MinimapRenderer;
import dev.ftb.mods.ftbchunks.client.RegionMapPanel;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.ReloadChunkTask;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.Waypoint;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.net.SendVisiblePlayerListPacket;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import me.shedaniel.architectury.annotations.ExpectPlatform;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientPlayerEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.event.events.client.ClientScreenInputEvent;
import me.shedaniel.architectury.event.events.client.ClientTickEvent;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.registry.ReloadListeners;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.monster.IMob;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import org.jetbrains.annotations.Nullable;

public class FTBChunksClient
extends FTBChunksCommon {
    private static final ResourceLocation BUTTON_ID = new ResourceLocation("ftbchunks:open_gui");
    public static final ResourceLocation CIRCLE_MASK = new ResourceLocation("ftbchunks:textures/circle_mask.png");
    public static final ResourceLocation CIRCLE_BORDER = new ResourceLocation("ftbchunks:textures/circle_border.png");
    public static final ResourceLocation PLAYER = new ResourceLocation("ftbchunks:textures/player.png");
    public static final ResourceLocation[] COMPASS = new ResourceLocation[]{new ResourceLocation("ftbchunks:textures/compass_e.png"), new ResourceLocation("ftbchunks:textures/compass_n.png"), new ResourceLocation("ftbchunks:textures/compass_w.png"), new ResourceLocation("ftbchunks:textures/compass_s.png")};
    private static final List<ITextComponent> MINIMAP_TEXT_LIST = new ArrayList<ITextComponent>(3);
    private static final ArrayDeque<MapTask> taskQueue = new ArrayDeque();
    public static long taskQueueTicks = 0L;
    public static final HashSet<ChunkPos> rerenderCache = new HashSet();
    public static KeyBinding openMapKey;
    public static int minimapTextureId;
    private static int currentPlayerChunkX;
    private static int currentPlayerChunkZ;
    private static int renderedDebugCount;
    public static boolean updateMinimap;
    public static boolean alwaysRenderChunksOnMap;
    public static SendGeneralDataPacket generalData;
    private static long nextRegionSave;

    public static void queue(MapTask task) {
        taskQueue.addLast(task);
    }

    @Override
    public void init() {
        FTBChunksClientConfig.init();
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new EntityIcons());
        ReloadListeners.registerReloadListener((ResourcePackType)ResourcePackType.CLIENT_RESOURCES, (IFutureReloadListener)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        GuiEvent.RENDER_HUD.register(this::renderHud);
        GuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        FTBChunksClient.registerPlatform();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        PlatformMethods.platform("registerPlatform");
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void renderMinimap(MapDimension dimension, MinimapRenderer renderer) {
        void var1_1;
        PlatformMethods.platform("renderMinimap", (MapDimension)dimension, (MinimapRenderer)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void addWidgets(RegionMapPanel panel) {
        PlatformMethods.platform("addWidgets", (RegionMapPanel)panel);
    }

    public static void openGui() {
        new LargeMapScreen().openGui();
    }

    public static void saveAllRegions() {
        if (MapManager.inst == null) {
            return;
        }
        for (MapDimension dimension : MapManager.inst.getDimensions().values()) {
            for (MapRegion region : dimension.getLoadedRegions()) {
                if (!region.saveData) continue;
                FTBChunksClient.queue(region);
                region.saveData = false;
            }
            if (!dimension.saveData) continue;
            FTBChunksClient.queue(dimension);
            dimension.saveData = false;
        }
        if (MapManager.inst.saveData) {
            FTBChunksClient.queue(MapManager.inst);
            MapManager.inst.saveData = false;
        }
    }

    @Override
    public void login(LoginDataPacket loginData) {
        Path dir = Platform.getGameFolder().resolve("local/ftbchunks/data/" + loginData.serverId);
        if (Files.notExists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        MapManager.inst = new MapManager(loginData.serverId, dir);
        updateMinimap = true;
        renderedDebugCount = 0;
    }

    public void loggedOut(@Nullable ClientPlayerEntity player) {
        if (MapManager.inst != null) {
            MapTask t;
            FTBChunksClient.saveAllRegions();
            while ((t = taskQueue.pollFirst()) != null) {
                t.runMapTask();
            }
            MapDimension.updateCurrent();
            MapManager.inst.release();
            MapManager.inst = null;
        }
    }

    @Override
    public void updateGeneralData(SendGeneralDataPacket packet) {
        generalData = packet;
    }

    @Override
    public void updateChunk(SendChunkPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, packet.chunk, packet.teamId, now));
    }

    @Override
    public void updateAllChunks(SendManyChunksPacket packet) {
        if (MapManager.inst == null) {
            return;
        }
        MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
        Date now = new Date();
        for (SendChunkPacket.SingleChunk c : packet.chunks) {
            FTBChunksClient.queue(new UpdateChunkFromServerTask(dimension, c, packet.teamId, now));
        }
    }

    @Override
    public void updateVisiblePlayerList(SendVisiblePlayerListPacket packet) {
        PlayerLocation.CLIENT_LIST.clear();
        PlayerLocation.currentDimension = packet.dim;
        PlayerLocation.CLIENT_LIST.addAll(packet.players);
    }

    @Override
    public void syncRegion(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    @Override
    public void playerDeath(PlayerDeathPacket packet) {
        if (FTBChunksClientConfig.get().deathWaypoints) {
            MapDimension dimension = MapManager.inst.getDimension(packet.dimension);
            Waypoint w = new Waypoint(dimension);
            w.name = "Death #" + packet.number;
            w.x = packet.x;
            w.y = packet.y;
            w.z = packet.z;
            w.type = WaypointType.DEATH;
            dimension.getWaypoints().add(w);
            dimension.saveData = true;
        }
    }

    @Override
    public int blockColor() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_222817_e(() -> {
            if (mc.field_71476_x instanceof BlockRayTraceResult && mc.field_71474_y.field_74319_N) {
                ResourceLocation id = Registry.field_212618_g.func_177774_c((Object)mc.field_71441_e.func_180495_p(((BlockRayTraceResult)mc.field_71476_x).func_216350_a()).func_177230_c());
                NativeImage image = ScreenShotHelper.func_198052_a((int)mc.func_228018_at_().func_198109_k(), (int)mc.func_228018_at_().func_198091_l(), (Framebuffer)mc.func_147110_a());
                int col = image.func_195709_a(image.func_195702_a() / 2, image.func_195714_b() / 2);
                String s = String.format("\"%s\": \"#%06X\"", id.func_110623_a(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(id.func_110624_b() + " - " + s).func_240703_c_(Style.field_240709_b_.func_240721_b_(TextFormatting.GOLD).func_240715_a_(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, s)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to copy")))), Util.field_240973_b_);
            } else {
                mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("You must be looking at a block in F1 mode!"), Util.field_240973_b_);
            }
        });
        return 1;
    }

    public ActionResultType customClick(CustomClickEvent event) {
        if (event.getId().equals((Object)BUTTON_ID)) {
            FTBChunksClient.openGui();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public ActionResultType keyPressed(Minecraft client, int keyCode, int scanCode, int action, int modifiers) {
        if (openMapKey.func_151470_d()) {
            if (FTBChunksClientConfig.get().debugInfo && Screen.func_231172_r_()) {
                FTBChunks.LOGGER.info("=== Task Queue: " + taskQueue.size());
                for (MapTask task : taskQueue) {
                    FTBChunks.LOGGER.info(task.toString());
                }
                FTBChunks.LOGGER.info("===");
            } else {
                FTBChunksClient.openGui();
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    public ActionResultType keyPressed(Minecraft client, Screen screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (openMapKey.func_151470_d() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null) {
            gui.closeGui(false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public void renderHud(MatrixStack matrixStack, float tickDelta) {
        RegistryKey biome;
        ClientTeam team;
        MapRegionData data;
        double d;
        FTBChunksClientConfig config = FTBChunksClientConfig.get();
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71439_g == null || mc.field_71441_e == null || MapManager.inst == null) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim.dimension != mc.field_71441_e.func_234923_W_()) {
            MapDimension.updateCurrent();
            dim = MapDimension.getCurrent();
        }
        long now = System.currentTimeMillis();
        if (nextRegionSave == 0L || now >= nextRegionSave) {
            nextRegionSave = now + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        if (minimapTextureId == -1) {
            minimapTextureId = TextureUtil.func_225678_a_();
            TextureUtil.func_225680_a_((int)minimapTextureId, (int)240, (int)240);
            updateMinimap = true;
        }
        RenderSystem.enableTexture();
        RenderSystem.bindTexture((int)minimapTextureId);
        if (config.minimapBlur) {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
        } else {
            RenderSystem.texParameter((int)3553, (int)10241, (int)9728);
            RenderSystem.texParameter((int)3553, (int)10240, (int)9728);
        }
        int cx = mc.field_71439_g.field_70176_ah;
        int cz = mc.field_71439_g.field_70164_aj;
        if (cx != currentPlayerChunkX || cz != currentPlayerChunkZ) {
            updateMinimap = true;
        }
        if (updateMinimap) {
            updateMinimap = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().func_227789_a_(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, config.minimapBlur, false, false, false);
                }
            }
            currentPlayerChunkX = cx;
            currentPlayerChunkZ = cz;
        }
        if (mc.field_71474_y.field_74330_P || config.minimap == MinimapPosition.DISABLED || config.minimapVisibility == 0) {
            return;
        }
        float scale = (float)(config.minimapScale * 4.0 / mc.func_228018_at_().func_198100_s());
        float minimapRotation = (config.minimapLockedNorth ? 180.0f : -mc.field_71439_g.field_70177_z) % 360.0f;
        int s = (int)(64.0 * (double)scale);
        int x = config.minimap.getX(mc.func_228018_at_().func_198107_o(), s);
        int y = config.minimap.getY(mc.func_228018_at_().func_198087_p(), s);
        boolean z = false;
        float border = 0.0f;
        int alpha = config.minimapVisibility;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        float f0 = 0.06666667f;
        float f1 = 1.0f - f0;
        float offX = (float)((mc.field_71439_g.func_226277_ct_() / 16.0 - (double)currentPlayerChunkX - 0.5) / 15.0);
        float offY = (float)((mc.field_71439_g.func_226281_cx_() / 16.0 - (double)currentPlayerChunkZ - 0.5) / 15.0);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableCull();
        RenderSystem.enableTexture();
        RenderSystem.enableDepthTest();
        RenderSystem.enableAlphaTest();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)y + (double)s / 2.0, -10.0);
        matrixStack.func_227861_a_(0.0, 0.0, 950.0);
        Matrix4f m = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        mc.func_110434_K().func_110577_a(CIRCLE_MASK);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.func_227861_a_(0.0, 0.0, -950.0);
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        RenderSystem.bindTexture((int)minimapTextureId);
        m = matrixStack.func_227866_c_().func_227870_a_();
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f0 + offX, f0 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)(-s) / 2.0f + border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f0 + offX, f1 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)s / 2.0f - border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f1 + offX, f1 + offY).func_181675_d();
        buffer.func_227888_a_(m, (float)s / 2.0f - border, (float)(-s) / 2.0f + border, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(f1 + offX, f0 + offY).func_181675_d();
        tessellator.func_78381_a();
        matrixStack.func_227865_b_();
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        m = matrixStack.func_227866_c_().func_227870_a_();
        mc.func_110434_K().func_110577_a(CIRCLE_BORDER);
        buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        buffer.func_227888_a_(m, (float)x, (float)y, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)x, (float)(y + s), (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)(y + s), (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)y, (float)z).func_225586_a_(255, 255, 255, alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.disableTexture();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        buffer.func_227888_a_(m, (float)x + (float)s / 2.0f, (float)(y + 0), (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)x + (float)s / 2.0f, (float)(y + s), (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + 0), (float)y + (float)s / 2.0f, (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        buffer.func_227888_a_(m, (float)(x + s), (float)y + (float)s / 2.0f, (float)z).func_225586_a_(0, 0, 0, 30).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableTexture();
        if (config.minimapCompass) {
            for (int face = 0; face < 4; ++face) {
                double d2 = (double)s / 2.2;
                double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d2);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d2);
                float ws = (float)s / 32.0f;
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(COMPASS[face]);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        double magicNumber = 3.2;
        if (config.minimapWaypoints && !dim.getWaypoints().isEmpty()) {
            for (Waypoint waypoint : dim.getWaypoints()) {
                double distance;
                if (waypoint.hidden || (distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5))) > (double)waypoint.minimapDistance) continue;
                double d3 = distance / magicNumber * (double)scale;
                if (d3 > (double)s / 2.0) {
                    d3 = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - (double)waypoint.z - 0.5, mc.field_71439_g.func_226277_ct_() - (double)waypoint.x - 0.5) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d3);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d3);
                float ws = (float)s / 32.0f;
                int r = waypoint.color >> 16 & 0xFF;
                int g = waypoint.color >> 8 & 0xFF;
                int b = waypoint.color >> 0 & 0xFF;
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(waypoint.type.texture);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        FTBChunksClient.renderMinimap(dim, (px, pz, color, maxDistance) -> {
            double distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)px + 0.5), (double)((double)pz + 0.5));
            double d = distance / magicNumber * (double)scale;
            if (maxDistance > 0 && distance > (double)maxDistance) {
                return;
            }
            if (d > (double)s / 2.0) {
                if (maxDistance == 0) {
                    return;
                }
                d = (double)s / 2.0;
            }
            double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - (double)pz - 0.5, mc.field_71439_g.func_226277_ct_() - (double)px - 0.5) + (double)minimapRotation * Math.PI / 180.0;
            float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
            float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
            float ws = (float)s / 32.0f;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 0 & 0xFF;
            Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
            mc.func_110434_K().func_110577_a(WaypointType.WAYSTONE.texture);
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_227888_a_(matrix, wx - ws, wy - ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx - ws, wy + ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx + ws, wy + ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(matrix, wx + ws, wy - ws, 0.0f).func_225586_a_(r, g, b, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
        });
        if (config.minimapEntities) {
            for (Entity entity : mc.field_71441_e.func_217416_b()) {
                ResourceLocation texture;
                if (entity instanceof AbstractClientPlayerEntity || entity.func_200600_R().func_220339_d() == EntityClassification.MISC || entity.func_226278_cu_() < (double)(entity.field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, MathHelper.func_76128_c((double)entity.func_226277_ct_()), MathHelper.func_76128_c((double)entity.func_226281_cx_())) - 10) || (d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)entity.func_226277_ct_(), (double)entity.func_226281_cx_()) / magicNumber * (double)scale) > (double)s / 2.0 || (texture = EntityIcons.ENTITY_ICONS.get(entity.func_200600_R())) == EntityIcons.INVISIBLE) continue;
                if (texture == null || !config.minimapEntityHeads) {
                    texture = entity instanceof IMob ? EntityIcons.HOSTILE : EntityIcons.NORMAL;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - entity.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - entity.func_226277_ct_()) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
                float ws = (float)s / (config.minimapLargeEntities ? 32.0f : 48.0f);
                m = matrixStack.func_227866_c_().func_227870_a_();
                mc.func_110434_K().func_110577_a(texture);
                RenderSystem.texParameter((int)3553, (int)10241, (int)9729);
                RenderSystem.texParameter((int)3553, (int)10240, (int)9729);
                buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
                buffer.func_227888_a_(m, wx - ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 0.0f).func_181675_d();
                buffer.func_227888_a_(m, wx - ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(0.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy + ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 1.0f).func_181675_d();
                buffer.func_227888_a_(m, wx + ws, wy - ws, (float)z).func_225586_a_(255, 255, 255, 255).func_225583_a_(1.0f, 0.0f).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        if (config.minimapPlayerHeads && mc.field_71441_e.func_217369_A().size() > 1) {
            for (AbstractClientPlayerEntity player : mc.field_71441_e.func_217369_A()) {
                if (player == mc.field_71439_g) continue;
                d = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)player.func_226277_ct_(), (double)player.func_226281_cx_()) / magicNumber * (double)scale;
                if (d > (double)s / 2.0) {
                    d = (double)s / 2.0;
                }
                double angle = Math.atan2(mc.field_71439_g.func_226281_cx_() - player.func_226281_cx_(), mc.field_71439_g.func_226277_ct_() - player.func_226277_ct_()) + (double)minimapRotation * Math.PI / 180.0;
                float wx = (float)((double)x + (double)s / 2.0 + Math.cos(angle) * d);
                float wy = (float)((double)y + (double)s / 2.0 + Math.sin(angle) * d);
                float ws = (float)s / 32.0f;
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_((double)wx, (double)wy, (double)z);
                matrixStack.func_227862_a_(ws, ws, 1.0f);
                FaceIcon.getFace((GameProfile)player.func_146103_bH()).draw(matrixStack, -1, -1, 2, 2);
                matrixStack.func_227865_b_();
            }
        }
        if (config.minimapLockedNorth) {
            mc.func_110434_K().func_110577_a(PLAYER);
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)y + (double)s / 2.0, (double)z);
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(mc.field_71439_g.field_70177_z + 180.0f));
            matrixStack.func_227862_a_((float)s / 16.0f, (float)s / 16.0f, 1.0f);
            m = matrixStack.func_227866_c_().func_227870_a_();
            buffer.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
            buffer.func_227888_a_(m, -1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 0.0f).func_181675_d();
            buffer.func_227888_a_(m, -1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(0.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, 1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 1.0f).func_181675_d();
            buffer.func_227888_a_(m, 1.0f, -1.0f, 0.0f).func_225586_a_(255, 255, 255, 200).func_225583_a_(1.0f, 0.0f).func_181675_d();
            tessellator.func_78381_a();
            matrixStack.func_227865_b_();
        }
        MINIMAP_TEXT_LIST.clear();
        if (config.minimapZone && (data = dim.getRegion(XZ.regionFromChunk((int)currentPlayerChunkX, (int)currentPlayerChunkZ)).getData()) != null && (team = data.getChunk(XZ.of((int)currentPlayerChunkX, (int)currentPlayerChunkZ)).getTeam()) != null) {
            MINIMAP_TEXT_LIST.add(team.getColoredName());
        }
        if (config.minimapXYZ) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(MathHelper.func_76128_c((double)mc.field_71439_g.func_226277_ct_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226278_cu_()) + " " + MathHelper.func_76128_c((double)mc.field_71439_g.func_226281_cx_())));
        }
        if (config.minimapBiome && (biome = (RegistryKey)mc.field_71441_e.func_242406_i(mc.field_71439_g.func_233580_cy_()).orElse(null)) != null) {
            MINIMAP_TEXT_LIST.add((ITextComponent)new TranslationTextComponent("biome." + biome.func_240901_a_().func_110624_b() + "." + biome.func_240901_a_().func_110623_a()));
        }
        if (config.debugInfo) {
            XZ r = XZ.regionFromChunk((int)currentPlayerChunkX, (int)currentPlayerChunkZ);
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Queued tasks: " + taskQueue.size()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent(r.toRegionString()));
            MINIMAP_TEXT_LIST.add((ITextComponent)new StringTextComponent("Total updates: " + renderedDebugCount));
        }
        if (!MINIMAP_TEXT_LIST.isEmpty()) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)x + (double)s / 2.0, (double)(y + s) + 3.0, 0.0);
            matrixStack.func_227862_a_((float)(0.5 * (double)scale), (float)(0.5 * (double)scale), 1.0f);
            for (int i = 0; i < MINIMAP_TEXT_LIST.size(); ++i) {
                IReorderingProcessor bs = MINIMAP_TEXT_LIST.get(i).func_241878_f();
                int bsw = mc.field_71466_p.func_243245_a(bs);
                mc.field_71466_p.func_238407_a_(matrixStack, bs, (float)(-bsw) / 2.0f, (float)(i * 11), -1);
            }
            matrixStack.func_227865_b_();
        }
        RenderSystem.enableDepthTest();
    }

    public void renderWorldLast(MatrixStack ms) {
        Minecraft mc = Minecraft.func_71410_x();
        FTBChunksClientConfig config = FTBChunksClientConfig.get();
        if (mc.field_71474_y.field_74319_N || !config.inWorldWaypoints || MapManager.inst == null || mc.field_71441_e == null || mc.field_71439_g == null) {
            return;
        }
        MapDimension dim = MapDimension.getCurrent();
        if (dim.getWaypoints().isEmpty()) {
            return;
        }
        ArrayList<Waypoint> visibleWaypoints = new ArrayList<Waypoint>();
        for (Waypoint waypoint : dim.getWaypoints()) {
            if (waypoint.hidden) continue;
            waypoint.distance = MathUtils.dist((double)mc.field_71439_g.func_226277_ct_(), (double)mc.field_71439_g.func_226281_cx_(), (double)((double)waypoint.x + 0.5), (double)((double)waypoint.z + 0.5));
            if (waypoint.distance <= 8.0 || waypoint.distance > (double)waypoint.inWorldDistance) continue;
            waypoint.alpha = 150;
            if (waypoint.distance < 12.0) {
                waypoint.alpha = (int)((double)waypoint.alpha * ((waypoint.distance - 8.0) / 4.0));
            }
            if (waypoint.alpha <= 0) continue;
            visibleWaypoints.add(waypoint);
        }
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        if (visibleWaypoints.size() >= 2) {
            visibleWaypoints.sort(Comparator.comparingDouble(value -> -value.distance));
        }
        ActiveRenderInfo camera = Minecraft.func_71410_x().func_175598_ae().field_217783_c;
        Vector3d cameraPos = camera.func_216785_c();
        ms.func_227860_a_();
        ms.func_227861_a_(-cameraPos.field_72450_a, -cameraPos.field_72448_b, -cameraPos.field_72449_c);
        IVertexBuilder depthBuffer = mc.func_228019_au_().func_228487_b_().getBuffer(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
        float h = (float)(cameraPos.field_72448_b + 30.0);
        float h2 = h + 70.0f;
        for (Waypoint waypoint : visibleWaypoints) {
            double angle = Math.atan2(cameraPos.field_72449_c - (double)waypoint.z - 0.5, cameraPos.field_72450_a - (double)waypoint.x - 0.5) * 180.0 / Math.PI;
            int r = waypoint.color >> 16 & 0xFF;
            int g = waypoint.color >> 8 & 0xFF;
            int b = waypoint.color >> 0 & 0xFF;
            ms.func_227860_a_();
            ms.func_227861_a_((double)waypoint.x + 0.5, 0.0, (double)waypoint.z + 0.5);
            ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(-angle - 135.0)));
            float s = 0.6f;
            Matrix4f m = ms.func_227866_c_().func_227870_a_();
            depthBuffer.func_227888_a_(m, -s, 0.0f, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, 0.0f, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h, s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(0.0f, 1.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, -s, h2, s).func_225586_a_(r, g, b, 0).func_225583_a_(0.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h2, -s).func_225586_a_(r, g, b, 0).func_225583_a_(1.0f, 0.0f).func_181675_d();
            depthBuffer.func_227888_a_(m, s, h, -s).func_225586_a_(r, g, b, waypoint.alpha).func_225583_a_(1.0f, 1.0f).func_181675_d();
            ms.func_227865_b_();
        }
        ms.func_227865_b_();
        mc.func_228019_au_().func_228487_b_().func_228462_a_(FTBChunksRenderTypes.WAYPOINTS_DEPTH);
    }

    public ActionResultType screenOpened(Screen screen, List<Widget> widgets, List<IGuiEventListener> children) {
        if (screen instanceof IngameMenuScreen) {
            nextRegionSave = System.currentTimeMillis() + 60000L;
            FTBChunksClient.saveAllRegions();
        }
        return ActionResultType.PASS;
    }

    public void clientTick(Minecraft client) {
        if (MapManager.inst != null && Minecraft.func_71410_x().field_71441_e != null) {
            int s;
            FTBChunksClientConfig config = FTBChunksClientConfig.get();
            if (taskQueueTicks % (long)config.rerenderQueueTicks == 0L && !rerenderCache.isEmpty()) {
                ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                for (ChunkPos pos : rerenderCache) {
                    FTBChunksClient.queue(new ReloadChunkTask((World)world, pos));
                }
                rerenderCache.clear();
            }
            if (taskQueueTicks % (long)config.taskQueueTicks == 0L && (s = Math.min(taskQueue.size(), config.taskQueueMax)) > 0) {
                MapTask[] tasks = new MapTask[s];
                for (int i = 0; i < s; ++i) {
                    tasks[i] = taskQueue.pollFirst();
                    if (tasks[i] == null || tasks[i].cancelOtherTasks()) break;
                }
                Util.func_215072_e().execute(() -> {
                    for (MapTask task : tasks) {
                        if (task == null) continue;
                        task.runMapTask();
                    }
                });
            }
            ++taskQueueTicks;
        }
    }

    public void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        if (MapManager.inst != null) {
            MapManager.inst.updateAllRegions(false);
        }
    }

    public static void rerender(BlockPos blockPos) {
        FTBChunksClient.rerender(new ChunkPos(blockPos));
    }

    public static void rerender(ChunkPos chunkPos) {
        if (rerenderCache.add(chunkPos) && FTBChunksClientConfig.get().debugInfo) {
            ++renderedDebugCount;
        }
    }

    public static void handlePacket(SMultiBlockChangePacket packet) {
        packet.func_244310_a((blockPos, blockState) -> FTBChunksClient.rerender(blockPos));
    }

    public static void handlePacket(SChunkDataPacket packet) {
        if (packet.func_149274_i()) {
            FTBChunksClient.rerender(new ChunkPos(packet.func_149273_e(), packet.func_149271_f()));
        }
    }

    public static void handlePacket(SChangeBlockPacket packet) {
        FTBChunksClient.rerender(packet.func_179827_b());
    }

    static {
        minimapTextureId = -1;
        renderedDebugCount = 0;
        updateMinimap = false;
        alwaysRenderChunksOnMap = false;
        nextRegionSave = 0L;
    }
}

