/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import java.io.File;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Comment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ActionResultType;

@Config(name="ftbchunks-client")
@Config.Gui.Background(value="minecraft:textures/block/stone.png")
public class FTBChunksClientConfig
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    private static ConfigHolder<FTBChunksClientConfig> holder = null;
    @Comment(value="Noise added to map to make it look less plastic")
    public float noise = 0.05f;
    @Comment(value="Shadow intensity")
    public float shadows = 0.1f;
    @Comment(value="Chunk grid overlay in large map")
    public boolean chunkGrid = false;
    @Comment(value="Reduces color palette to 256 colors")
    public boolean reducedColorPalette = false;
    @Comment(value="Color intensity")
    public float saturation = 1.0f;
    @Comment(value="Show claimed chunks on the map")
    public boolean claimedChunksOnMap = true;
    @Comment(value="Show your own claimed chunks on the map")
    public boolean ownClaimedChunksOnMap = true;
    @Comment(value="Show waypoints in world")
    public boolean inWorldWaypoints = true;
    @Comment(value="Enables creation of death waypoints")
    public boolean deathWaypoints = true;
    @Comment(value="Different ways to render map")
    public MapMode mapMode = MapMode.NONE;
    @Comment(value="How many blocks should height checks skip in water. 0 means flat water, ignoring terrain")
    public int waterHeightFactor = 8;
    @Comment(value="Enables minimap to show up in corner")
    public MinimapPosition minimap = MinimapPosition.TOP_RIGHT;
    @Comment(value="Scale of minimap")
    public double minimapScale = 1.0;
    @Comment(value="Minimap will not rotate")
    public boolean minimapLockedNorth = true;
    @Comment(value="Show waypoints on minimap")
    public boolean minimapWaypoints = true;
    @Comment(value="Show player heads on minimap")
    public boolean minimapPlayerHeads = true;
    @Comment(value="Show entities on minimap")
    public boolean minimapEntities = true;
    @Comment(value="Show entity heads on minimap")
    public boolean minimapEntityHeads = true;
    @Comment(value="Entities in minimap will be larger")
    public boolean minimapLargeEntities = false;
    @Comment(value="Show XYZ under minimap")
    public boolean minimapXYZ = true;
    @Comment(value="Show biome under minimap")
    public boolean minimapBiome = true;
    @Comment(value="Blurs minimap")
    public boolean minimapBlur = true;
    @Comment(value="Adds NWSE compass inside minimap")
    public boolean minimapCompass = true;
    @Comment(value="Minimap visibility")
    public int minimapVisibility = 255;
    @Comment(value="Show zone (claimed chunk or wilderness) under minimap")
    public boolean minimapZone = true;
    @Comment(value="Enables debug info")
    public boolean debugInfo = false;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. How often queued tasks will run")
    public int taskQueueTicks = 4;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. How often map render update will be queued")
    public int rerenderQueueTicks = 60;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. Max tasks that can queue up")
    public int taskQueueMax = 100;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. Water visibility")
    public int waterVisibility = 220;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. Grass darkness")
    public int grassDarkness = 50;
    @ConfigEntry.Gui.Excluded
    @Comment(value="Advanced option. Foliage darkness")
    public int foliageDarkness = 50;

    public static FTBChunksClientConfig get() {
        return (FTBChunksClientConfig)holder.get();
    }

    public static void init() {
        holder = AutoConfig.register(FTBChunksClientConfig.class, JanksonConfigSerializer::new);
        holder.registerLoadListener((manager, data) -> {
            File oldConfig = Platform.getConfigFolder().resolve("ftbchunks-client.toml").toFile();
            if (oldConfig.exists()) {
                FTBChunks.LOGGER.warn("Old config file ftbchunks-client.toml found, please use the new config format instead!");
                FTBChunks.LOGGER.warn("The old config file will automatically be deleted on exit.");
                oldConfig.deleteOnExit();
            }
            return ActionResultType.PASS;
        });
        holder.registerSaveListener((manager, data) -> {
            data.validatePostLoad();
            return ActionResultType.PASS;
        });
    }

    public void validatePostLoad() {
    }

    public void openSettings(Screen screen) {
        ConfigGroup group = new ConfigGroup("ftbchunks");
        group.addDouble("noise", (double)this.noise, v -> {
            this.noise = v.floatValue();
        }, 0.05, 0.0, 0.5);
        group.addDouble("shadows", (double)this.shadows, v -> {
            this.shadows = v.floatValue();
        }, 0.1, 0.0, 0.3);
        group.addBool("chunk_grid", this.chunkGrid, v -> {
            this.chunkGrid = v;
        }, false);
        group.addBool("reduced_color_palette", this.reducedColorPalette, v -> {
            this.reducedColorPalette = v;
        }, false);
        group.addDouble("saturation", (double)this.saturation, v -> {
            this.saturation = v.floatValue();
        }, 1.0, 0.0, 1.0);
        group.addBool("claimed_chunks_on_map", this.claimedChunksOnMap, v -> {
            this.claimedChunksOnMap = v;
        }, true);
        group.addBool("own_claimed_chunks_on_map", this.ownClaimedChunksOnMap, v -> {
            this.ownClaimedChunksOnMap = v;
        }, true);
        group.addBool("in_world_waypoints", this.inWorldWaypoints, v -> {
            this.inWorldWaypoints = v;
        }, true);
        group.addBool("death_waypoints", this.deathWaypoints, v -> {
            this.deathWaypoints = v;
        }, true);
        group.addEnum("map_mode", (Object)this.mapMode, v -> {
            this.mapMode = v;
        }, NameMap.of((Object)((Object)MapMode.NONE), (Object[])MapMode.values()).create());
        group.addInt("water_height_factor", this.waterHeightFactor, v -> {
            this.waterHeightFactor = v;
        }, 0, 0, 128);
        group.addEnum("minimap", (Object)this.minimap, v -> {
            this.minimap = v;
        }, NameMap.of((Object)((Object)MinimapPosition.TOP_RIGHT), (Object[])MinimapPosition.values()).create());
        group.addDouble("minimap_scale", this.minimapScale, v -> {
            this.minimapScale = v;
        }, 1.0, 0.25, 4.0);
        group.addBool("minimap_locked_north", this.minimapLockedNorth, v -> {
            this.minimapLockedNorth = v;
        }, true);
        group.addBool("minimap_waypoints", this.minimapWaypoints, v -> {
            this.minimapWaypoints = v;
        }, true);
        group.addBool("minimap_entities", this.minimapEntities, v -> {
            this.minimapEntities = v;
        }, true);
        group.addBool("minimap_entity_heads", this.minimapEntityHeads, v -> {
            this.minimapEntityHeads = v;
        }, true);
        group.addBool("minimap_player_heads", this.minimapPlayerHeads, v -> {
            this.minimapPlayerHeads = v;
        }, true);
        group.addBool("minimap_large_entities", this.minimapLargeEntities, v -> {
            this.minimapLargeEntities = v;
        }, false);
        group.addBool("minimap_xyz", this.minimapXYZ, v -> {
            this.minimapXYZ = v;
        }, true);
        group.addBool("minimap_biome", this.minimapBiome, v -> {
            this.minimapBiome = v;
        }, true);
        group.addBool("minimap_blur", this.minimapBlur, v -> {
            this.minimapBlur = v;
        }, true);
        group.addBool("minimap_compass", this.minimapCompass, v -> {
            this.minimapCompass = v;
        }, true);
        group.addInt("minimap_visibility", this.minimapVisibility, v -> {
            this.minimapVisibility = v;
        }, 255, 0, 255);
        group.addBool("minimap_zone", this.minimapZone, v -> {
            this.minimapZone = v;
        }, true);
        group.addBool("debug_info", this.debugInfo, v -> {
            this.debugInfo = v;
        }, false);
        EditConfigScreen gui = new EditConfigScreen(group);
        group.savedCallback = b -> {
            if (b) {
                holder.save();
            }
            if (MapManager.inst != null) {
                MapManager.inst.updateAllRegions(false);
            }
            Minecraft.func_71410_x().func_147108_a(screen);
        };
        gui.openGui();
    }
}

