/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class MapIOUtils {
    public static void write(OutputStream stream, IOCallback<DataOutputStream> callback) {
        try (DataOutputStream s = new DataOutputStream(new BufferedOutputStream(new DeflaterOutputStream(stream)));){
            callback.callback(s);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void write(Path path, IOCallback<DataOutputStream> callback) {
        try (OutputStream fos = Files.newOutputStream(path, new OpenOption[0]);){
            MapIOUtils.write(fos, callback);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean read(Path path, IOCallback<DataInputStream> callback) {
        if (Files.notExists(path, new LinkOption[0])) return false;
        if (!Files.isReadable(path)) {
            return false;
        }
        try (DataInputStream in2222 = new DataInputStream(new BufferedInputStream(new InflaterInputStream(Files.newInputStream(path, new OpenOption[0]))));){
            callback.callback(in2222);
            boolean throwable3 = true;
            return throwable3;
        }
        catch (Exception in2222) {
            try (DataInputStream in3 = new DataInputStream(new BufferedInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]))));){
                callback.callback(in3);
                boolean throwable7 = false;
                return throwable7;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    public static interface IOCallback<T> {
        public void callback(T var1) throws IOException;
    }
}

