/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.core.BiomeFTBC;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;

public class MapManager
implements MapTask {
    public static MapManager inst;
    public final UUID serverId;
    public final Path directory;
    private final Map<RegistryKey<World>, MapDimension> dimensions;
    public boolean saveData;
    private final Int2ObjectOpenHashMap<ResourceLocation> blockColorIndexMap;
    private final Object2IntOpenHashMap<ResourceLocation> blockColorIndexMapReverse;
    private final Int2ObjectOpenHashMap<RegistryKey<Biome>> biomeColorIndexMap;
    private final Int2ObjectOpenHashMap<BlockColor> blockIdToColCache;
    private final List<BiomeFTBC> biomesToRelease;

    public MapManager(UUID id, Path dir) {
        this.serverId = id;
        this.directory = dir;
        this.dimensions = new LinkedHashMap<RegistryKey<World>, MapDimension>();
        this.saveData = false;
        this.blockColorIndexMap = new Int2ObjectOpenHashMap();
        this.blockColorIndexMap.defaultReturnValue((Object)new ResourceLocation("minecraft:air"));
        this.blockColorIndexMapReverse = new Object2IntOpenHashMap();
        this.blockColorIndexMapReverse.defaultReturnValue(0);
        this.biomeColorIndexMap = new Int2ObjectOpenHashMap();
        this.biomeColorIndexMap.defaultReturnValue((Object)Biomes.field_76772_c);
        this.blockIdToColCache = new Int2ObjectOpenHashMap();
        this.biomesToRelease = new ArrayList<BiomeFTBC>();
        try {
            Path path;
            Path blockFile;
            Path dimFile = this.directory.resolve("dimensions.txt");
            if (Files.exists(dimFile, new LinkOption[0])) {
                for (String string : Files.readAllLines(dimFile)) {
                    String string2 = string.trim();
                    if (string2.length() < 3) continue;
                    RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(string2));
                    this.dimensions.put((RegistryKey<World>)key, new MapDimension(this, (RegistryKey<World>)key));
                }
            } else {
                this.saveData = true;
            }
            if (Files.exists(blockFile = this.directory.resolve("block_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(blockFile)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    ResourceLocation loc = new ResourceLocation(s1[1]);
                    this.blockColorIndexMap.put(i, (Object)loc);
                    this.blockColorIndexMapReverse.put((Object)loc, i);
                }
            } else {
                this.saveData = true;
            }
            if (Files.exists(path = this.directory.resolve("biome_map.txt"), new LinkOption[0])) {
                for (String s : Files.readAllLines(path)) {
                    if ((s = s.trim()).isEmpty()) continue;
                    String[] s1 = s.split(" ", 2);
                    int i = Integer.decode(s1[0]);
                    ResourceLocation loc = new ResourceLocation(s1[1]);
                    RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)loc);
                    this.biomeColorIndexMap.put(i, (Object)key);
                }
            } else {
                this.saveData = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Map<RegistryKey<World>, MapDimension> getDimensions() {
        return this.dimensions;
    }

    public MapDimension getDimension(RegistryKey<World> dim) {
        return this.getDimensions().computeIfAbsent(dim, d -> new MapDimension(this, (RegistryKey<World>)d).created());
    }

    public void release() {
        for (MapDimension dimension : this.getDimensions().values()) {
            dimension.release();
        }
        for (BiomeFTBC b : this.biomesToRelease) {
            b.setFTBCBiomeColorIndex(-1);
        }
        this.biomesToRelease.clear();
        this.blockIdToColCache.clear();
    }

    public void updateAllRegions(boolean save) {
        for (MapDimension dimension : this.getDimensions().values()) {
            for (MapRegion region : dimension.getRegions().values()) {
                region.update(save);
            }
        }
        FTBChunksClient.updateMinimap = true;
    }

    @Override
    public void runMapTask() {
        try {
            Files.write(this.directory.resolve("dimensions.txt"), (Iterable<? extends CharSequence>)this.dimensions.keySet().stream().map(key -> key.func_240901_a_().toString()).collect(Collectors.toList()), new OpenOption[0]);
            Files.write(this.directory.resolve("block_map.txt"), (Iterable<? extends CharSequence>)this.blockColorIndexMap.int2ObjectEntrySet().stream().sorted(Map.Entry.comparingByValue()).map(key -> String.format("#%06X %s", key.getIntKey(), key.getValue())).collect(Collectors.toList()), new OpenOption[0]);
            Files.write(this.directory.resolve("biome_map.txt"), (Iterable<? extends CharSequence>)this.biomeColorIndexMap.int2ObjectEntrySet().stream().sorted(Comparator.comparing(o -> ((RegistryKey)o.getValue()).func_240901_a_())).map(key -> String.format("#%03X %s", key.getIntKey(), ((RegistryKey)key.getValue()).func_240901_a_())).collect(Collectors.toList()), new OpenOption[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getBlockColorIndex(ResourceLocation id) {
        int i = this.blockColorIndexMapReverse.getInt((Object)id);
        if (i == 0) {
            Random random = new Random((long)id.func_110624_b().hashCode() & 0xFFFFFFFFL | ((long)id.func_110623_a().hashCode() & 0xFFFFFFFFL) << 32);
            i = id.hashCode() & 0xFFFFFF;
            while (i == 0 || this.blockColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0xFFFFFF;
            }
            this.blockColorIndexMap.put(i, (Object)id);
            this.blockColorIndexMapReverse.put((Object)id, i);
            this.saveData = true;
        }
        return i;
    }

    public int getBiomeColorIndex(World world, Biome biome, Object b0) {
        BiomeFTBC b;
        BiomeFTBC biomeFTBC = b = b0 instanceof BiomeFTBC ? (BiomeFTBC)b0 : null;
        if (b == null) {
            return 0;
        }
        int i = b.getFTBCBiomeColorIndex();
        if (i == -1) {
            RegistryKey key = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230519_c_((Object)biome).orElse(null);
            if (key == null) {
                b.setFTBCBiomeColorIndex(0);
                return 0;
            }
            for (Int2ObjectMap.Entry entry : this.biomeColorIndexMap.int2ObjectEntrySet()) {
                if (entry.getValue() != key) continue;
                i = entry.getIntKey();
                b.setFTBCBiomeColorIndex(i);
                return i;
            }
            Random random = new Random((long)key.func_240901_a_().func_110624_b().hashCode() & 0xFFFFFFFFL | ((long)key.func_240901_a_().func_110623_a().hashCode() & 0xFFFFFFFFL) << 32);
            i = key.func_240901_a_().hashCode() & 0x7FF;
            while (i == 0 || this.biomeColorIndexMap.containsKey(i)) {
                i = random.nextInt() & 0x7FF;
            }
            this.biomeColorIndexMap.put(i, (Object)key);
            b.setFTBCBiomeColorIndex(i);
            this.saveData = true;
            this.biomesToRelease.add(b);
        }
        return i;
    }

    public Block getBlock(int id) {
        ResourceLocation rl = (ResourceLocation)this.blockColorIndexMap.get(id & 0xFFFFFF);
        Block block = rl == null ? null : (Block)FTBChunks.BLOCK_REGISTRY.get(rl);
        return block == null ? Blocks.field_150350_a : block;
    }

    public BlockColor getBlockColor(int id) {
        try {
            return (BlockColor)this.blockIdToColCache.computeIfAbsent(id & 0xFFFFFF, i -> ColorMapLoader.getBlockColor((ResourceLocation)this.blockColorIndexMap.get(i)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return BlockColors.ERROR;
        }
    }

    public RegistryKey<Biome> getBiomeKey(int id) {
        return (RegistryKey)this.biomeColorIndexMap.get(id & 0x7FF);
    }

    public Biome getBiome(World level, int id) {
        return (Biome)level.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(this.getBiomeKey(id));
    }
}

