/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftblibrary.math.XZ;
import net.minecraft.block.BlockState;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColors;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;

public class ReloadChunkTask
implements MapTask {
    private static final ResourceLocation AIR = new ResourceLocation("minecraft:air");
    public final World world;
    public final ChunkPos pos;
    private final MapManager manager;

    public ReloadChunkTask(World w, ChunkPos p) {
        this.world = w;
        this.pos = p;
        this.manager = MapManager.inst;
    }

    @Override
    public void runMapTask() {
        if (MapManager.inst != this.manager) {
            return;
        }
        RegistryKey dimId = this.world.func_234923_W_();
        IChunk ichunk = this.world.func_217353_a(this.pos.field_77276_a, this.pos.field_77275_b, ChunkStatus.field_222617_m, false);
        if (ichunk == null) {
            return;
        }
        MapChunk mapChunk = this.manager.getDimension((RegistryKey<World>)dimId).getRegion(XZ.regionFromChunk((ChunkPos)this.pos)).getDataBlocking().getChunk(XZ.of((ChunkPos)this.pos));
        MapRegionData data = mapChunk.region.getDataBlocking();
        int topY = this.world.func_234938_ad_() + 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        int blockX = this.pos.func_180334_c();
        int blockZ = this.pos.func_180333_d();
        boolean changed = false;
        boolean[] flags = new boolean[1];
        try {
            for (int wi = 0; wi < 256; ++wi) {
                int wx = wi % 16;
                int wz = wi / 16;
                blockPos.func_181079_c(blockX + wx, topY, blockZ + wz);
                int height = MathHelper.func_76125_a((int)MapChunk.getHeight(ichunk, blockPos, flags).func_177956_o(), (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                blockPos.func_185336_p(height);
                BlockState state = ichunk.func_180495_p((BlockPos)blockPos);
                int ax = mapChunk.pos.x * 16 + wx;
                int az = mapChunk.pos.z * 16 + wz;
                int index = ax + az * 512;
                int waterLightAndBiome0 = data.waterLightAndBiome[index] & 0xFFFF;
                int blockIndex0 = data.getBlockIndex(index);
                int height0 = data.height[index] & 0xFFFF;
                int waterLightAndBiome = waterLightAndBiome0 & 0x7FF;
                waterLightAndBiome |= flags[0] ? 32768 : 0;
                waterLightAndBiome |= (this.world.func_226658_a_(LightType.BLOCK, blockPos.func_177984_a()) & 0xF) << 11;
                ResourceLocation id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.func_177230_c());
                int blockIndex = this.manager.getBlockColorIndex(id == null ? AIR : id);
                if (height0 != height || waterLightAndBiome0 == 0) {
                    Biome biome = this.world.func_226691_t_((BlockPos)blockPos);
                    waterLightAndBiome &= 0xF800;
                    waterLightAndBiome |= this.manager.getBiomeColorIndex(this.world, biome, biome) & 0x7FF;
                    data.foliage[index] = data.foliage[index] & 0xFF000000 | BiomeColors.func_228361_b_((IBlockDisplayReader)this.world, (BlockPos)blockPos) & 0xFFFFFF;
                    data.grass[index] = data.grass[index] & 0xFF000000 | BiomeColors.func_228358_a_((IBlockDisplayReader)this.world, (BlockPos)blockPos) & 0xFFFFFF;
                    data.water[index] = data.water[index] & 0xFF000000 | BiomeColors.func_228363_c_((IBlockDisplayReader)this.world, (BlockPos)blockPos) & 0xFFFFFF;
                    changed = true;
                }
                if (height0 != height) {
                    data.height[index] = (short)height;
                    changed = true;
                }
                if (waterLightAndBiome0 != waterLightAndBiome) {
                    data.waterLightAndBiome[index] = (short)waterLightAndBiome;
                    changed = true;
                }
                if (blockIndex0 != blockIndex) {
                    data.setBlockIndex(index, blockIndex);
                    changed = true;
                }
                flags[0] = false;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (changed) {
            mapChunk.modified = System.currentTimeMillis();
            mapChunk.region.update(true);
        }
    }

    public String toString() {
        return "ReloadChunkTask@" + this.pos;
    }
}

