/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.map;

import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.map.MapChunk;
import dev.ftb.mods.ftbchunks.client.map.MapMode;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColor;
import dev.ftb.mods.ftbchunks.client.map.color.BlockColors;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.client.map.color.CustomBlockColor;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.TeamBase;
import dev.ftb.mods.ftbteams.property.TeamProperty;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class RenderMapImageTask
implements MapTask {
    public final MapRegion region;

    public RenderMapImageTask(MapRegion r) {
        this.region = r;
    }

    private static int getHeight(FTBChunksClientConfig c, short data, short height) {
        int h = height & 0xFFFF;
        if (((data & 0xFFFF) >> 15 & 1) != 0 && c.mapMode != MapMode.TOPOGRAPHY) {
            if (c.waterHeightFactor == 0) {
                return 62;
            }
            return h / c.waterHeightFactor * c.waterHeightFactor + c.waterHeightFactor - 1;
        }
        return h;
    }

    @Override
    public void runMapTask() {
        MapRegion rTop;
        FTBChunksClientConfig config = FTBChunksClientConfig.get();
        MapRegionData data = this.region.getDataBlocking();
        short[] heightW = new short[512];
        short[] heightN = new short[512];
        short[] waterLightAndBiomeW = new short[512];
        short[] waterLightAndBiomeN = new short[512];
        MapRegion rEast = this.region.dimension.getRegions().get(this.region.pos.offset(-1, 0));
        if (rEast != null) {
            MapRegionData d = rEast.getDataBlocking();
            for (int i = 0; i < 512; ++i) {
                heightW[i] = d.height[511 + i * 512];
                waterLightAndBiomeW[i] = d.waterLightAndBiome[511 + i * 512];
            }
        } else {
            for (int i = 0; i < 512; ++i) {
                heightW[i] = data.height[i * 512];
                waterLightAndBiomeW[i] = data.waterLightAndBiome[i * 512];
            }
        }
        if ((rTop = this.region.dimension.getRegions().get(this.region.pos.offset(0, -1))) != null) {
            MapRegionData d = rTop.getDataBlocking();
            System.arraycopy(d.height, 261632, heightN, 0, 512);
            System.arraycopy(d.waterLightAndBiome, 261632, waterLightAndBiomeN, 0, 512);
        } else {
            System.arraycopy(data.height, 0, heightN, 0, 512);
            System.arraycopy(data.waterLightAndBiome, 0, waterLightAndBiomeN, 0, 512);
        }
        float[] hsb = new float[3];
        ClientTeam ownTeam = ClientTeamManager.INSTANCE.selfTeam;
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        Int2ObjectOpenHashMap biomeMap = new Int2ObjectOpenHashMap();
        for (int cz = 0; cz < 32; ++cz) {
            for (int cx = 0; cx < 32; ++cx) {
                boolean claimBarRight;
                boolean claimBarLeft;
                boolean claimBarDown;
                boolean claimBarUp;
                Color4I fullClaimColor;
                Color4I claimColor;
                MapChunk c = data.chunks.get(XZ.of((int)cx, (int)cz));
                Random random = new Random(this.region.pos.toLong() ^ (c == null ? 0L : c.pos.toLong()));
                if (c != null && c.claimedDate != null && (FTBChunksClient.alwaysRenderChunksOnMap || (ownTeam.equals((Object)c.getTeam()) ? config.ownClaimedChunksOnMap : config.claimedChunksOnMap))) {
                    claimColor = ((Color4I)c.getTeam().getProperty((TeamProperty)TeamBase.COLOR)).withAlpha(100);
                    fullClaimColor = claimColor.withAlpha(255);
                    claimBarUp = !c.connects(c.offsetBlocking(0, -1));
                    claimBarDown = !c.connects(c.offsetBlocking(0, 1));
                    claimBarLeft = !c.connects(c.offsetBlocking(-1, 0));
                    claimBarRight = !c.connects(c.offsetBlocking(1, 0));
                } else {
                    claimColor = Icon.EMPTY;
                    fullClaimColor = Icon.EMPTY;
                    claimBarUp = false;
                    claimBarDown = false;
                    claimBarLeft = false;
                    claimBarRight = false;
                }
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        Color4I col;
                        int ax = cx * 16 + x;
                        int az = cz * 16 + z;
                        int index = ax + az * 512;
                        if (c == null) {
                            this.region.renderedMapImage.func_195700_a(ax, az, 0);
                            continue;
                        }
                        BlockColor blockColor = this.region.dimension.manager.getBlockColor(data.getBlockIndex(index));
                        int by = RenderMapImageTask.getHeight(config, data.waterLightAndBiome[index], data.height[index]);
                        boolean water = (data.waterLightAndBiome[index] >> 15 & 1) != 0;
                        blockPos.func_181079_c(this.region.pos.x * 512 + ax, by, this.region.pos.z * 512 + az);
                        if (config.mapMode == MapMode.TOPOGRAPHY) {
                            col = ColorUtils.getTopographyPalette()[by + (water ? 256 : 0)];
                        } else if (config.mapMode == MapMode.BLOCKS) {
                            col = Color4I.rgb((int)data.getBlockIndex(index));
                        } else if (config.mapMode == MapMode.BIOME_TEMPERATURE) {
                            Biome biome = (Biome)biomeMap.computeIfAbsent(data.waterLightAndBiome[index] & 0x7FF, arg_0 -> this.lambda$runMapTask$0((World)world, arg_0));
                            float temp0 = biome.func_225486_c((BlockPos)blockPos);
                            float temp = (temp0 + 0.5f) / 2.0f;
                            col = Color4I.hsb((float)((float)(Math.PI - (double)temp * Math.PI)), (float)0.9f, (float)1.0f);
                        } else if (config.mapMode == MapMode.LIGHT_SOURCES) {
                            col = ColorUtils.getLightMapPalette()[15][data.waterLightAndBiome[index] >> 11 & 0xF];
                        } else {
                            col = blockColor instanceof CustomBlockColor ? ((CustomBlockColor)blockColor).color : (blockColor == BlockColors.FOLIAGE ? Color4I.rgb((int)data.foliage[index]).withAlpha(255).withTint(Color4I.BLACK.withAlpha(config.foliageDarkness)) : (blockColor == BlockColors.GRASS ? Color4I.rgb((int)data.grass[index]).withAlpha(255).withTint(Color4I.BLACK.withAlpha(config.grassDarkness)) : blockColor.getBlockColor((IBlockDisplayReader)world, (BlockPos)blockPos).withAlpha(255)));
                            if (config.mapMode == MapMode.NIGHT) {
                                col = col.withTint(ColorUtils.getLightMapPalette()[data.waterLightAndBiome[index] >> 11 & 0xF][15].withAlpha(230));
                            }
                            if (water) {
                                col = col.withTint(Color4I.rgb((int)data.water[index]).withAlpha(config.waterVisibility));
                            }
                            if (config.reducedColorPalette) {
                                col = ColorUtils.reduce(col);
                            }
                        }
                        if (config.saturation < 1.0f) {
                            Color.RGBtoHSB(col.redi(), col.greeni(), col.bluei(), hsb);
                            hsb[1] = hsb[1] * config.saturation;
                            col = Color4I.hsb((float)hsb[0], (float)hsb[1], (float)hsb[2]);
                        }
                        float addedBrightness = 0.0f;
                        if (config.shadows > 0.0f) {
                            int bn = RenderMapImageTask.getHeight(config, az == 0 ? waterLightAndBiomeN[ax] : data.waterLightAndBiome[ax + (az - 1) * 512], az == 0 ? heightN[ax] : data.height[ax + (az - 1) * 512]);
                            int bw = RenderMapImageTask.getHeight(config, ax == 0 ? waterLightAndBiomeW[az] : data.waterLightAndBiome[ax - 1 + az * 512], ax == 0 ? heightW[az] : data.height[ax - 1 + az * 512]);
                            if (by > bn || by > bw) {
                                addedBrightness += config.shadows * (water ? 0.6f : 1.0f);
                            }
                            if (by < bn || by < bw) {
                                addedBrightness -= config.shadows * (water ? 0.6f : 1.0f);
                            }
                        }
                        if (config.noise > 0.0f) {
                            addedBrightness += random.nextFloat() * config.noise - config.noise / 2.0f;
                        }
                        if (addedBrightness != 0.0f) {
                            col = ColorUtils.addBrightness(col, addedBrightness);
                        }
                        if (config.chunkGrid && (x == 0 || z == 0)) {
                            col = col.withTint(MapRegion.GRID_COLOR);
                        }
                        if (!claimColor.isEmpty()) {
                            col = col.withTint(claimColor);
                        }
                        if (claimBarUp && z == 0 || claimBarDown && z == 15 || claimBarLeft && x == 0 || claimBarRight && x == 15) {
                            col = fullClaimColor;
                        }
                        this.region.renderedMapImage.func_195700_a(ax, az, ColorUtils.convertToNative(0xFF000000 | col.rgb()));
                    }
                }
            }
        }
        this.region.updateRenderedMapTexture = true;
        FTBChunksClient.updateMinimap = true;
        this.region.renderingMapImage = false;
    }

    public String toString() {
        return "RenderMapImageTask@" + this.region.pos;
    }

    private /* synthetic */ Biome lambda$runMapTask$0(World world, int i) {
        return this.region.dimension.manager.getBiome(world, i);
    }
}

