/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import me.shedaniel.architectury.hooks.PlayerHooks;
import net.minecraft.block.BlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Util;
import net.minecraft.world.server.ServerWorld;

public class ClaimedChunk
implements ClaimResult {
    public FTBChunksTeamData teamData;
    public final ChunkDimPos pos;
    public long forceLoaded;
    public long time;

    public ClaimedChunk(FTBChunksTeamData p, ChunkDimPos cp) {
        this.teamData = p;
        this.pos = cp;
        this.forceLoaded = 0L;
        this.time = System.currentTimeMillis();
    }

    public FTBChunksTeamData getTeamData() {
        return this.teamData;
    }

    public ChunkDimPos getPos() {
        return this.pos;
    }

    public long getTimeClaimed() {
        return this.time;
    }

    @Override
    public boolean isSuccess() {
        return true;
    }

    @Override
    public void setClaimedTime(long t) {
        this.time = t;
        this.sendUpdateToAll();
    }

    public long getForceLoadedTime() {
        return this.forceLoaded;
    }

    public boolean isForceLoaded() {
        return this.forceLoaded > 0L;
    }

    @Override
    public void setForceLoadedTime(long time) {
        this.forceLoaded = time;
    }

    public boolean canEdit(ServerPlayerEntity player, BlockState state) {
        if (FTBChunksAPI.EDIT_TAG.func_230235_a_((Object)state.func_177230_c()) || this.teamData.canUse(player, FTBChunksTeamData.BLOCK_EDIT_MODE)) {
            return true;
        }
        if (!PlayerHooks.isFake((PlayerEntity)player)) {
            FTBChunksTeamData pd = this.teamData.manager.getData(player);
            return pd.getBypassProtection(player);
        }
        return false;
    }

    public boolean canInteract(ServerPlayerEntity player, BlockState state) {
        if (FTBChunksAPI.INTERACT_TAG.func_230235_a_((Object)state.func_177230_c()) || this.teamData.canUse(player, FTBChunksTeamData.BLOCK_INTERACT_MODE)) {
            return true;
        }
        if (!PlayerHooks.isFake((PlayerEntity)player)) {
            FTBChunksTeamData pd = this.teamData.manager.getData(player);
            return pd.getBypassProtection(player);
        }
        return false;
    }

    public boolean canRightClickItem(ServerPlayerEntity player, ItemStack item) {
        FTBChunksTeamData pd;
        if (this.teamData.canUse(player, FTBChunksTeamData.BLOCK_INTERACT_MODE)) {
            return true;
        }
        if (!PlayerHooks.isFake((PlayerEntity)player) && (pd = this.teamData.manager.getData(player)).getBypassProtection(player)) {
            return true;
        }
        return !FTBChunksAPI.RIGHT_CLICK_BLACKLIST_TAG.func_230235_a_((Object)item.func_77973_b());
    }

    public boolean canEntitySpawn(Entity entity) {
        return true;
    }

    public boolean allowExplosions() {
        return false;
    }

    public void postSetForceLoaded(boolean load) {
        ServerWorld world = this.getTeamData().getManager().getMinecraftServer().func_71218_a(this.getPos().dimension);
        if (world != null && world.func_217458_b(this.getPos().x, this.getPos().z, load)) {
            this.sendUpdateToAll();
        }
    }

    public void sendUpdateToAll() {
        SendChunkPacket packet = new SendChunkPacket();
        packet.dimension = this.pos.dimension;
        packet.teamId = this.teamData.getTeamId();
        packet.chunk = new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, this);
        packet.sendToAll(this.teamData.manager.getMinecraftServer());
    }

    public void unload(CommandSource source) {
        if (this.isForceLoaded()) {
            this.setForceLoadedTime(0L);
            this.postSetForceLoaded(false);
            ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNLOAD.invoker()).after(source, this);
            this.teamData.save();
        }
    }

    public void unclaim(CommandSource source, boolean sync) {
        this.unload(source);
        this.teamData.manager.claimedChunks.remove(this.pos);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_UNCLAIM.invoker()).after(source, this);
        this.teamData.save();
        if (sync) {
            SendChunkPacket packet = new SendChunkPacket();
            packet.dimension = this.pos.dimension;
            packet.teamId = Util.field_240973_b_;
            packet.chunk = new SendChunkPacket.SingleChunk(System.currentTimeMillis(), this.pos.x, this.pos.z, null);
            packet.sendToAll(source.func_197028_i());
        }
    }
}

