/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftbteams.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.data.Team;
import dev.ftb.mods.ftbteams.data.TeamManager;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.shedaniel.architectury.hooks.LevelResourceHooks;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.storage.FolderName;
import org.jetbrains.annotations.Nullable;

public class ClaimedChunkManager {
    public static final FolderName DATA_DIR = LevelResourceHooks.create((String)"ftbchunks");
    public final TeamManager teamManager;
    public final FTBChunksWorldConfig config;
    public final Map<UUID, FTBChunksTeamData> teamData;
    public final Map<ChunkDimPos, ClaimedChunk> claimedChunks;
    public Path dataDirectory;
    public Path localDirectory;

    public ClaimedChunkManager(TeamManager m) {
        this.teamManager = m;
        this.config = FTBChunksWorldConfig.init(this.getMinecraftServer());
        this.teamData = new HashMap<UUID, FTBChunksTeamData>();
        this.claimedChunks = new HashMap<ChunkDimPos, ClaimedChunk>();
        this.dataDirectory = this.getMinecraftServer().func_240776_a_(DATA_DIR);
        this.localDirectory = Platform.getGameFolder().resolve("local/ftbchunks");
        try {
            if (Files.notExists(this.dataDirectory, new LinkOption[0])) {
                Files.createDirectories(this.dataDirectory, new FileAttribute[0]);
            }
            if (Files.notExists(this.localDirectory, new LinkOption[0])) {
                Files.createDirectories(this.localDirectory, new FileAttribute[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init() {
        long nanos = System.nanoTime();
        int forceLoaded = 0;
        for (ClaimedChunk chunk : this.claimedChunks.values()) {
            if (!chunk.isForceLoaded() || !chunk.getTeamData().getChunkLoadOffline()) continue;
            ++forceLoaded;
            chunk.postSetForceLoaded(true);
        }
        FTBChunks.LOGGER.info("Server " + this.teamManager.getId() + ": Loaded " + this.claimedChunks.size() + " chunks (" + forceLoaded + " force loaded) from " + this.teamData.size() + " teams in " + (double)(System.nanoTime() - nanos) / 1000000.0 + "ms");
    }

    private FTBChunksTeamData loadTeamData(Team team) {
        Path path = this.dataDirectory.resolve(team.getId() + ".snbt");
        FTBChunksTeamData data = new FTBChunksTeamData(this, path, team);
        CompoundNBT dataFile = SNBT.read((Path)path);
        if (dataFile != null) {
            data.deserializeNBT(dataFile);
            this.teamData.put(team.getId(), data);
            for (ClaimedChunk chunk : data.getClaimedChunks()) {
                if (!chunk.isForceLoaded() || !chunk.getTeamData().getChunkLoadOffline()) continue;
                chunk.postSetForceLoaded(true);
            }
            return data;
        }
        return data;
    }

    public MinecraftServer getMinecraftServer() {
        return this.teamManager.server;
    }

    public FTBChunksTeamData getData(@Nullable Team team) {
        if (team == null) {
            throw new IllegalArgumentException("Team not found!");
        }
        FTBChunksTeamData data = this.teamData.get(team.getId());
        if (data == null) {
            data = this.loadTeamData(team);
            this.teamData.put(team.getId(), data);
        }
        return data;
    }

    public FTBChunksTeamData getData(ServerPlayerEntity player) {
        return this.getData(FTBTeamsAPI.getPlayerTeam((ServerPlayerEntity)player));
    }

    @Nullable
    public ClaimedChunk getChunk(ChunkDimPos pos) {
        return this.claimedChunks.get(pos);
    }

    public Collection<ClaimedChunk> getAllClaimedChunks() {
        return this.claimedChunks.values();
    }
}

