/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimResult;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.net.snm.BaseC2SPacket;
import dev.ftb.mods.ftblibrary.net.snm.PacketID;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;

public class RequestChunkChangePacket
extends BaseC2SPacket {
    private final int action;
    private final Set<XZ> chunks;

    public RequestChunkChangePacket(int a, Set<XZ> c) {
        this.action = a;
        this.chunks = c;
    }

    RequestChunkChangePacket(PacketBuffer buf) {
        this.action = buf.func_150792_a();
        int s = buf.func_150792_a();
        this.chunks = new LinkedHashSet<XZ>(s);
        for (int i = 0; i < s; ++i) {
            int x = buf.func_150792_a();
            int z = buf.func_150792_a();
            this.chunks.add(XZ.of((int)x, (int)z));
        }
    }

    public PacketID getId() {
        return FTBChunksNet.REQUEST_CHUNK_CHANGE;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.action);
        buf.func_150787_b(this.chunks.size());
        for (XZ pos : this.chunks) {
            buf.func_150787_b(pos.x);
            buf.func_150787_b(pos.z);
        }
    }

    public void handle(NetworkManager.PacketContext context) {
        Consumer<XZ> consumer;
        ServerPlayerEntity player = (ServerPlayerEntity)context.getPlayer();
        CommandSource source = player.func_195051_bN();
        FTBChunksTeamData data = FTBChunksAPI.getManager().getData(player);
        long now = System.currentTimeMillis();
        switch (this.action) {
            case 0: {
                consumer = pos -> {
                    ClaimResult result = data.claim(source, pos.dim(player.field_70170_p), false);
                    if (result.isSuccess()) {
                        result.setClaimedTime(now);
                    }
                };
                break;
            }
            case 1: {
                consumer = pos -> data.unclaim(source, pos.dim(player.field_70170_p), false);
                break;
            }
            case 2: {
                consumer = pos -> {
                    ClaimResult result = data.load(source, pos.dim(player.field_70170_p), false);
                    if (result.isSuccess()) {
                        result.setForceLoadedTime(now);
                    }
                };
                break;
            }
            case 3: {
                consumer = pos -> data.unload(source, pos.dim(player.field_70170_p), false);
                break;
            }
            default: {
                FTBChunks.LOGGER.warn("Unknown chunk action ID: " + this.action);
                return;
            }
        }
        for (XZ pos2 : this.chunks) {
            consumer.accept(pos2);
        }
        SendGeneralDataPacket.send(data, player);
    }
}

