/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.ClaimedChunk;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftblibrary.net.snm.BaseS2CPacket;
import dev.ftb.mods.ftblibrary.net.snm.PacketID;
import java.util.UUID;
import javax.annotation.Nullable;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class SendChunkPacket
extends BaseS2CPacket {
    public RegistryKey<World> dimension;
    public UUID teamId;
    public SingleChunk chunk;

    public SendChunkPacket() {
    }

    public PacketID getId() {
        return FTBChunksNet.SEND_CHUNK;
    }

    SendChunkPacket(PacketBuffer buf) {
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
        this.teamId = buf.func_179253_g();
        this.chunk = new SingleChunk(buf, this.teamId);
    }

    public void write(PacketBuffer buf) {
        buf.func_192572_a(this.dimension.func_240901_a_());
        buf.func_179252_a(this.teamId);
        this.chunk.write(buf, this.teamId);
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateChunk(this);
    }

    public static class SingleChunk {
        public int x;
        public int z;
        public long relativeTimeClaimed;
        public long relativeTimeForceLoaded;
        public boolean forceLoaded;

        public SingleChunk(long now, int _x, int _z, @Nullable ClaimedChunk claimedChunk) {
            this.x = _x;
            this.z = _z;
            if (claimedChunk != null) {
                this.relativeTimeClaimed = now - claimedChunk.getTimeClaimed();
                this.forceLoaded = claimedChunk.isForceLoaded();
                if (this.forceLoaded) {
                    this.relativeTimeForceLoaded = now - claimedChunk.getForceLoadedTime();
                }
            }
        }

        public SingleChunk(PacketBuffer buf, UUID teamId) {
            this.x = buf.func_150792_a();
            this.z = buf.func_150792_a();
            if (!teamId.equals(Util.field_240973_b_)) {
                this.relativeTimeClaimed = buf.func_179260_f();
                this.forceLoaded = buf.readBoolean();
                if (this.forceLoaded) {
                    this.relativeTimeForceLoaded = buf.func_179260_f();
                }
            }
        }

        public void write(PacketBuffer buf, UUID teamId) {
            buf.func_150787_b(this.x);
            buf.func_150787_b(this.z);
            if (!teamId.equals(Util.field_240973_b_)) {
                buf.func_179254_b(this.relativeTimeClaimed);
                buf.writeBoolean(this.forceLoaded);
                if (this.forceLoaded) {
                    buf.func_179254_b(this.relativeTimeForceLoaded);
                }
            }
        }
    }
}

