/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.net;

import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.data.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.data.FTBChunksTeamData;
import dev.ftb.mods.ftbchunks.data.PlayerLocation;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.VisiblePlayerListItem;
import dev.ftb.mods.ftblibrary.net.snm.BaseS2CPacket;
import dev.ftb.mods.ftblibrary.net.snm.PacketID;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class SendVisiblePlayerListPacket
extends BaseS2CPacket {
    public final List<PlayerLocation> players;
    public final RegistryKey<World> dim;

    public SendVisiblePlayerListPacket(List<PlayerLocation> p, RegistryKey<World> d) {
        this.players = p;
        this.dim = d;
    }

    SendVisiblePlayerListPacket(PacketBuffer buf) {
        int s = buf.func_150792_a();
        this.players = new ArrayList<PlayerLocation>(s);
        for (int i = 0; i < s; ++i) {
            PlayerLocation p = new PlayerLocation();
            long most = buf.readLong();
            long least = buf.readLong();
            p.uuid = new UUID(most, least);
            p.name = buf.func_150789_c(Short.MAX_VALUE);
            p.x = buf.func_150792_a();
            p.z = buf.func_150792_a();
            this.players.add(p);
        }
        this.dim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)buf.func_192575_l());
    }

    public static void sendAll() {
        ArrayList<VisiblePlayerListItem> playerList = new ArrayList<VisiblePlayerListItem>();
        for (ServerPlayerEntity player : FTBChunksAPI.getManager().teamManager.server.func_184103_al().func_181057_v()) {
            VisiblePlayerListItem item = new VisiblePlayerListItem();
            item.player = player;
            item.data = FTBChunksAPI.getManager().getData(player);
            item.location = new PlayerLocation((PlayerEntity)player);
            playerList.add(item);
        }
        for (VisiblePlayerListItem self : playerList) {
            RegistryKey dim = self.player.field_70170_p.func_234923_W_();
            ArrayList<PlayerLocation> players = new ArrayList<PlayerLocation>();
            for (VisiblePlayerListItem other : playerList) {
                if (other.player.field_70170_p != self.player.field_70170_p || !self.data.canUse(other.player, FTBChunksTeamData.LOCATION_MODE)) continue;
                players.add(other.location);
            }
            new SendVisiblePlayerListPacket(players, (RegistryKey<World>)dim).sendTo(self.player);
        }
    }

    public PacketID getId() {
        return FTBChunksNet.SEND_VISIBLE_PLAYER_LIST;
    }

    public void write(PacketBuffer buf) {
        buf.func_150787_b(this.players.size());
        for (PlayerLocation p : this.players) {
            buf.writeLong(p.uuid.getMostSignificantBits());
            buf.writeLong(p.uuid.getLeastSignificantBits());
            buf.func_211400_a(p.name, Short.MAX_VALUE);
            buf.func_150787_b(p.x);
            buf.func_150787_b(p.z);
        }
        buf.func_192572_a(this.dim.func_240901_a_());
    }

    public void handle(NetworkManager.PacketContext context) {
        FTBChunks.PROXY.updateVisiblePlayerList(this);
    }
}

