/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.criterion;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.FluidState;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.StateHolder;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.JSONUtils;

public class StatePropertiesPredicate {
    public static final StatePropertiesPredicate field_227178_a_ = new StatePropertiesPredicate((List<Matcher>)ImmutableList.of());
    private final List<Matcher> field_227179_b_;

    private static Matcher func_227188_a_(String string, JsonElement jsonElement2) {
        JsonElement jsonElement2;
        if (jsonElement2.isJsonPrimitive()) {
            String string2 = jsonElement2.getAsString();
            return new ExactMatcher(string, string2);
        }
        JsonObject \u26032 = JSONUtils.func_151210_l(jsonElement2, "value");
        String \u26033 = \u26032.has("min") ? StatePropertiesPredicate.func_227189_b_(\u26032.get("min")) : null;
        String \u26034 = \u26032.has("max") ? StatePropertiesPredicate.func_227189_b_(\u26032.get("max")) : null;
        return \u26033 != null && \u26033.equals(\u26034) ? new ExactMatcher(string, \u26033) : new RangedMacher(string, \u26033, \u26034);
    }

    @Nullable
    private static String func_227189_b_(JsonElement jsonElement) {
        if (jsonElement.isJsonNull()) {
            return null;
        }
        return jsonElement.getAsString();
    }

    private StatePropertiesPredicate(List<Matcher> list) {
        this.field_227179_b_ = ImmutableList.copyOf(list);
    }

    public <S extends StateHolder<?, S>> boolean func_227182_a_(StateContainer<?, S> stateContainer, S s) {
        for (Matcher matcher : this.field_227179_b_) {
            if (matcher.func_227199_a_(stateContainer, s)) continue;
            return false;
        }
        return true;
    }

    public boolean func_227181_a_(BlockState blockState) {
        return this.func_227182_a_(blockState.func_177230_c().func_176194_O(), blockState);
    }

    public boolean func_227185_a_(FluidState fluidState) {
        return this.func_227182_a_(fluidState.func_206886_c().func_207182_e(), fluidState);
    }

    public void func_227183_a_(StateContainer<?, ?> stateContainer, Consumer<String> consumer) {
        this.field_227179_b_.forEach(matcher -> matcher.func_227200_a_(stateContainer, consumer));
    }

    public static StatePropertiesPredicate func_227186_a_(@Nullable JsonElement jsonElement) {
        if (jsonElement == null || jsonElement.isJsonNull()) {
            return field_227178_a_;
        }
        JsonObject jsonObject = JSONUtils.func_151210_l(jsonElement, "properties");
        ArrayList \u26032 = Lists.newArrayList();
        for (Map.Entry entry : jsonObject.entrySet()) {
            \u26032.add(StatePropertiesPredicate.func_227188_a_((String)entry.getKey(), (JsonElement)entry.getValue()));
        }
        return new StatePropertiesPredicate(\u26032);
    }

    public JsonElement func_227180_a_() {
        if (this == field_227178_a_) {
            return JsonNull.INSTANCE;
        }
        JsonObject jsonObject = new JsonObject();
        if (!this.field_227179_b_.isEmpty()) {
            this.field_227179_b_.forEach(matcher -> jsonObject.add(matcher.func_227201_b_(), matcher.func_225553_a_()));
        }
        return jsonObject;
    }

    public static class Builder {
        private final List<Matcher> field_227190_a_ = Lists.newArrayList();

        private Builder() {
        }

        public static Builder func_227191_a_() {
            return new Builder();
        }

        public Builder func_227194_a_(Property<?> property, String string) {
            this.field_227190_a_.add(new ExactMatcher(property.func_177701_a(), string));
            return this;
        }

        public Builder func_227192_a_(Property<Integer> property, int n) {
            return this.func_227194_a_(property, Integer.toString(n));
        }

        public Builder func_227195_a_(Property<Boolean> property, boolean bl) {
            return this.func_227194_a_(property, Boolean.toString(bl));
        }

        public <T extends Comparable<T> & IStringSerializable> Builder func_227193_a_(Property<T> property, T t) {
            return this.func_227194_a_(property, ((IStringSerializable)t).func_176610_l());
        }

        public StatePropertiesPredicate func_227196_b_() {
            return new StatePropertiesPredicate(this.field_227190_a_);
        }
    }

    static class RangedMacher
    extends Matcher {
        @Nullable
        private final String field_227202_a_;
        @Nullable
        private final String field_227203_b_;

        public RangedMacher(String string, @Nullable String string2, @Nullable String string3) {
            super(string);
            this.field_227202_a_ = string2;
            this.field_227203_b_ = string3;
        }

        @Override
        protected <T extends Comparable<T>> boolean func_225554_a_(StateHolder<?, ?> stateHolder, Property<T> property) {
            T t = stateHolder.func_177229_b(property);
            if (!(this.field_227202_a_ == null || (\u2603 = property.func_185929_b(this.field_227202_a_)).isPresent() && t.compareTo(\u2603.get()) >= 0)) {
                return false;
            }
            return this.field_227203_b_ == null || (\u2603 = property.func_185929_b(this.field_227203_b_)).isPresent() && t.compareTo(\u2603.get()) <= 0;
        }

        @Override
        public JsonElement func_225553_a_() {
            JsonObject jsonObject = new JsonObject();
            if (this.field_227202_a_ != null) {
                jsonObject.addProperty("min", this.field_227202_a_);
            }
            if (this.field_227203_b_ != null) {
                jsonObject.addProperty("max", this.field_227203_b_);
            }
            return jsonObject;
        }
    }

    static class ExactMatcher
    extends Matcher {
        private final String field_227197_a_;

        public ExactMatcher(String string, String string2) {
            super(string);
            this.field_227197_a_ = string2;
        }

        @Override
        protected <T extends Comparable<T>> boolean func_225554_a_(StateHolder<?, ?> stateHolder, Property<T> property) {
            T t = stateHolder.func_177229_b(property);
            Optional<T> \u26032 = property.func_185929_b(this.field_227197_a_);
            return \u26032.isPresent() && t.compareTo(\u26032.get()) == 0;
        }

        @Override
        public JsonElement func_225553_a_() {
            return new JsonPrimitive(this.field_227197_a_);
        }
    }

    static abstract class Matcher {
        private final String field_227198_a_;

        public Matcher(String string) {
            this.field_227198_a_ = string;
        }

        public <S extends StateHolder<?, S>> boolean func_227199_a_(StateContainer<?, S> stateContainer, S s) {
            Property<?> property = stateContainer.func_185920_a(this.field_227198_a_);
            if (property == null) {
                return false;
            }
            return this.func_225554_a_(s, property);
        }

        protected abstract <T extends Comparable<T>> boolean func_225554_a_(StateHolder<?, ?> var1, Property<T> var2);

        public abstract JsonElement func_225553_a_();

        public String func_227201_b_() {
            return this.field_227198_a_;
        }

        public void func_227200_a_(StateContainer<?, ?> stateContainer, Consumer<String> consumer) {
            Property<?> property = stateContainer.func_185920_a(this.field_227198_a_);
            if (property == null) {
                consumer.accept(this.field_227198_a_);
            }
        }
    }
}

