/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.Position;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.tileentity.DropperTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DispenserBlock
extends ContainerBlock {
    public static final DirectionProperty field_176441_a = DirectionalBlock.field_176387_N;
    public static final BooleanProperty field_176440_b = BlockStateProperties.field_208197_x;
    private static final Map<Item, IDispenseItemBehavior> field_149943_a = (Map)Util.func_200696_a(new Object2ObjectOpenHashMap(), object2ObjectOpenHashMap -> object2ObjectOpenHashMap.defaultReturnValue((Object)new DefaultDispenseItemBehavior()));

    public static void func_199774_a(IItemProvider iItemProvider, IDispenseItemBehavior iDispenseItemBehavior) {
        field_149943_a.put(iItemProvider.func_199767_j(), iDispenseItemBehavior);
    }

    protected DispenserBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(field_176441_a, Direction.NORTH)).func_206870_a(field_176440_b, false));
    }

    @Override
    public ActionResultType func_225533_a_(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof DispenserTileEntity) {
            playerEntity.func_213829_a((DispenserTileEntity)tileEntity);
            if (tileEntity instanceof DropperTileEntity) {
                playerEntity.func_195066_a(Stats.field_188083_Q);
            } else {
                playerEntity.func_195066_a(Stats.field_188085_S);
            }
        }
        return ActionResultType.CONSUME;
    }

    protected void func_176439_d(ServerWorld serverWorld, BlockPos blockPos) {
        ProxyBlockSource proxyBlockSource = new ProxyBlockSource(serverWorld, blockPos);
        DispenserTileEntity \u26032 = (DispenserTileEntity)proxyBlockSource.func_150835_j();
        int \u26033 = \u26032.func_146017_i();
        if (\u26033 < 0) {
            serverWorld.func_217379_c(1001, blockPos, 0);
            return;
        }
        ItemStack \u26034 = \u26032.func_70301_a(\u26033);
        IDispenseItemBehavior \u26035 = this.func_149940_a(\u26034);
        if (\u26035 != IDispenseItemBehavior.field_223216_a_) {
            \u26032.func_70299_a(\u26033, \u26035.dispense(proxyBlockSource, \u26034));
        }
    }

    protected IDispenseItemBehavior func_149940_a(ItemStack itemStack) {
        return field_149943_a.get(itemStack.func_77973_b());
    }

    @Override
    public void func_220069_a(BlockState blockState, World world, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        \u2603 = world.func_175640_z(blockPos) || world.func_175640_z(blockPos.func_177984_a());
        \u2603 = blockState.func_177229_b(field_176440_b);
        if (\u2603 && !\u2603) {
            world.func_205220_G_().func_205360_a(blockPos, this, 4);
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176440_b, true), 4);
        } else if (!\u2603 && \u2603) {
            world.func_180501_a(blockPos, (BlockState)blockState.func_206870_a(field_176440_b, false), 4);
        }
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld serverWorld, BlockPos blockPos, Random random) {
        this.func_176439_d(serverWorld, blockPos);
    }

    @Override
    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return new DispenserTileEntity();
    }

    @Override
    public BlockState func_196258_a(BlockItemUseContext blockItemUseContext) {
        return (BlockState)this.func_176223_P().func_206870_a(field_176441_a, blockItemUseContext.func_196010_d().func_176734_d());
    }

    @Override
    public void func_180633_a(World world, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (itemStack.func_82837_s() && (\u2603 = world.func_175625_s(blockPos)) instanceof DispenserTileEntity) {
            ((DispenserTileEntity)\u2603).func_213903_a(itemStack.func_200301_q());
        }
    }

    @Override
    public void func_196243_a(BlockState blockState, World world, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (blockState.func_203425_a(blockState2.func_177230_c())) {
            return;
        }
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity instanceof DispenserTileEntity) {
            InventoryHelper.func_180175_a(world, blockPos, (DispenserTileEntity)tileEntity);
            world.func_175666_e(blockPos, this);
        }
        super.func_196243_a(blockState, world, blockPos, blockState2, bl);
    }

    public static IPosition func_149939_a(IBlockSource iBlockSource) {
        Direction direction = iBlockSource.func_189992_e().func_177229_b(field_176441_a);
        double \u26032 = iBlockSource.func_82615_a() + 0.7 * (double)direction.func_82601_c();
        double \u26033 = iBlockSource.func_82617_b() + 0.7 * (double)direction.func_96559_d();
        double \u26034 = iBlockSource.func_82616_c() + 0.7 * (double)direction.func_82599_e();
        return new Position(\u26032, \u26033, \u26034);
    }

    @Override
    public boolean func_149740_M(BlockState blockState) {
        return true;
    }

    @Override
    public int func_180641_l(BlockState blockState, World world, BlockPos blockPos) {
        return Container.func_178144_a(world.func_175625_s(blockPos));
    }

    @Override
    public BlockRenderType func_149645_b(BlockState blockState) {
        return BlockRenderType.MODEL;
    }

    @Override
    public BlockState func_185499_a(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.func_206870_a(field_176441_a, rotation.func_185831_a(blockState.func_177229_b(field_176441_a)));
    }

    @Override
    public BlockState func_185471_a(BlockState blockState, Mirror mirror) {
        return blockState.func_185907_a(mirror.func_185800_a(blockState.func_177229_b(field_176441_a)));
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(field_176441_a, field_176440_b);
    }
}

