/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CookingRecipeSerializer;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class CookingRecipeBuilder {
    private final Item field_218636_a;
    private final Ingredient field_218637_b;
    private final float field_218638_c;
    private final int field_218639_d;
    private final Advancement.Builder field_218640_e = Advancement.Builder.func_200278_a();
    private String field_218641_f;
    private final CookingRecipeSerializer<?> field_218642_g;

    private CookingRecipeBuilder(IItemProvider iItemProvider, Ingredient ingredient, float f, int n, CookingRecipeSerializer<?> cookingRecipeSerializer) {
        this.field_218636_a = iItemProvider.func_199767_j();
        this.field_218637_b = ingredient;
        this.field_218638_c = f;
        this.field_218639_d = n;
        this.field_218642_g = cookingRecipeSerializer;
    }

    public static CookingRecipeBuilder func_218631_a(Ingredient ingredient, IItemProvider iItemProvider, float f, int n, CookingRecipeSerializer<?> cookingRecipeSerializer) {
        return new CookingRecipeBuilder(iItemProvider, ingredient, f, n, cookingRecipeSerializer);
    }

    public static CookingRecipeBuilder func_218633_b(Ingredient ingredient, IItemProvider iItemProvider, float f, int n) {
        return CookingRecipeBuilder.func_218631_a(ingredient, iItemProvider, f, n, IRecipeSerializer.field_222172_p);
    }

    public static CookingRecipeBuilder func_218629_c(Ingredient ingredient, IItemProvider iItemProvider, float f, int n) {
        return CookingRecipeBuilder.func_218631_a(ingredient, iItemProvider, f, n, IRecipeSerializer.field_222171_o);
    }

    public CookingRecipeBuilder func_218628_a(String string, ICriterionInstance iCriterionInstance) {
        this.field_218640_e.func_200275_a(string, iCriterionInstance);
        return this;
    }

    public void func_218630_a(Consumer<IFinishedRecipe> consumer) {
        this.func_218635_a(consumer, Registry.field_212630_s.func_177774_c(this.field_218636_a));
    }

    public void func_218632_a(Consumer<IFinishedRecipe> consumer, String string) {
        ResourceLocation resourceLocation = new ResourceLocation(string);
        \u2603 = Registry.field_212630_s.func_177774_c(this.field_218636_a);
        if (resourceLocation.equals(\u2603)) {
            throw new IllegalStateException("Recipe " + resourceLocation + " should remove its 'save' argument");
        }
        this.func_218635_a(consumer, resourceLocation);
    }

    public void func_218635_a(Consumer<IFinishedRecipe> consumer, ResourceLocation resourceLocation) {
        this.func_218634_a(resourceLocation);
        this.field_218640_e.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", RecipeUnlockedTrigger.func_235675_a_(resourceLocation)).func_200271_a(AdvancementRewards.Builder.func_200280_c(resourceLocation)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        consumer.accept(new Result(resourceLocation, this.field_218641_f == null ? "" : this.field_218641_f, this.field_218637_b, this.field_218636_a, this.field_218638_c, this.field_218639_d, this.field_218640_e, new ResourceLocation(resourceLocation.func_110624_b(), "recipes/" + this.field_218636_a.func_77640_w().func_200300_c() + "/" + resourceLocation.func_110623_a()), this.field_218642_g));
    }

    private void func_218634_a(ResourceLocation resourceLocation) {
        if (this.field_218640_e.func_200277_c().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + resourceLocation);
        }
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation field_218611_a;
        private final String field_218612_b;
        private final Ingredient field_218613_c;
        private final Item field_218614_d;
        private final float field_218615_e;
        private final int field_218616_f;
        private final Advancement.Builder field_218617_g;
        private final ResourceLocation field_218618_h;
        private final IRecipeSerializer<? extends AbstractCookingRecipe> field_218619_i;

        public Result(ResourceLocation resourceLocation, String string, Ingredient ingredient, Item item, float f, int n, Advancement.Builder builder, ResourceLocation resourceLocation2, IRecipeSerializer<? extends AbstractCookingRecipe> iRecipeSerializer) {
            this.field_218611_a = resourceLocation;
            this.field_218612_b = string;
            this.field_218613_c = ingredient;
            this.field_218614_d = item;
            this.field_218615_e = f;
            this.field_218616_f = n;
            this.field_218617_g = builder;
            this.field_218618_h = resourceLocation2;
            this.field_218619_i = iRecipeSerializer;
        }

        @Override
        public void func_218610_a(JsonObject jsonObject) {
            if (!this.field_218612_b.isEmpty()) {
                jsonObject.addProperty("group", this.field_218612_b);
            }
            jsonObject.add("ingredient", this.field_218613_c.func_200304_c());
            jsonObject.addProperty("result", Registry.field_212630_s.func_177774_c(this.field_218614_d).toString());
            jsonObject.addProperty("experience", (Number)Float.valueOf(this.field_218615_e));
            jsonObject.addProperty("cookingtime", (Number)this.field_218616_f);
        }

        @Override
        public IRecipeSerializer<?> func_218609_c() {
            return this.field_218619_i;
        }

        @Override
        public ResourceLocation func_200442_b() {
            return this.field_218611_a;
        }

        @Override
        @Nullable
        public JsonObject func_200440_c() {
            return this.field_218617_g.func_200273_b();
        }

        @Override
        @Nullable
        public ResourceLocation func_200443_d() {
            return this.field_218618_h;
        }
    }
}

