/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.AsyncReloader;
import net.minecraft.resources.DebugAsyncReloader;
import net.minecraft.resources.FallbackResourceManager;
import net.minecraft.resources.IAsyncReloader;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class SimpleReloadableResourceManager
implements IReloadableResourceManager {
    private static final Logger field_199012_a = LogManager.getLogger();
    private final Map<String, FallbackResourceManager> field_199014_c = Maps.newHashMap();
    private final List<IFutureReloadListener> field_199015_d = Lists.newArrayList();
    private final List<IFutureReloadListener> field_219539_d = Lists.newArrayList();
    private final Set<String> field_199016_e = Sets.newLinkedHashSet();
    private final List<IResourcePack> field_232636_f_ = Lists.newArrayList();
    private final ResourcePackType field_199017_f;

    public SimpleReloadableResourceManager(ResourcePackType resourcePackType) {
        this.field_199017_f = resourcePackType;
    }

    public void func_199021_a(IResourcePack iResourcePack) {
        this.field_232636_f_.add(iResourcePack);
        for (String string : iResourcePack.func_195759_a(this.field_199017_f)) {
            this.field_199016_e.add(string);
            FallbackResourceManager fallbackResourceManager = this.field_199014_c.get(string);
            if (fallbackResourceManager == null) {
                fallbackResourceManager = new FallbackResourceManager(this.field_199017_f, string);
                this.field_199014_c.put(string, fallbackResourceManager);
            }
            fallbackResourceManager.func_199021_a(iResourcePack);
        }
    }

    @Override
    public IResource func_199002_a(ResourceLocation resourceLocation) throws IOException {
        IResourceManager iResourceManager = this.field_199014_c.get(resourceLocation.func_110624_b());
        if (iResourceManager != null) {
            return iResourceManager.func_199002_a(resourceLocation);
        }
        throw new FileNotFoundException(resourceLocation.toString());
    }

    @Override
    public List<IResource> func_199004_b(ResourceLocation resourceLocation) throws IOException {
        IResourceManager iResourceManager = this.field_199014_c.get(resourceLocation.func_110624_b());
        if (iResourceManager != null) {
            return iResourceManager.func_199004_b(resourceLocation);
        }
        throw new FileNotFoundException(resourceLocation.toString());
    }

    @Override
    public Collection<ResourceLocation> func_199003_a(String string, Predicate<String> predicate) {
        HashSet hashSet = Sets.newHashSet();
        for (FallbackResourceManager fallbackResourceManager : this.field_199014_c.values()) {
            hashSet.addAll(fallbackResourceManager.func_199003_a(string, predicate));
        }
        ArrayList \u26032 = Lists.newArrayList((Iterable)hashSet);
        Collections.sort(\u26032);
        return \u26032;
    }

    private void func_199008_b() {
        this.field_199014_c.clear();
        this.field_199016_e.clear();
        this.field_232636_f_.forEach(IResourcePack::close);
        this.field_232636_f_.clear();
    }

    @Override
    public void close() {
        this.func_199008_b();
    }

    @Override
    public void func_219534_a(IFutureReloadListener iFutureReloadListener) {
        this.field_199015_d.add(iFutureReloadListener);
        this.field_219539_d.add(iFutureReloadListener);
    }

    protected IAsyncReloader func_219538_b(Executor executor, Executor executor2, List<IFutureReloadListener> list, CompletableFuture<Unit> completableFuture) {
        DebugAsyncReloader debugAsyncReloader = field_199012_a.isDebugEnabled() ? new DebugAsyncReloader(this, Lists.newArrayList(list), executor, executor2, completableFuture) : AsyncReloader.func_219562_a(this, Lists.newArrayList(list), executor, executor2, completableFuture);
        this.field_219539_d.clear();
        return debugAsyncReloader;
    }

    @Override
    public IAsyncReloader func_219537_a(Executor executor3, Executor executor2, CompletableFuture<Unit> completableFuture, List<IResourcePack> list) {
        Executor executor3;
        this.func_199008_b();
        field_199012_a.info("Reloading ResourceManager: {}", new Supplier[]{() -> list.stream().map(IResourcePack::func_195762_a).collect(Collectors.joining(", "))});
        for (IResourcePack iResourcePack : list) {
            try {
                this.func_199021_a(iResourcePack);
            }
            catch (Exception exception) {
                field_199012_a.error("Failed to add resource pack {}", (Object)iResourcePack.func_195762_a(), (Object)exception);
                return new FailedPackReloader(new FailedPackException(iResourcePack, (Throwable)exception));
            }
        }
        return this.func_219538_b(executor3, executor2, this.field_199015_d, completableFuture);
    }

    static class FailedPackReloader
    implements IAsyncReloader {
        private final FailedPackException field_230019_a_;
        private final CompletableFuture<Unit> field_230020_b_;

        public FailedPackReloader(FailedPackException failedPackException) {
            this.field_230019_a_ = failedPackException;
            this.field_230020_b_ = new CompletableFuture();
            this.field_230020_b_.completeExceptionally(failedPackException);
        }

        @Override
        public CompletableFuture<Unit> func_219552_a() {
            return this.field_230020_b_;
        }
    }

    public static class FailedPackException
    extends RuntimeException {
        private final IResourcePack field_230021_a_;

        public FailedPackException(IResourcePack iResourcePack, Throwable throwable) {
            super(iResourcePack.func_195762_a(), throwable);
            this.field_230021_a_ = iResourcePack;
        }
    }
}

