/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.Tag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public interface ITag<T> {
    public static <T> Codec<ITag<T>> func_232947_a_(Supplier<ITagCollection<T>> supplier) {
        return ResourceLocation.field_240908_a_.flatXmap(resourceLocation -> Optional.ofNullable(((ITagCollection)supplier.get()).func_199910_a((ResourceLocation)resourceLocation)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + resourceLocation))), iTag -> Optional.ofNullable(((ITagCollection)supplier.get()).func_232973_a_(iTag)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + iTag))));
    }

    public boolean func_230235_a_(T var1);

    public List<T> func_230236_b_();

    default public T func_205596_a(Random random) {
        List<T> list = this.func_230236_b_();
        return list.get(random.nextInt(list.size()));
    }

    public static <T> ITag<T> func_232946_a_(Set<T> set) {
        return Tag.func_241286_a_(set);
    }

    public static interface INamedTag<T>
    extends ITag<T> {
        public ResourceLocation func_230234_a_();
    }

    public static class OptionalTagEntry
    implements ITagEntry {
        private final ResourceLocation field_242201_a;

        public OptionalTagEntry(ResourceLocation resourceLocation) {
            this.field_242201_a = resourceLocation;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2, Consumer<T> consumer) {
            ITag<T> iTag = function.apply(this.field_242201_a);
            if (iTag != null) {
                iTag.func_230236_b_().forEach(consumer);
            }
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", "#" + this.field_242201_a);
            jsonObject.addProperty("required", Boolean.valueOf(false));
            jsonArray.add((JsonElement)jsonObject);
        }

        public String toString() {
            return "#" + this.field_242201_a + "?";
        }
    }

    public static class TagEntry
    implements ITagEntry {
        private final ResourceLocation field_200163_a;

        public TagEntry(ResourceLocation resourceLocation) {
            this.field_200163_a = resourceLocation;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2, Consumer<T> consumer) {
            ITag<T> iTag = function.apply(this.field_200163_a);
            if (iTag == null) {
                return false;
            }
            iTag.func_230236_b_().forEach(consumer);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            jsonArray.add("#" + this.field_200163_a);
        }

        public String toString() {
            return "#" + this.field_200163_a;
        }
    }

    public static class OptionalItemEntry
    implements ITagEntry {
        private final ResourceLocation field_242200_a;

        public OptionalItemEntry(ResourceLocation resourceLocation) {
            this.field_242200_a = resourceLocation;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2, Consumer<T> consumer) {
            T t = function2.apply(this.field_242200_a);
            if (t != null) {
                consumer.accept(t);
            }
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", this.field_242200_a.toString());
            jsonObject.addProperty("required", Boolean.valueOf(false));
            jsonArray.add((JsonElement)jsonObject);
        }

        public String toString() {
            return this.field_242200_a.toString() + "?";
        }
    }

    public static class ItemEntry
    implements ITagEntry {
        private final ResourceLocation field_232969_a_;

        public ItemEntry(ResourceLocation resourceLocation) {
            this.field_232969_a_ = resourceLocation;
        }

        @Override
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2, Consumer<T> consumer) {
            T t = function2.apply(this.field_232969_a_);
            if (t == null) {
                return false;
            }
            consumer.accept(t);
            return true;
        }

        @Override
        public void func_230237_a_(JsonArray jsonArray) {
            jsonArray.add(this.field_232969_a_.toString());
        }

        public String toString() {
            return this.field_232969_a_.toString();
        }
    }

    public static interface ITagEntry {
        public <T> boolean func_230238_a_(Function<ResourceLocation, ITag<T>> var1, Function<ResourceLocation, T> var2, Consumer<T> var3);

        public void func_230237_a_(JsonArray var1);
    }

    public static class Builder {
        private final List<Proxy> field_232953_a_ = Lists.newArrayList();

        public static Builder func_200047_a() {
            return new Builder();
        }

        public Builder func_232954_a_(Proxy proxy) {
            this.field_232953_a_.add(proxy);
            return this;
        }

        public Builder func_232955_a_(ITagEntry iTagEntry, String string) {
            return this.func_232954_a_(new Proxy(iTagEntry, string));
        }

        public Builder func_232961_a_(ResourceLocation resourceLocation, String string) {
            return this.func_232955_a_(new ItemEntry(resourceLocation), string);
        }

        public Builder func_232964_b_(ResourceLocation resourceLocation, String string) {
            return this.func_232955_a_(new TagEntry(resourceLocation), string);
        }

        public <T> Optional<ITag<T>> func_232959_a_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Proxy proxy : this.field_232953_a_) {
                if (proxy.func_232968_a_().func_230238_a_(function, function2, arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0))) continue;
                return Optional.empty();
            }
            return Optional.of(ITag.func_232946_a_(builder.build()));
        }

        public Stream<Proxy> func_232962_b_() {
            return this.field_232953_a_.stream();
        }

        public <T> Stream<Proxy> func_232963_b_(Function<ResourceLocation, ITag<T>> function, Function<ResourceLocation, T> function2) {
            return this.func_232962_b_().filter(proxy -> !proxy.func_232968_a_().func_230238_a_(function, function2, object -> {}));
        }

        public Builder func_232956_a_(JsonObject jsonObject2, String string) {
            JsonObject jsonObject2;
            JsonArray jsonArray = JSONUtils.func_151214_t(jsonObject2, "values");
            ArrayList \u26032 = Lists.newArrayList();
            for (JsonElement jsonElement : jsonArray) {
                \u26032.add(Builder.func_242199_a(jsonElement));
            }
            if (JSONUtils.func_151209_a(jsonObject2, "replace", false)) {
                this.field_232953_a_.clear();
            }
            \u26032.forEach(iTagEntry -> this.field_232953_a_.add(new Proxy((ITagEntry)iTagEntry, string)));
            return this;
        }

        private static ITagEntry func_242199_a(JsonElement jsonElement) {
            boolean \u26033;
            String \u26032;
            if (jsonElement.isJsonObject()) {
                Object object = jsonElement.getAsJsonObject();
                \u26032 = JSONUtils.func_151200_h(object, "id");
                \u26033 = JSONUtils.func_151209_a(object, "required", true);
            } else {
                \u26032 = JSONUtils.func_151206_a(jsonElement, "id");
                \u26033 = true;
            }
            if (\u26032.startsWith("#")) {
                object = new ResourceLocation(\u26032.substring(1));
                return \u26033 ? new TagEntry((ResourceLocation)object) : new OptionalTagEntry((ResourceLocation)object);
            }
            object = new ResourceLocation(\u26032);
            return \u26033 ? new ItemEntry((ResourceLocation)object) : new OptionalItemEntry((ResourceLocation)object);
        }

        public JsonObject func_232965_c_() {
            JsonObject jsonObject = new JsonObject();
            JsonArray \u26032 = new JsonArray();
            for (Proxy proxy : this.field_232953_a_) {
                proxy.func_232968_a_().func_230237_a_(\u26032);
            }
            jsonObject.addProperty("replace", Boolean.valueOf(false));
            jsonObject.add("values", (JsonElement)\u26032);
            return jsonObject;
        }
    }

    public static class Proxy {
        private final ITagEntry field_232966_a_;
        private final String field_232967_b_;

        private Proxy(ITagEntry iTagEntry, String string) {
            this.field_232966_a_ = iTagEntry;
            this.field_232967_b_ = string;
        }

        public ITagEntry func_232968_a_() {
            return this.field_232966_a_;
        }

        public String toString() {
            return this.field_232966_a_.toString() + " (from " + this.field_232967_b_ + ")";
        }
    }
}

