/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicLike;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.datafix.TypeReferences;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenSettings
extends DataFix {
    private static final ImmutableMap<String, StructureSeparationSettingsCodec> field_233422_a_ = ImmutableMap.builder().put((Object)"minecraft:village", (Object)new StructureSeparationSettingsCodec(32, 8, 10387312)).put((Object)"minecraft:desert_pyramid", (Object)new StructureSeparationSettingsCodec(32, 8, 14357617)).put((Object)"minecraft:igloo", (Object)new StructureSeparationSettingsCodec(32, 8, 14357618)).put((Object)"minecraft:jungle_pyramid", (Object)new StructureSeparationSettingsCodec(32, 8, 14357619)).put((Object)"minecraft:swamp_hut", (Object)new StructureSeparationSettingsCodec(32, 8, 14357620)).put((Object)"minecraft:pillager_outpost", (Object)new StructureSeparationSettingsCodec(32, 8, 165745296)).put((Object)"minecraft:monument", (Object)new StructureSeparationSettingsCodec(32, 5, 10387313)).put((Object)"minecraft:endcity", (Object)new StructureSeparationSettingsCodec(20, 11, 10387313)).put((Object)"minecraft:mansion", (Object)new StructureSeparationSettingsCodec(80, 20, 10387319)).build();

    public WorldGenSettings(Schema schema) {
        super(schema, true);
    }

    protected TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("WorldGenSettings building", this.getInputSchema().getType(TypeReferences.field_233375_y_), typed -> typed.update(DSL.remainderFinder(), WorldGenSettings::func_233426_a_));
    }

    private static <T> Dynamic<T> func_233423_a_(long l, DynamicLike<T> dynamicLike, Dynamic<T> dynamic, Dynamic<T> dynamic2) {
        return dynamicLike.createMap((Map)ImmutableMap.of((Object)dynamicLike.createString("type"), (Object)dynamicLike.createString("minecraft:noise"), (Object)dynamicLike.createString("biome_source"), dynamic2, (Object)dynamicLike.createString("seed"), (Object)dynamicLike.createLong(l), (Object)dynamicLike.createString("settings"), dynamic));
    }

    private static <T> Dynamic<T> func_233427_a_(Dynamic<T> dynamic, long l, boolean bl, boolean bl2) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)dynamic.createString("type"), (Object)dynamic.createString("minecraft:vanilla_layered")).put((Object)dynamic.createString("seed"), (Object)dynamic.createLong(l)).put((Object)dynamic.createString("large_biomes"), (Object)dynamic.createBoolean(bl2));
        if (bl) {
            builder.put((Object)dynamic.createString("legacy_biome_init_layer"), (Object)dynamic.createBoolean(bl));
        }
        return dynamic.createMap((Map)builder.build());
    }

    private static <T> Dynamic<T> func_233426_a_(Dynamic<T> dynamic22) {
        OptionalDynamic \u26036;
        Dynamic dynamic22;
        Dynamic<T> \u260313;
        DynamicOps dynamicOps = dynamic22.getOps();
        long \u26032 = dynamic22.get("RandomSeed").asLong(0L);
        Optional \u26033 = dynamic22.get("generatorName").asString().map(string -> string.toLowerCase(Locale.ROOT)).result();
        Optional \u26034 = dynamic22.get("legacy_custom_options").asString().result().map(Optional::of).orElseGet(() -> {
            if (\u26033.equals(Optional.of("customized"))) {
                return dynamic22.get("generatorOptions").asString().result();
            }
            return Optional.empty();
        });
        boolean \u26035 = false;
        if (\u26033.equals(Optional.of("customized"))) {
            \u260313 = WorldGenSettings.func_241322_a_(dynamic22, \u26032);
        } else if (!\u26033.isPresent()) {
            \u260313 = WorldGenSettings.func_241322_a_(dynamic22, \u26032);
        } else {
            switch ((String)\u26033.get()) {
                case "flat": {
                    \u26036 = dynamic22.get("generatorOptions");
                    Map<Dynamic<T>, Dynamic<T>> \u26037 = WorldGenSettings.func_233430_a_(dynamicOps, \u26036);
                    \u260313 = dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("type"), (Object)dynamic22.createString("minecraft:flat"), (Object)dynamic22.createString("settings"), (Object)dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("structures"), (Object)dynamic22.createMap(\u26037), (Object)dynamic22.createString("layers"), (Object)\u26036.get("layers").result().orElseGet(() -> dynamic22.createList(Stream.of(dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("height"), (Object)dynamic22.createInt(1), (Object)dynamic22.createString("block"), (Object)dynamic22.createString("minecraft:bedrock"))), dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("height"), (Object)dynamic22.createInt(2), (Object)dynamic22.createString("block"), (Object)dynamic22.createString("minecraft:dirt"))), dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("height"), (Object)dynamic22.createInt(1), (Object)dynamic22.createString("block"), (Object)dynamic22.createString("minecraft:grass_block")))))), (Object)dynamic22.createString("biome"), (Object)dynamic22.createString(\u26036.get("biome").asString("minecraft:plains"))))));
                    break;
                }
                case "debug_all_block_states": {
                    \u260313 = dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("type"), (Object)dynamic22.createString("minecraft:debug")));
                    break;
                }
                case "buffet": {
                    Dynamic \u260312;
                    Dynamic \u260311;
                    OptionalDynamic \u26038 = dynamic22.get("generatorOptions");
                    OptionalDynamic \u26039 = \u26038.get("chunk_generator");
                    Optional \u260310 = \u26039.get("type").asString().result();
                    if (Objects.equals(\u260310, Optional.of("minecraft:caves"))) {
                        \u260311 = dynamic22.createString("minecraft:caves");
                        \u26035 = true;
                    } else {
                        \u260311 = Objects.equals(\u260310, Optional.of("minecraft:floating_islands")) ? dynamic22.createString("minecraft:floating_islands") : dynamic22.createString("minecraft:overworld");
                    }
                    Dynamic dynamic3 = \u26038.get("biome_source").result().orElseGet(() -> dynamic22.createMap((Map)ImmutableMap.of((Object)dynamic22.createString("type"), (Object)dynamic22.createString("minecraft:fixed"))));
                    if (dynamic3.get("type").asString().result().equals(Optional.of("minecraft:fixed"))) {
                        String string2 = dynamic3.get("options").get("biomes").asStream().findFirst().flatMap(dynamic -> dynamic.asString().result()).orElse("minecraft:ocean");
                        \u260312 = dynamic3.remove("options").set("biome", dynamic22.createString(string2));
                    } else {
                        \u260312 = dynamic3;
                    }
                    \u260313 = WorldGenSettings.func_233423_a_(\u26032, dynamic22, \u260311, \u260312);
                    break;
                }
                default: {
                    boolean bl = ((String)\u26033.get()).equals("default");
                    \u2603 = ((String)\u26033.get()).equals("default_1_1") || bl && dynamic22.get("generatorVersion").asInt(0) == 0;
                    \u2603 = ((String)\u26033.get()).equals("amplified");
                    \u2603 = ((String)\u26033.get()).equals("largebiomes");
                    \u260313 = WorldGenSettings.func_233423_a_(\u26032, dynamic22, dynamic22.createString(\u2603 ? "minecraft:amplified" : "minecraft:overworld"), WorldGenSettings.func_233427_a_(dynamic22, \u26032, \u2603, \u2603));
                }
            }
        }
        \u2603 = dynamic22.get("MapFeatures").asBoolean(true);
        \u2603 = dynamic22.get("BonusChest").asBoolean(false);
        \u26036 = ImmutableMap.builder();
        \u26036.put(dynamicOps.createString("seed"), dynamicOps.createLong(\u26032));
        \u26036.put(dynamicOps.createString("generate_features"), dynamicOps.createBoolean(\u2603));
        \u26036.put(dynamicOps.createString("bonus_chest"), dynamicOps.createBoolean(\u2603));
        \u26036.put(dynamicOps.createString("dimensions"), WorldGenSettings.func_241323_a_(dynamic22, \u26032, \u260313, \u26035));
        \u26034.ifPresent(arg_0 -> WorldGenSettings.func_233424_a_((ImmutableMap.Builder)\u26036, dynamicOps, arg_0));
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)\u26036.build()));
    }

    protected static <T> Dynamic<T> func_241322_a_(Dynamic<T> dynamic, long l) {
        return WorldGenSettings.func_233423_a_(l, dynamic, dynamic.createString("minecraft:overworld"), WorldGenSettings.func_233427_a_(dynamic, l, false, false));
    }

    protected static <T> T func_241323_a_(Dynamic<T> dynamic, long l, Dynamic<T> dynamic2, boolean bl) {
        DynamicOps dynamicOps = dynamic.getOps();
        return (T)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("minecraft:overworld"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:overworld" + (bl ? "_caves" : "")), (Object)dynamicOps.createString("generator"), (Object)dynamic2.getValue())), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_nether"), (Object)dynamicOps.createString("generator"), (Object)WorldGenSettings.func_233423_a_(l, dynamic, dynamic.createString("minecraft:nether"), dynamic.createMap((Map)ImmutableMap.of((Object)dynamic.createString("type"), (Object)dynamic.createString("minecraft:multi_noise"), (Object)dynamic.createString("seed"), (Object)dynamic.createLong(l), (Object)dynamic.createString("preset"), (Object)dynamic.createString("minecraft:nether")))).getValue())), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("type"), (Object)dynamicOps.createString("minecraft:the_end"), (Object)dynamicOps.createString("generator"), (Object)WorldGenSettings.func_233423_a_(l, dynamic, dynamic.createString("minecraft:end"), dynamic.createMap((Map)ImmutableMap.of((Object)dynamic.createString("type"), (Object)dynamic.createString("minecraft:the_end"), (Object)dynamic.createString("seed"), (Object)dynamic.createLong(l)))).getValue()))));
    }

    private static <T> Map<Dynamic<T>, Dynamic<T>> func_233430_a_(DynamicOps<T> dynamicOps, OptionalDynamic<T> optionalDynamic) {
        MutableInt mutableInt = new MutableInt(32);
        \u2603 = new MutableInt(3);
        \u2603 = new MutableInt(128);
        MutableBoolean \u26032 = new MutableBoolean(false);
        HashMap \u26033 = Maps.newHashMap();
        if (!optionalDynamic.result().isPresent()) {
            \u26032.setTrue();
            \u26033.put("minecraft:village", field_233422_a_.get((Object)"minecraft:village"));
        }
        optionalDynamic.get("structures").flatMap(Dynamic::getMapValues).result().ifPresent(map2 -> map2.forEach((dynamic, dynamic2) -> dynamic2.getMapValues().result().ifPresent(map2 -> map2.forEach((dynamic2, dynamic3) -> {
            String string = dynamic.asString("");
            \u2603 = dynamic2.asString("");
            \u2603 = dynamic3.asString("");
            if ("stronghold".equals(string)) {
                \u26032.setTrue();
                switch (\u2603) {
                    case "distance": {
                        mutableInt.setValue(WorldGenSettings.func_233435_a_(\u2603, mutableInt.getValue(), 1));
                        return;
                    }
                    case "spread": {
                        \u2603.setValue(WorldGenSettings.func_233435_a_(\u2603, \u2603.getValue(), 1));
                        return;
                    }
                    case "count": {
                        \u2603.setValue(WorldGenSettings.func_233435_a_(\u2603, \u2603.getValue(), 1));
                        return;
                    }
                }
                return;
            }
            switch (\u2603) {
                case "distance": {
                    switch (string) {
                        case "village": {
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:village", \u2603, 9);
                            return;
                        }
                        case "biome_1": {
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:desert_pyramid", \u2603, 9);
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:igloo", \u2603, 9);
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:jungle_pyramid", \u2603, 9);
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:swamp_hut", \u2603, 9);
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:pillager_outpost", \u2603, 9);
                            return;
                        }
                        case "endcity": {
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:endcity", \u2603, 1);
                            return;
                        }
                        case "mansion": {
                            WorldGenSettings.func_233436_a_(\u26033, "minecraft:mansion", \u2603, 1);
                            return;
                        }
                    }
                    return;
                }
                case "separation": {
                    if ("oceanmonument".equals(string)) {
                        StructureSeparationSettingsCodec structureSeparationSettingsCodec = (StructureSeparationSettingsCodec)\u26033.getOrDefault("minecraft:monument", field_233422_a_.get((Object)"minecraft:monument"));
                        int \u26032 = WorldGenSettings.func_233435_a_(\u2603, structureSeparationSettingsCodec.field_233444_c_, 1);
                        \u26033.put("minecraft:monument", new StructureSeparationSettingsCodec(\u26032, structureSeparationSettingsCodec.field_233444_c_, structureSeparationSettingsCodec.field_233445_d_));
                    }
                    return;
                }
                case "spacing": {
                    if ("oceanmonument".equals(string)) {
                        WorldGenSettings.func_233436_a_(\u26033, "minecraft:monument", \u2603, 1);
                    }
                    return;
                }
            }
        }))));
        ImmutableMap.Builder \u26034 = ImmutableMap.builder();
        \u26034.put((Object)optionalDynamic.createString("structures"), (Object)optionalDynamic.createMap(\u26033.entrySet().stream().collect(Collectors.toMap(entry -> optionalDynamic.createString((String)entry.getKey()), entry -> ((StructureSeparationSettingsCodec)entry.getValue()).func_233447_a_(dynamicOps)))));
        if (\u26032.isTrue()) {
            \u26034.put((Object)optionalDynamic.createString("stronghold"), (Object)optionalDynamic.createMap((Map)ImmutableMap.of((Object)optionalDynamic.createString("distance"), (Object)optionalDynamic.createInt(mutableInt.getValue().intValue()), (Object)optionalDynamic.createString("spread"), (Object)optionalDynamic.createInt(\u2603.getValue().intValue()), (Object)optionalDynamic.createString("count"), (Object)optionalDynamic.createInt(\u2603.getValue().intValue()))));
        }
        return \u26034.build();
    }

    private static int func_233434_a_(String string, int n) {
        return NumberUtils.toInt((String)string, (int)n);
    }

    private static int func_233435_a_(String string, int n, int n2) {
        return Math.max(n2, WorldGenSettings.func_233434_a_(string, n));
    }

    private static void func_233436_a_(Map<String, StructureSeparationSettingsCodec> map, String string, String string2, int n) {
        StructureSeparationSettingsCodec structureSeparationSettingsCodec = map.getOrDefault(string, (StructureSeparationSettingsCodec)field_233422_a_.get((Object)string));
        int \u26032 = WorldGenSettings.func_233435_a_(string2, structureSeparationSettingsCodec.field_233443_b_, n);
        map.put(string, new StructureSeparationSettingsCodec(\u26032, structureSeparationSettingsCodec.field_233444_c_, structureSeparationSettingsCodec.field_233445_d_));
    }

    private static /* synthetic */ void func_233424_a_(ImmutableMap.Builder builder, DynamicOps dynamicOps, String string) {
        builder.put(dynamicOps.createString("legacy_custom_options"), dynamicOps.createString(string));
    }

    static final class StructureSeparationSettingsCodec {
        public static final Codec<StructureSeparationSettingsCodec> field_233442_a_ = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("spacing").forGetter(structureSeparationSettingsCodec -> structureSeparationSettingsCodec.field_233443_b_), (App)Codec.INT.fieldOf("separation").forGetter(structureSeparationSettingsCodec -> structureSeparationSettingsCodec.field_233444_c_), (App)Codec.INT.fieldOf("salt").forGetter(structureSeparationSettingsCodec -> structureSeparationSettingsCodec.field_233445_d_)).apply((Applicative)instance, StructureSeparationSettingsCodec::new));
        private final int field_233443_b_;
        private final int field_233444_c_;
        private final int field_233445_d_;

        public StructureSeparationSettingsCodec(int n, int n2, int n3) {
            this.field_233443_b_ = n;
            this.field_233444_c_ = n2;
            this.field_233445_d_ = n3;
        }

        public <T> Dynamic<T> func_233447_a_(DynamicOps<T> dynamicOps) {
            return new Dynamic(dynamicOps, field_233442_a_.encodeStart(dynamicOps, (Object)this).result().orElse(dynamicOps.emptyMap()));
        }
    }
}

