/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class BlockPos
extends Vector3i {
    public static final Codec<BlockPos> field_239578_a_ = Codec.INT_STREAM.comapFlatMap(intStream -> Util.func_240987_a_(intStream, 3).map(nArray -> new BlockPos(nArray[0], nArray[1], nArray[2])), blockPos -> IntStream.of(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p())).stable();
    private static final Logger field_185335_c = LogManager.getLogger();
    public static final BlockPos field_177992_a = new BlockPos(0, 0, 0);
    private static final int field_177990_b;
    private static final int field_177991_c;
    private static final int field_177989_d;
    private static final long field_177994_h;
    private static final long field_177995_i;
    private static final long field_177993_j;
    private static final int field_218292_j;
    private static final int field_218293_k;

    public BlockPos(int n, int n2, int n3) {
        super(n, n2, n3);
    }

    public BlockPos(double d, double d2, double d3) {
        super(d, d2, d3);
    }

    public BlockPos(Vector3d vector3d) {
        this(vector3d.field_72450_a, vector3d.field_72448_b, vector3d.field_72449_c);
    }

    public BlockPos(IPosition iPosition) {
        this(iPosition.func_82615_a(), iPosition.func_82617_b(), iPosition.func_82616_c());
    }

    public BlockPos(Vector3i vector3i) {
        this(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p());
    }

    public static long func_218289_a(long l, Direction direction) {
        return BlockPos.func_218291_a(l, direction.func_82601_c(), direction.func_96559_d(), direction.func_82599_e());
    }

    public static long func_218291_a(long l, int n, int n2, int n3) {
        return BlockPos.func_218276_a(BlockPos.func_218290_b(l) + n, BlockPos.func_218274_c(l) + n2, BlockPos.func_218282_d(l) + n3);
    }

    public static int func_218290_b(long l) {
        return (int)(l << 64 - field_218293_k - field_177990_b >> 64 - field_177990_b);
    }

    public static int func_218274_c(long l) {
        return (int)(l << 64 - field_177989_d >> 64 - field_177989_d);
    }

    public static int func_218282_d(long l) {
        return (int)(l << 64 - field_218292_j - field_177991_c >> 64 - field_177991_c);
    }

    public static BlockPos func_218283_e(long l) {
        return new BlockPos(BlockPos.func_218290_b(l), BlockPos.func_218274_c(l), BlockPos.func_218282_d(l));
    }

    public long func_218275_a() {
        return BlockPos.func_218276_a(this.func_177958_n(), this.func_177956_o(), this.func_177952_p());
    }

    public static long func_218276_a(int n, int n2, int n3) {
        long l = 0L;
        l |= ((long)n & field_177994_h) << field_218293_k;
        l |= ((long)n2 & field_177995_i) << 0;
        return l |= ((long)n3 & field_177993_j) << field_218292_j;
    }

    public static long func_218288_f(long l) {
        return l & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPos func_177963_a(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return this;
        }
        return new BlockPos((double)this.func_177958_n() + d, (double)this.func_177956_o() + d2, (double)this.func_177952_p() + d3);
    }

    public BlockPos func_177982_a(int n, int n2, int n3) {
        if (n == 0 && n2 == 0 && n3 == 0) {
            return this;
        }
        return new BlockPos(this.func_177958_n() + n, this.func_177956_o() + n2, this.func_177952_p() + n3);
    }

    public BlockPos func_177971_a(Vector3i vector3i) {
        return this.func_177982_a(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p());
    }

    public BlockPos func_177973_b(Vector3i vector3i) {
        return this.func_177982_a(-vector3i.func_177958_n(), -vector3i.func_177956_o(), -vector3i.func_177952_p());
    }

    @Override
    public BlockPos func_177984_a() {
        return this.func_177972_a(Direction.UP);
    }

    @Override
    public BlockPos func_177981_b(int n) {
        return this.func_177967_a(Direction.UP, n);
    }

    @Override
    public BlockPos func_177977_b() {
        return this.func_177972_a(Direction.DOWN);
    }

    @Override
    public BlockPos func_177979_c(int n) {
        return this.func_177967_a(Direction.DOWN, n);
    }

    public BlockPos func_177978_c() {
        return this.func_177972_a(Direction.NORTH);
    }

    public BlockPos func_177964_d(int n) {
        return this.func_177967_a(Direction.NORTH, n);
    }

    public BlockPos func_177968_d() {
        return this.func_177972_a(Direction.SOUTH);
    }

    public BlockPos func_177970_e(int n) {
        return this.func_177967_a(Direction.SOUTH, n);
    }

    public BlockPos func_177976_e() {
        return this.func_177972_a(Direction.WEST);
    }

    public BlockPos func_177985_f(int n) {
        return this.func_177967_a(Direction.WEST, n);
    }

    public BlockPos func_177974_f() {
        return this.func_177972_a(Direction.EAST);
    }

    public BlockPos func_177965_g(int n) {
        return this.func_177967_a(Direction.EAST, n);
    }

    public BlockPos func_177972_a(Direction direction) {
        return new BlockPos(this.func_177958_n() + direction.func_82601_c(), this.func_177956_o() + direction.func_96559_d(), this.func_177952_p() + direction.func_82599_e());
    }

    @Override
    public BlockPos func_177967_a(Direction direction, int n) {
        if (n == 0) {
            return this;
        }
        return new BlockPos(this.func_177958_n() + direction.func_82601_c() * n, this.func_177956_o() + direction.func_96559_d() * n, this.func_177952_p() + direction.func_82599_e() * n);
    }

    public BlockPos func_241872_a(Direction.Axis axis, int n) {
        if (n == 0) {
            return this;
        }
        \u2603 = axis == Direction.Axis.X ? n : 0;
        \u2603 = axis == Direction.Axis.Y ? n : 0;
        \u2603 = axis == Direction.Axis.Z ? n : 0;
        return new BlockPos(this.func_177958_n() + \u2603, this.func_177956_o() + \u2603, this.func_177952_p() + \u2603);
    }

    public BlockPos func_190942_a(Rotation rotation) {
        switch (rotation) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.func_177952_p(), this.func_177956_o(), this.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.func_177958_n(), this.func_177956_o(), -this.func_177952_p());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.func_177952_p(), this.func_177956_o(), -this.func_177958_n());
    }

    @Override
    public BlockPos func_177955_d(Vector3i vector3i) {
        return new BlockPos(this.func_177956_o() * vector3i.func_177952_p() - this.func_177952_p() * vector3i.func_177956_o(), this.func_177952_p() * vector3i.func_177958_n() - this.func_177958_n() * vector3i.func_177952_p(), this.func_177958_n() * vector3i.func_177956_o() - this.func_177956_o() * vector3i.func_177958_n());
    }

    public BlockPos func_185334_h() {
        return this;
    }

    public Mutable func_239590_i_() {
        return new Mutable(this.func_177958_n(), this.func_177956_o(), this.func_177952_p());
    }

    public static Iterable<BlockPos> func_239585_a_(final Random random, final int n, final int n2, final int n3, final int n4, int n5, int n6, int n7) {
        \u2603 = n5 - n2 + 1;
        \u2603 = n6 - n3 + 1;
        \u2603 = n7 - n4 + 1;
        return () -> new AbstractIterator<BlockPos>(){
            final Mutable field_218297_b = new Mutable();
            int field_239591_b_ = n;

            protected BlockPos computeNext() {
                if (this.field_239591_b_ <= 0) {
                    return (BlockPos)this.endOfData();
                }
                Mutable mutable = this.field_218297_b.func_181079_c(n2 + random.nextInt(\u2603), n3 + random.nextInt(\u2603), n4 + random.nextInt(\u2603));
                --this.field_239591_b_;
                return mutable;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<BlockPos> func_239583_a_(BlockPos blockPos, final int n, final int n2, final int n3) {
        \u2603 = n + n2 + n3;
        \u2603 = blockPos.func_177958_n();
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable field_218298_a = new Mutable();
            private int field_239604_i_;
            private int field_239605_j_;
            private int field_239606_k_;
            private int field_239607_l_;
            private int field_239608_m_;
            private boolean field_239609_n_;

            protected BlockPos computeNext() {
                if (this.field_239609_n_) {
                    this.field_239609_n_ = false;
                    this.field_218298_a.func_223472_q(\u2603 - (this.field_218298_a.func_177952_p() - \u2603));
                    return this.field_218298_a;
                }
                Mutable mutable = null;
                while (mutable == null) {
                    if (this.field_239608_m_ > this.field_239606_k_) {
                        ++this.field_239607_l_;
                        if (this.field_239607_l_ > this.field_239605_j_) {
                            ++this.field_239604_i_;
                            if (this.field_239604_i_ > \u2603) {
                                return (BlockPos)this.endOfData();
                            }
                            this.field_239605_j_ = Math.min(n, this.field_239604_i_);
                            this.field_239607_l_ = -this.field_239605_j_;
                        }
                        this.field_239606_k_ = Math.min(n2, this.field_239604_i_ - Math.abs(this.field_239607_l_));
                        this.field_239608_m_ = -this.field_239606_k_;
                    }
                    int n4 = this.field_239607_l_;
                    \u2603 = this.field_239608_m_;
                    \u2603 = this.field_239604_i_ - Math.abs(n4) - Math.abs(\u2603);
                    if (\u2603 <= n3) {
                        this.field_239609_n_ = \u2603 != 0;
                        mutable = this.field_218298_a.func_181079_c(\u2603 + n4, \u2603 + \u2603, \u2603 + \u2603);
                    }
                    ++this.field_239608_m_;
                }
                return mutable;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Optional<BlockPos> func_239584_a_(BlockPos blockPos, int n, int n2, Predicate<BlockPos> predicate) {
        return BlockPos.func_239588_b_(blockPos, n, n2, n).filter(predicate).findFirst();
    }

    public static Stream<BlockPos> func_239588_b_(BlockPos blockPos, int n, int n2, int n3) {
        return StreamSupport.stream(BlockPos.func_239583_a_(blockPos, n, n2, n3).spliterator(), false);
    }

    public static Iterable<BlockPos> func_218278_a(BlockPos blockPos, BlockPos blockPos2) {
        return BlockPos.func_191531_b(Math.min(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.min(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.min(blockPos.func_177952_p(), blockPos2.func_177952_p()), Math.max(blockPos.func_177958_n(), blockPos2.func_177958_n()), Math.max(blockPos.func_177956_o(), blockPos2.func_177956_o()), Math.max(blockPos.func_177952_p(), blockPos2.func_177952_p()));
    }

    public static Stream<BlockPos> func_218281_b(BlockPos blockPos, BlockPos blockPos2) {
        return StreamSupport.stream(BlockPos.func_218278_a(blockPos, blockPos2).spliterator(), false);
    }

    public static Stream<BlockPos> func_229383_a_(MutableBoundingBox mutableBoundingBox) {
        return BlockPos.func_218287_a(Math.min(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78893_d), Math.min(mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78894_e), Math.min(mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78892_f), Math.max(mutableBoundingBox.field_78897_a, mutableBoundingBox.field_78893_d), Math.max(mutableBoundingBox.field_78895_b, mutableBoundingBox.field_78894_e), Math.max(mutableBoundingBox.field_78896_c, mutableBoundingBox.field_78892_f));
    }

    public static Stream<BlockPos> func_239581_a_(AxisAlignedBB axisAlignedBB) {
        return BlockPos.func_218287_a(MathHelper.func_76128_c(axisAlignedBB.field_72340_a), MathHelper.func_76128_c(axisAlignedBB.field_72338_b), MathHelper.func_76128_c(axisAlignedBB.field_72339_c), MathHelper.func_76128_c(axisAlignedBB.field_72336_d), MathHelper.func_76128_c(axisAlignedBB.field_72337_e), MathHelper.func_76128_c(axisAlignedBB.field_72334_f));
    }

    public static Stream<BlockPos> func_218287_a(int n, int n2, int n3, int n4, int n5, int n6) {
        return StreamSupport.stream(BlockPos.func_191531_b(n, n2, n3, n4, n5, n6).spliterator(), false);
    }

    public static Iterable<BlockPos> func_191531_b(final int n, final int n2, final int n3, int n4, int n5, int n6) {
        \u2603 = n4 - n + 1;
        \u2603 = n5 - n2 + 1;
        \u2603 = n6 - n3 + 1;
        \u2603 = \u2603 * \u2603 * \u2603;
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable field_239616_g_ = new Mutable();
            private int field_239617_h_;

            protected BlockPos computeNext() {
                if (this.field_239617_h_ == \u2603) {
                    return (BlockPos)this.endOfData();
                }
                int n4 = this.field_239617_h_ % \u2603;
                \u2603 = this.field_239617_h_ / \u2603;
                \u2603 = \u2603 % \u2603;
                \u2603 = \u2603 / \u2603;
                ++this.field_239617_h_;
                return this.field_239616_g_.func_181079_c(n + n4, n2 + \u2603, n3 + \u2603);
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    public static Iterable<Mutable> func_243514_a(final BlockPos blockPos, final int n, final Direction direction, final Direction direction2) {
        Validate.validState((direction.func_176740_k() != direction2.func_176740_k() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<Mutable>(){
            private final Direction[] field_243520_e;
            private final Mutable field_243521_f;
            private final int field_243522_g;
            private int field_243523_h;
            private int field_243524_i;
            private int field_243525_j;
            private int field_243526_k;
            private int field_243527_l;
            private int field_243528_m;
            {
                this.field_243520_e = new Direction[]{direction, direction2, direction.func_176734_d(), direction2.func_176734_d()};
                this.field_243521_f = blockPos.func_239590_i_().func_189536_c(direction2);
                this.field_243522_g = 4 * n;
                this.field_243523_h = -1;
                this.field_243526_k = this.field_243521_f.func_177958_n();
                this.field_243527_l = this.field_243521_f.func_177956_o();
                this.field_243528_m = this.field_243521_f.func_177952_p();
            }

            protected Mutable computeNext() {
                this.field_243521_f.func_181079_c(this.field_243526_k, this.field_243527_l, this.field_243528_m).func_189536_c(this.field_243520_e[(this.field_243523_h + 4) % 4]);
                this.field_243526_k = this.field_243521_f.func_177958_n();
                this.field_243527_l = this.field_243521_f.func_177956_o();
                this.field_243528_m = this.field_243521_f.func_177952_p();
                if (this.field_243525_j >= this.field_243524_i) {
                    if (this.field_243523_h >= this.field_243522_g) {
                        return (Mutable)this.endOfData();
                    }
                    ++this.field_243523_h;
                    this.field_243525_j = 0;
                    this.field_243524_i = this.field_243523_h / 2 + 1;
                }
                ++this.field_243525_j;
                return this.field_243521_f;
            }

            protected /* synthetic */ Object computeNext() {
                return this.computeNext();
            }
        };
    }

    @Override
    public /* synthetic */ Vector3i func_177955_d(Vector3i vector3i) {
        return this.func_177955_d(vector3i);
    }

    @Override
    public /* synthetic */ Vector3i func_177967_a(Direction direction, int n) {
        return this.func_177967_a(direction, n);
    }

    @Override
    public /* synthetic */ Vector3i func_177979_c(int n) {
        return this.func_177979_c(n);
    }

    @Override
    public /* synthetic */ Vector3i func_177977_b() {
        return this.func_177977_b();
    }

    @Override
    public /* synthetic */ Vector3i func_177981_b(int n) {
        return this.func_177981_b(n);
    }

    @Override
    public /* synthetic */ Vector3i func_177984_a() {
        return this.func_177984_a();
    }

    static {
        field_177991_c = field_177990_b = 1 + MathHelper.func_151239_c(MathHelper.func_151236_b(30000000));
        field_177989_d = 64 - field_177990_b - field_177991_c;
        field_177994_h = (1L << field_177990_b) - 1L;
        field_177995_i = (1L << field_177989_d) - 1L;
        field_177993_j = (1L << field_177991_c) - 1L;
        field_218292_j = field_177989_d;
        field_218293_k = field_177989_d + field_177991_c;
    }

    public static class Mutable
    extends BlockPos {
        public Mutable() {
            this(0, 0, 0);
        }

        public Mutable(int n, int n2, int n3) {
            super(n, n2, n3);
        }

        public Mutable(double d, double d2, double d3) {
            this(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
        }

        @Override
        public BlockPos func_177963_a(double d, double d2, double d3) {
            return super.func_177963_a(d, d2, d3).func_185334_h();
        }

        @Override
        public BlockPos func_177982_a(int n, int n2, int n3) {
            return super.func_177982_a(n, n2, n3).func_185334_h();
        }

        @Override
        public BlockPos func_177967_a(Direction direction, int n) {
            return super.func_177967_a(direction, n).func_185334_h();
        }

        @Override
        public BlockPos func_241872_a(Direction.Axis axis, int n) {
            return super.func_241872_a(axis, n).func_185334_h();
        }

        @Override
        public BlockPos func_190942_a(Rotation rotation) {
            return super.func_190942_a(rotation).func_185334_h();
        }

        public Mutable func_181079_c(int n, int n2, int n3) {
            this.func_223471_o(n);
            this.func_185336_p(n2);
            this.func_223472_q(n3);
            return this;
        }

        public Mutable func_189532_c(double d, double d2, double d3) {
            return this.func_181079_c(MathHelper.func_76128_c(d), MathHelper.func_76128_c(d2), MathHelper.func_76128_c(d3));
        }

        public Mutable func_189533_g(Vector3i vector3i) {
            return this.func_181079_c(vector3i.func_177958_n(), vector3i.func_177956_o(), vector3i.func_177952_p());
        }

        public Mutable func_218294_g(long l) {
            return this.func_181079_c(Mutable.func_218290_b(l), Mutable.func_218274_c(l), Mutable.func_218282_d(l));
        }

        public Mutable func_218295_a(AxisRotation axisRotation, int n, int n2, int n3) {
            return this.func_181079_c(axisRotation.func_197517_a(n, n2, n3, Direction.Axis.X), axisRotation.func_197517_a(n, n2, n3, Direction.Axis.Y), axisRotation.func_197517_a(n, n2, n3, Direction.Axis.Z));
        }

        public Mutable func_239622_a_(Vector3i vector3i, Direction direction) {
            return this.func_181079_c(vector3i.func_177958_n() + direction.func_82601_c(), vector3i.func_177956_o() + direction.func_96559_d(), vector3i.func_177952_p() + direction.func_82599_e());
        }

        public Mutable func_239621_a_(Vector3i vector3i, int n, int n2, int n3) {
            return this.func_181079_c(vector3i.func_177958_n() + n, vector3i.func_177956_o() + n2, vector3i.func_177952_p() + n3);
        }

        public Mutable func_189536_c(Direction direction) {
            return this.func_189534_c(direction, 1);
        }

        public Mutable func_189534_c(Direction direction, int n) {
            return this.func_181079_c(this.func_177958_n() + direction.func_82601_c() * n, this.func_177956_o() + direction.func_96559_d() * n, this.func_177952_p() + direction.func_82599_e() * n);
        }

        public Mutable func_196234_d(int n, int n2, int n3) {
            return this.func_181079_c(this.func_177958_n() + n, this.func_177956_o() + n2, this.func_177952_p() + n3);
        }

        public Mutable func_243531_h(Vector3i vector3i) {
            return this.func_181079_c(this.func_177958_n() + vector3i.func_177958_n(), this.func_177956_o() + vector3i.func_177956_o(), this.func_177952_p() + vector3i.func_177952_p());
        }

        public Mutable func_239620_a_(Direction.Axis axis, int n, int n2) {
            switch (axis) {
                case X: {
                    return this.func_181079_c(MathHelper.func_76125_a(this.func_177958_n(), n, n2), this.func_177956_o(), this.func_177952_p());
                }
                case Y: {
                    return this.func_181079_c(this.func_177958_n(), MathHelper.func_76125_a(this.func_177956_o(), n, n2), this.func_177952_p());
                }
                case Z: {
                    return this.func_181079_c(this.func_177958_n(), this.func_177956_o(), MathHelper.func_76125_a(this.func_177952_p(), n, n2));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + axis);
        }

        @Override
        public void func_223471_o(int n) {
            super.func_223471_o(n);
        }

        @Override
        public void func_185336_p(int n) {
            super.func_185336_p(n);
        }

        @Override
        public void func_223472_q(int n) {
            super.func_223472_q(n);
        }

        @Override
        public BlockPos func_185334_h() {
            return new BlockPos(this);
        }

        @Override
        public /* synthetic */ Vector3i func_177955_d(Vector3i vector3i) {
            return super.func_177955_d(vector3i);
        }

        @Override
        public /* synthetic */ Vector3i func_177967_a(Direction direction, int n) {
            return this.func_177967_a(direction, n);
        }

        @Override
        public /* synthetic */ Vector3i func_177979_c(int n) {
            return super.func_177979_c(n);
        }

        @Override
        public /* synthetic */ Vector3i func_177977_b() {
            return super.func_177977_b();
        }

        @Override
        public /* synthetic */ Vector3i func_177981_b(int n) {
            return super.func_177981_b(n);
        }

        @Override
        public /* synthetic */ Vector3i func_177984_a() {
            return super.func_177984_a();
        }
    }
}

