/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PointOfInterestData {
    private static final Logger field_218255_a = LogManager.getLogger();
    private final Short2ObjectMap<PointOfInterest> field_218256_b = new Short2ObjectOpenHashMap();
    private final Map<PointOfInterestType, Set<PointOfInterest>> field_218257_c = Maps.newHashMap();
    private final Runnable field_218258_d;
    private boolean field_218259_e;

    public static Codec<PointOfInterestData> func_234158_a_(Runnable runnable) {
        return RecordCodecBuilder.create(instance -> instance.group((App)RecordCodecBuilder.point((Object)runnable), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(pointOfInterestData -> pointOfInterestData.field_218259_e), (App)PointOfInterest.func_234150_a_(runnable).listOf().fieldOf("Records").forGetter(pointOfInterestData -> ImmutableList.copyOf((Collection)pointOfInterestData.field_218256_b.values()))).apply((Applicative)instance, PointOfInterestData::new)).orElseGet(Util.func_240982_a_("Failed to read POI section: ", arg_0 -> ((Logger)field_218255_a).error(arg_0)), () -> new PointOfInterestData(runnable, false, (List<PointOfInterest>)ImmutableList.of()));
    }

    public PointOfInterestData(Runnable runnable) {
        this(runnable, true, (List<PointOfInterest>)ImmutableList.of());
    }

    private PointOfInterestData(Runnable runnable, boolean bl, List<PointOfInterest> list) {
        this.field_218258_d = runnable;
        this.field_218259_e = bl;
        list.forEach(this::func_218254_a);
    }

    public Stream<PointOfInterest> func_218247_a(Predicate<PointOfInterestType> predicate, PointOfInterestManager.Status status) {
        return this.field_218257_c.entrySet().stream().filter(entry -> predicate.test((PointOfInterestType)entry.getKey())).flatMap(entry -> ((Set)entry.getValue()).stream()).filter(status.func_221035_a());
    }

    public void func_218243_a(BlockPos blockPos, PointOfInterestType pointOfInterestType) {
        if (this.func_218254_a(new PointOfInterest(blockPos, pointOfInterestType, this.field_218258_d))) {
            field_218255_a.debug("Added POI of type {} @ {}", new Supplier[]{() -> pointOfInterestType, () -> blockPos});
            this.field_218258_d.run();
        }
    }

    private boolean func_218254_a(PointOfInterest pointOfInterest2) {
        PointOfInterest pointOfInterest2;
        BlockPos blockPos = pointOfInterest2.func_218261_f();
        PointOfInterestType \u26032 = pointOfInterest2.func_218260_g();
        short \u26033 = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26034 = (PointOfInterest)this.field_218256_b.get(\u26033);
        if (\u26034 != null) {
            if (\u26032.equals(\u26034.func_218260_g())) {
                return false;
            }
            String string = "POI data mismatch: already registered at " + blockPos;
            if (SharedConstants.field_206244_b) {
                throw Util.func_229757_c_(new IllegalStateException(string));
            }
            field_218255_a.error(string);
        }
        this.field_218256_b.put(\u26033, (Object)pointOfInterest2);
        this.field_218257_c.computeIfAbsent(\u26032, pointOfInterestType -> Sets.newHashSet()).add(pointOfInterest2);
        return true;
    }

    public void func_218248_a(BlockPos blockPos) {
        PointOfInterest pointOfInterest = (PointOfInterest)this.field_218256_b.remove(SectionPos.func_218150_b(blockPos));
        if (pointOfInterest == null) {
            field_218255_a.error("POI data mismatch: never registered at " + blockPos);
            return;
        }
        this.field_218257_c.get(pointOfInterest.func_218260_g()).remove(pointOfInterest);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = pointOfInterest::func_218260_g;
        supplierArray[1] = pointOfInterest::func_218261_f;
        field_218255_a.debug("Removed POI of type {} @ {}", supplierArray);
        this.field_218258_d.run();
    }

    public boolean func_218251_c(BlockPos blockPos) {
        PointOfInterest pointOfInterest = (PointOfInterest)this.field_218256_b.get(SectionPos.func_218150_b(blockPos));
        if (pointOfInterest == null) {
            throw Util.func_229757_c_(new IllegalStateException("POI never registered at " + blockPos));
        }
        boolean \u26032 = pointOfInterest.func_218264_c();
        this.field_218258_d.run();
        return \u26032;
    }

    public boolean func_218245_a(BlockPos blockPos, Predicate<PointOfInterestType> predicate) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)this.field_218256_b.get(s);
        return \u26032 != null && predicate.test(\u26032.func_218260_g());
    }

    public Optional<PointOfInterestType> func_218244_d(BlockPos blockPos) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)this.field_218256_b.get(s);
        return \u26032 != null ? Optional.of(\u26032.func_218260_g()) : Optional.empty();
    }

    public void func_218240_a(Consumer<BiConsumer<BlockPos, PointOfInterestType>> consumer) {
        if (!this.field_218259_e) {
            Short2ObjectOpenHashMap short2ObjectOpenHashMap = new Short2ObjectOpenHashMap(this.field_218256_b);
            this.func_218253_a();
            consumer.accept((arg_0, arg_1) -> this.func_234157_a_((Short2ObjectMap)short2ObjectOpenHashMap, arg_0, arg_1));
            this.field_218259_e = true;
            this.field_218258_d.run();
        }
    }

    private void func_218253_a() {
        this.field_218256_b.clear();
        this.field_218257_c.clear();
    }

    boolean func_226355_a_() {
        return this.field_218259_e;
    }

    private /* synthetic */ void func_234157_a_(Short2ObjectMap short2ObjectMap, BlockPos blockPos, PointOfInterestType pointOfInterestType) {
        short s = SectionPos.func_218150_b(blockPos);
        PointOfInterest \u26032 = (PointOfInterest)short2ObjectMap.computeIfAbsent(s, n -> new PointOfInterest(blockPos, pointOfInterestType, this.field_218258_d));
        this.func_218254_a(\u26032);
    }
}

