/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.OptionalDynamic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.IOWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RegionSectionCache<R>
implements AutoCloseable {
    private static final Logger field_219120_a = LogManager.getLogger();
    private final IOWorker field_227173_b_;
    private final Long2ObjectMap<Optional<R>> field_219121_b = new Long2ObjectOpenHashMap();
    private final LongLinkedOpenHashSet field_219122_d = new LongLinkedOpenHashSet();
    private final Function<Runnable, Codec<R>> field_235988_e_;
    private final Function<Runnable, R> field_219124_f;
    private final DataFixer field_219125_g;
    private final DefaultTypeReferences field_219126_h;

    public RegionSectionCache(File file, Function<Runnable, Codec<R>> function, Function<Runnable, R> function2, DataFixer dataFixer, DefaultTypeReferences defaultTypeReferences, boolean bl) {
        this.field_235988_e_ = function;
        this.field_219124_f = function2;
        this.field_219125_g = dataFixer;
        this.field_219126_h = defaultTypeReferences;
        this.field_227173_b_ = new IOWorker(file, bl, file.getName());
    }

    protected void func_219115_a(BooleanSupplier booleanSupplier) {
        while (!this.field_219122_d.isEmpty() && booleanSupplier.getAsBoolean()) {
            ChunkPos chunkPos = SectionPos.func_218170_a(this.field_219122_d.firstLong()).func_218155_u();
            this.func_219117_c(chunkPos);
        }
    }

    @Nullable
    protected Optional<R> func_219106_c(long l) {
        return (Optional)this.field_219121_b.get(l);
    }

    protected Optional<R> func_219113_d(long l) {
        SectionPos sectionPos = SectionPos.func_218170_a(l);
        if (this.func_219114_b(sectionPos)) {
            return Optional.empty();
        }
        Optional<R> \u26032 = this.func_219106_c(l);
        if (\u26032 != null) {
            return \u26032;
        }
        this.func_219107_b(sectionPos.func_218155_u());
        \u26032 = this.func_219106_c(l);
        if (\u26032 == null) {
            throw Util.func_229757_c_(new IllegalStateException());
        }
        return \u26032;
    }

    protected boolean func_219114_b(SectionPos sectionPos) {
        return World.func_217405_b(SectionPos.func_218142_c(sectionPos.func_218163_b()));
    }

    protected R func_235995_e_(long l) {
        Optional<R> optional = this.func_219113_d(l);
        if (optional.isPresent()) {
            return optional.get();
        }
        R \u26032 = this.field_219124_f.apply(() -> this.func_219116_a(l));
        this.field_219121_b.put(l, Optional.of(\u26032));
        return \u26032;
    }

    private void func_219107_b(ChunkPos chunkPos) {
        this.func_235992_a_(chunkPos, NBTDynamicOps.field_210820_a, this.func_223138_c(chunkPos));
    }

    @Nullable
    private CompoundNBT func_223138_c(ChunkPos chunkPos) {
        try {
            return this.field_227173_b_.func_227090_a_(chunkPos);
        }
        catch (IOException iOException) {
            field_219120_a.error("Error reading chunk {} data from disk", (Object)chunkPos, (Object)iOException);
            return null;
        }
    }

    private <T> void func_235992_a_(ChunkPos chunkPos, DynamicOps<T> dynamicOps2, @Nullable T t) {
        if (t == null) {
            for (int i = 0; i < 16; ++i) {
                this.field_219121_b.put(SectionPos.func_218156_a(chunkPos, i).func_218146_v(), Optional.empty());
            }
        } else {
            DynamicOps<T> dynamicOps2;
            Dynamic \u26032 = new Dynamic(dynamicOps2, t);
            int \u26033 = RegionSectionCache.func_235993_a_(\u26032);
            boolean \u26034 = \u26033 != (\u2603 = SharedConstants.func_215069_a().getWorldVersion());
            Dynamic \u26035 = this.field_219125_g.update(this.field_219126_h.func_219816_a(), \u26032, \u26033, \u2603);
            OptionalDynamic \u26036 = \u26035.get("Sections");
            for (int i = 0; i < 16; ++i) {
                long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
                Optional \u26037 = \u26036.get(Integer.toString(i)).result().flatMap(dynamic -> this.field_235988_e_.apply(() -> this.func_219116_a(l)).parse(dynamic).resultOrPartial(arg_0 -> ((Logger)field_219120_a).error(arg_0)));
                this.field_219121_b.put(l, \u26037);
                \u26037.ifPresent(object -> {
                    this.func_219111_b(l);
                    if (\u26034) {
                        this.func_219116_a(l);
                    }
                });
            }
        }
    }

    private void func_219117_c(ChunkPos chunkPos) {
        Dynamic<INBT> dynamic = this.func_235991_a_(chunkPos, NBTDynamicOps.field_210820_a);
        INBT \u26032 = (INBT)dynamic.getValue();
        if (\u26032 instanceof CompoundNBT) {
            this.field_227173_b_.func_227093_a_(chunkPos, (CompoundNBT)\u26032);
        } else {
            field_219120_a.error("Expected compound tag, got {}", (Object)\u26032);
        }
    }

    private <T> Dynamic<T> func_235991_a_(ChunkPos chunkPos, DynamicOps<T> dynamicOps) {
        HashMap hashMap = Maps.newHashMap();
        for (int i = 0; i < 16; ++i) {
            long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
            this.field_219122_d.remove(l);
            Optional \u26032 = (Optional)this.field_219121_b.get(l);
            if (\u26032 == null || !\u26032.isPresent()) continue;
            DataResult \u26033 = this.field_235988_e_.apply(() -> this.func_219116_a(l)).encodeStart(dynamicOps, \u26032.get());
            String \u26034 = Integer.toString(i);
            \u26033.resultOrPartial(arg_0 -> ((Logger)field_219120_a).error(arg_0)).ifPresent(object -> hashMap.put(dynamicOps.createString(\u26034), object));
        }
        return new Dynamic(dynamicOps, dynamicOps.createMap((Map)ImmutableMap.of((Object)dynamicOps.createString("Sections"), (Object)dynamicOps.createMap((Map)hashMap), (Object)dynamicOps.createString("DataVersion"), (Object)dynamicOps.createInt(SharedConstants.func_215069_a().getWorldVersion()))));
    }

    protected void func_219111_b(long l) {
    }

    protected void func_219116_a(long l) {
        Optional optional = (Optional)this.field_219121_b.get(l);
        if (optional == null || !optional.isPresent()) {
            field_219120_a.warn("No data for position: {}", (Object)SectionPos.func_218170_a(l));
            return;
        }
        this.field_219122_d.add(l);
    }

    private static int func_235993_a_(Dynamic<?> dynamic) {
        return dynamic.get("DataVersion").asInt(1945);
    }

    public void func_219112_a(ChunkPos chunkPos) {
        if (!this.field_219122_d.isEmpty()) {
            for (int i = 0; i < 16; ++i) {
                long l = SectionPos.func_218156_a(chunkPos, i).func_218146_v();
                if (!this.field_219122_d.contains(l)) continue;
                this.func_219117_c(chunkPos);
                return;
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.field_227173_b_.close();
    }
}

