/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs;

import com.infamous.dungeons_mobs.capabilities.CloneableHelper;
import com.infamous.dungeons_mobs.capabilities.CloneableProvider;
import com.infamous.dungeons_mobs.capabilities.ICloneable;
import com.infamous.dungeons_mobs.entities.creepers.IcyCreeperEntity;
import com.infamous.dungeons_mobs.entities.illagers.GeomancerEntity;
import com.infamous.dungeons_mobs.entities.illagers.IllusionerCloneEntity;
import com.infamous.dungeons_mobs.entities.jungle.VineEntity;
import com.infamous.dungeons_mobs.entities.jungle.WhispererEntity;
import com.infamous.dungeons_mobs.entities.summonables.ConstructEntity;
import com.infamous.dungeons_mobs.entities.undead.FrozenZombieEntity;
import com.infamous.dungeons_mobs.goals.AvoidBaseEntityGoal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.monster.IllusionerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.SnowballEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="dungeons_mobs")
public class MobEvents {
    @SubscribeEvent
    public static void onAttachEntityCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (MobEvents.isCloneableEntity((Entity)event.getObject())) {
            event.addCapability(new ResourceLocation("dungeons_mobs", "cloneable"), (ICapabilityProvider)new CloneableProvider());
        }
    }

    private static boolean isCloneableEntity(Entity object) {
        return object instanceof IllusionerEntity;
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        ICloneable cloneable;
        LivingEntity caster;
        IllusionerCloneEntity illusionerCloneEntity;
        CreatureEntity creatureEntity;
        if (event.getEntity() instanceof CreatureEntity && !(event.getEntity() instanceof GeomancerEntity)) {
            creatureEntity = (CreatureEntity)event.getEntity();
            creatureEntity.field_70714_bg.func_75776_a(3, new AvoidBaseEntityGoal<ConstructEntity>(creatureEntity, ConstructEntity.class, 8.0f, 0.6, 1.0));
        }
        if (event.getEntity() instanceof CreatureEntity && !(event.getEntity() instanceof WhispererEntity)) {
            creatureEntity = (CreatureEntity)event.getEntity();
            creatureEntity.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal(creatureEntity, VineEntity.class, 8.0f, 0.6, 1.0));
        }
        if (event.getEntity() instanceof IllusionerCloneEntity && (illusionerCloneEntity = (IllusionerCloneEntity)event.getEntity()).getCaster() != null && !illusionerCloneEntity.field_70170_p.field_72995_K && (caster = illusionerCloneEntity.getCaster()) instanceof IllusionerEntity && (cloneable = CloneableHelper.getCloneableCapability((Entity)caster)) != null) {
            cloneable.addClone(illusionerCloneEntity.func_110124_au());
        }
        if (event.getEntity() instanceof IllusionerEntity) {
            IllusionerEntity illusionerEntity = (IllusionerEntity)event.getEntity();
            GoalSelector goalSelector = illusionerEntity.field_70714_bg;
        }
    }

    @SubscribeEvent
    public static void onIllusionerAttacked(LivingAttackEvent event) {
        IllusionerEntity illusionerEntity;
        ICloneable cloneable;
        if (event.getEntityLiving() instanceof IllusionerEntity && !(event.getSource().func_76346_g() instanceof IllusionerCloneEntity) && (cloneable = CloneableHelper.getCloneableCapability((Entity)(illusionerEntity = (IllusionerEntity)event.getEntityLiving()))) != null && illusionerEntity.field_70170_p instanceof ServerWorld) {
            UUID[] clones = cloneable.getClones();
            for (int i = 0; i < clones.length; ++i) {
                UUID currentClone = clones[i];
                if (currentClone == null) continue;
                ServerWorld serverWorld = (ServerWorld)illusionerEntity.field_70170_p;
                Entity entity = serverWorld.func_217461_a(currentClone);
                if (entity != null) {
                    entity.func_70106_y();
                }
                clones[i] = null;
            }
        }
    }

    @SubscribeEvent
    public static void onIllusionerBecomesInvisible(PotionEvent.PotionAddedEvent event) {
        IllusionerEntity illusionerEntity;
        if (event.getEntityLiving() instanceof IllusionerEntity && !(illusionerEntity = (IllusionerEntity)event.getEntityLiving()).func_70644_a(Effects.field_76441_p) && event.getPotionEffect().func_188419_a() == Effects.field_76441_p && !illusionerEntity.field_70170_p.field_72995_K && illusionerEntity.func_193082_dl()) {
            MobEvents.summonIllusionerClones(illusionerEntity);
        }
    }

    private static void summonIllusionerClones(IllusionerEntity illusionerEntity) {
        int difficultyAsInt = illusionerEntity.field_70170_p.func_175659_aa().func_151525_a();
        int mobsToSummon = difficultyAsInt * 2 + 1;
        for (int i = 0; i < mobsToSummon; ++i) {
            BlockPos blockpos = illusionerEntity.func_233580_cy_().func_177982_a(-2 + illusionerEntity.func_70681_au().nextInt(5), 1, -2 + illusionerEntity.func_70681_au().nextInt(5));
            IllusionerCloneEntity illusionerCloneEntity = new IllusionerCloneEntity(illusionerEntity.field_70170_p, (LivingEntity)illusionerEntity, 600);
            DifficultyInstance difficultyForLocation = illusionerEntity.field_70170_p.func_175649_E(blockpos);
            illusionerCloneEntity.func_174828_a(blockpos, 0.0f, 0.0f);
            illusionerCloneEntity.func_213386_a((IServerWorld)illusionerCloneEntity.field_70170_p, difficultyForLocation, SpawnReason.MOB_SUMMONED, null, null);
            illusionerEntity.field_70170_p.func_217376_c((Entity)illusionerCloneEntity);
        }
    }

    @SubscribeEvent
    public static void onSnowballHitPlayer(ProjectileImpactEvent event) {
        EntityRayTraceResult entityRayTraceResult;
        RayTraceResult rayTraceResult;
        SnowballEntity snowballEntity;
        Entity shooter;
        if (event.getEntity() instanceof SnowballEntity && (shooter = (snowballEntity = (SnowballEntity)event.getEntity()).func_234616_v_()) instanceof FrozenZombieEntity && (rayTraceResult = event.getRayTraceResult()) instanceof EntityRayTraceResult && (entityRayTraceResult = (EntityRayTraceResult)rayTraceResult).func_216348_a() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entityRayTraceResult.func_216348_a();
            playerEntity.func_70097_a(DamageSource.func_76356_a((Entity)snowballEntity, (Entity)shooter), 1.0f);
        }
    }

    @SubscribeEvent
    public static void onSnowballDamageMob(LivingHurtEvent event) {
        if (event.getSource().func_76364_f() instanceof SnowballEntity && event.getSource().func_76346_g() instanceof FrozenZombieEntity && !(event.getEntityLiving() instanceof PlayerEntity)) {
            event.setAmount(event.getAmount() + 1.0f);
        }
    }

    @SubscribeEvent
    public static void onIceCreeperExplosion(EntityMobGriefingEvent event) {
        if (event.getEntity() instanceof IcyCreeperEntity) {
            IcyCreeperEntity iceCreeperEntity = (IcyCreeperEntity)event.getEntity();
            iceCreeperEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
        }
    }

    @SubscribeEvent
    public static void onExplosionDetonate(ExplosionEvent.Detonate event) {
        MobEvents.handlePillarProtection(event);
        if (event.getExplosion().getExploder() instanceof IcyCreeperEntity) {
            List entityList = event.getAffectedEntities();
            for (Entity entity : entityList) {
                if (!(entity instanceof LivingEntity)) continue;
                LivingEntity livingEntity = (LivingEntity)entity;
                livingEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 600));
            }
        }
    }

    private static void handlePillarProtection(ExplosionEvent.Detonate event) {
        boolean pillarsArePresent;
        Explosion explosion = event.getExplosion();
        Entity source = explosion.getExploder();
        BlockPos detonationOrigin = new BlockPos(explosion.getPosition());
        List entityList = event.getAffectedEntities();
        ArrayList<ConstructEntity> potentialProtectingPillars = new ArrayList<ConstructEntity>(Collections.emptyList());
        for (Entity entity : entityList) {
            if (!(entity instanceof ConstructEntity) || entity == source) continue;
            potentialProtectingPillars.add((ConstructEntity)entity);
        }
        boolean bl = pillarsArePresent = !potentialProtectingPillars.isEmpty();
        if (!pillarsArePresent) {
            return;
        }
        Iterator it = entityList.iterator();
        while (it.hasNext()) {
            boolean protectedByPillar;
            Entity currentEntity = (Entity)it.next();
            boolean notAPillar = !(currentEntity instanceof ConstructEntity);
            if (!notAPillar || currentEntity == null || !(protectedByPillar = MobEvents.entityProtectedByPillar(currentEntity, potentialProtectingPillars, detonationOrigin))) continue;
            it.remove();
        }
    }

    private static boolean entityProtectedByPillar(Entity entity, List<ConstructEntity> pillarEntities, BlockPos detonationOrigin) {
        if (pillarEntities.isEmpty()) {
            return false;
        }
        BlockPos entityPos = entity.func_233580_cy_();
        for (ConstructEntity pillarEntity : pillarEntities) {
            double distanceExplosionToEntity;
            double distanceExplosionToPillar;
            BlockPos pillarPos = pillarEntity.func_233580_cy_();
            double widthAllowance = pillarEntity.func_213311_cf();
            double distanceEntityToPillar = Math.sqrt(entityPos.func_177951_i((Vector3i)pillarPos));
            boolean canProtect = distanceEntityToPillar + (distanceExplosionToPillar = Math.sqrt(detonationOrigin.func_177951_i((Vector3i)pillarPos))) <= (distanceExplosionToEntity = Math.sqrt(detonationOrigin.func_177951_i((Vector3i)entityPos))) + widthAllowance;
            if (!canProtect) continue;
            return true;
        }
        return false;
    }
}

