/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.blocks;

import com.infamous.dungeons_mobs.mod.ModBlocks;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractFireBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoulFireBlock;
import net.minecraft.entity.Entity;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class WraithFireBlock
extends AbstractFireBlock {
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    private final float fireDamage;

    public WraithFireBlock(AbstractBlock.Properties properties) {
        super(properties, 2.0f);
        this.fireDamage = 2.0f;
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(stateIn, (IWorldReader)worldIn, currentPos) ? this.getFireWithAge(worldIn, currentPos, (Integer)stateIn.func_177229_b((Property)AGE)) : Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, WraithFireBlock.getTickCooldown(worldIn.field_73012_v));
        if (worldIn.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            int j;
            BlockState blockstate;
            if (!state.func_196955_c((IWorldReader)worldIn, pos)) {
                worldIn.func_217377_a(pos, false);
            }
            boolean isOnFireSourceBlock = (blockstate = worldIn.func_180495_p(pos.func_177977_b())).isFireSource((IWorldReader)worldIn, pos, Direction.UP) || SoulFireBlock.func_235577_c_((Block)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
            int i = (Integer)state.func_177229_b((Property)AGE);
            if (i != (j = Math.min(15, i + rand.nextInt(3) / 2))) {
                state = (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(j));
                worldIn.func_180501_a(pos, state, 4);
            }
            if (!isOnFireSourceBlock) {
                BlockPos blockpos = pos.func_177977_b();
                if (!worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || i > 3) {
                    worldIn.func_217377_a(pos, false);
                }
                return;
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
        worldIn.func_205220_G_().func_205360_a(pos, (Object)this, WraithFireBlock.getTickCooldown(worldIn.field_73012_v));
    }

    private static int getTickCooldown(Random rand) {
        return 30 + rand.nextInt(10);
    }

    private BlockState getFireWithAge(IWorld world, BlockPos pos, int age) {
        BlockState blockstate = ((WraithFireBlock)ModBlocks.WRAITH_FIRE_BLOCK.get()).func_176223_P();
        return blockstate.func_203425_a((Block)ModBlocks.WRAITH_FIRE_BLOCK.get()) ? (BlockState)blockstate.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age)) : blockstate;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.func_230279_az_() || entityIn.func_200600_R() != ModEntityTypes.WRAITH.get()) {
            entityIn.func_241209_g_(entityIn.func_223314_ad() + 1);
            if (entityIn.func_223314_ad() == 0) {
                entityIn.func_70015_d(8);
            }
            entityIn.func_70097_a(DamageSource.field_76372_a, this.fireDamage);
        }
    }

    protected boolean func_196446_i(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE});
    }
}

