/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.client.renderer.illager;

import com.infamous.dungeons_mobs.client.models.armor.IllagerArmorModel;
import com.infamous.dungeons_mobs.client.models.illager.IllagerBipedModel;
import com.infamous.dungeons_mobs.entities.illagers.ArmoredPillagerEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.util.ResourceLocation;

public class CustomPillagerRenderer
extends MobRenderer<PillagerEntity, IllagerBipedModel<PillagerEntity>> {
    private static final ResourceLocation GOLD_ARMORED_PILLAGER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/gold_armored_pillager.png");
    private static final ResourceLocation DIAMOND_ARMORED_PILLAGER_TEXTURE = new ResourceLocation("dungeons_mobs", "textures/entity/illager/diamond_armored_pillager.png");
    private static final ResourceLocation PILLAGER_TEXTURE = new ResourceLocation("textures/entity/illager/pillager.png");

    public CustomPillagerRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new IllagerBipedModel(0.0f, 0.0f, 64, 64), 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, (BipedModel)new IllagerArmorModel(0.5f), (BipedModel)new IllagerArmorModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
    }

    protected void preRenderCallback(PillagerEntity pillagerEntity, MatrixStack matrixStack, float v) {
        if (pillagerEntity instanceof ArmoredPillagerEntity) {
            float scaleFactor = 1.1f;
            matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        } else {
            float scaleFactor = 0.9375f;
            matrixStack.func_227862_a_(scaleFactor, scaleFactor, scaleFactor);
        }
        super.func_225620_a_((LivingEntity)pillagerEntity, matrixStack, v);
    }

    public ResourceLocation getEntityTexture(PillagerEntity entity) {
        if (entity instanceof ArmoredPillagerEntity) {
            ArmoredPillagerEntity armoredPillagerEntity = (ArmoredPillagerEntity)entity;
            if (armoredPillagerEntity.isDiamond()) {
                return DIAMOND_ARMORED_PILLAGER_TEXTURE;
            }
            return GOLD_ARMORED_PILLAGER_TEXTURE;
        }
        return PILLAGER_TEXTURE;
    }
}

