/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DungeonsMobsConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        Pair commonSpecPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)commonSpecPair.getRight();
        COMMON = (Common)commonSpecPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_WRAITH_FIRE_SUMMON;
        public static ForgeConfigSpec.ConfigValue<List<? extends String>> NECROMANCER_MOB_SUMMONS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_ZOMBIE_REPLACES_ZOMBIE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_SKELETON_REPLACES_SKELETON;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_MOUNTAINEER_REPLACES_MOUNTAINEER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_VINDICATOR_REPLACES_VINDICATOR;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_PILLAGER_REPLACES_PILLAGER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_FROZEN_ZOMBIE_REPLACES_ZOMBIE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ICY_CREEPER_REPLACES_CREEPER;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_JUNGLE_ZOMBIE_REPLACES_ZOMBIE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MOSSY_SKELETON_REPLACES_SKELETON;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ICEOLOGER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ICEOLOGER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WRAITH_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WRAITH_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> NECROMANCER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> NECROMANCER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> SKELETON_HORSEMAN_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_HORSEMAN_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_HORSEMAN_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> SKELETON_HORSEMAN_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> MOUNTAINEER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> MOUNTAINEER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WINDCALLER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WINDCALLER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> GEOMANCER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> GEOMANCER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> ILLUSIONER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> ILLUSIONER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> VINDICATOR_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> VINDICATOR_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> EVOKER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> EVOKER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> PILLAGER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> PILLAGER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> WHISPERER_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> WHISPERER_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> LEAPLEAF_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> LEAPLEAF_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> SQUALL_GOLEM_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> QUICK_GROWING_VINE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> QUICK_GROWING_VINE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> POISON_QUILL_VINE_BIOME_TYPES;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_SPAWN_WEIGHT;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_MIN_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Integer> POISON_QUILL_VINE_MAX_GROUP_SIZE;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_BIOME_SPECIFIC_RAIDERS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MOUNTAINEERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_VINDICATOR_CHEFS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_VINDICATORS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_MOUNTAINEERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ROYAL_GUARDS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_GEOMANCERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ILLUSIONERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ICEOLOGERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_WINDCALLERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_ARMORED_PILLAGERS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_SQUALL_GOLEMS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_REDSTONE_GOLEMS_IN_RAIDS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_STRONGER_HUSKS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_RANGED_SPIDERS;
        public final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_CLONING_ILLUSIONERS;

        public Common(ForgeConfigSpec.Builder builder) {
            builder.comment("Mob Configuration").push("mob_configuration");
            this.ENABLE_WRAITH_FIRE_SUMMON = builder.comment("Enable the default ability of Wraiths to summon Wraith Fire around the player as an attack. \nIf you prefer a less griefy attack using Soul Fireballs akin to the Blaze, disable this feature. [true / false]").define("enableWraithFireSummon", true);
            NECROMANCER_MOB_SUMMONS = builder.comment("Add mobs (preferably undead) that the Necromancer can summon. \nTo do so, enter the namespace ID of the mob, like \"minecraft:zombie\".\nIf this list is empty, zombies will be summoned instead.\nIf a mob chosen from this list cannot be spawned, a zombie will be summoned instead.").defineList("necromancerMobSummons", (List)Lists.newArrayList((Object[])new String[]{"minecraft:zombie", "minecraft:skeleton", "dungeons_mobs:armored_zombie", "dungeons_mobs:armored_skeleton", "dungeons_mobs:wraith"}), itemRaw -> itemRaw instanceof String);
            builder.pop();
            builder.comment("Spawn Configuration").push("spawn_configuration");
            this.ENABLE_FROZEN_ZOMBIE_REPLACES_ZOMBIE = builder.comment("Enable Frozen Zombies replacing 80% of  Zombie spawns in ICY biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableFrozenZombieReplacesZombie", true);
            this.ENABLE_ICY_CREEPER_REPLACES_CREEPER = builder.comment("Enable Icy Creepers replacing 80% of Creeper spawns in ICY biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableIcyCreeperReplacesCreeper", true);
            this.ENABLE_JUNGLE_ZOMBIE_REPLACES_ZOMBIE = builder.comment("Enable Jungle Zombies replacing 80% of Zombie spawns in JUNGLE biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableJungleZombieReplacesZombie", true);
            this.ENABLE_MOSSY_SKELETON_REPLACES_SKELETON = builder.comment("Enable Mossy Skeletons  80% of Skeleton spawns in JUNGLE biomes. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableMossySkeletonReplacesSkeleton", true);
            this.ENABLE_ARMORED_ZOMBIE_REPLACES_ZOMBIE = builder.comment("Enable Armored Zombies replacing 10% of Zombie spawns in the biomes they can spawn in. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableArmoredZombieReplacesZombie", true);
            this.ENABLE_ARMORED_SKELETON_REPLACES_SKELETON = builder.comment("Enable Armored Skeletons replacing 10% of Skeleton spawns in the biomes they can spawn in. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableArmoredSkeletonReplacesSkeleton", true);
            this.ENABLE_ARMORED_MOUNTAINEER_REPLACES_MOUNTAINEER = builder.comment("Enable Armored Mountaineers replacing 10% of Mountaineer spawns in the biomes they can spawn in. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableArmoredMountaineerReplacesMountaineer", true);
            this.ENABLE_ARMORED_VINDICATOR_REPLACES_VINDICATOR = builder.comment("Enable Armored Vindicators replacing 10% of Vindicator spawns in the biomes they can spawn in. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableArmoredVindicatorReplacesVindicator", true);
            this.ENABLE_ARMORED_PILLAGER_REPLACES_PILLAGER = builder.comment("Enable Armored Pillagers replacing 10% of Pillager spawns in the biomes they can spawn in. \nIf you prefer to not have them do this, disable this feature. [true / false]").define("enableArmoredPillagerReplacesPillager", true);
            this.ICEOLOGER_BIOME_TYPES = builder.comment("Add biome types that the Iceologer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("iceologerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SNOWY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ICEOLOGER_SPAWN_WEIGHT = builder.comment("Spawn weight of Iceologers in the biomes they can spawn in. [default:5]").defineInRange("iceologerSpawnWeight", 5, 0, 1024);
            this.ICEOLOGER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Iceologers in the biomes they can spawn in. [default:1]").defineInRange("iceologerMinGroupSize", 1, 0, 128);
            this.ICEOLOGER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Iceologers in the biomes they can spawn in. [default:1]").defineInRange("iceologerMaxGroupSize", 1, 0, 128);
            this.WRAITH_BIOME_TYPES = builder.comment("Add biome types that the Wraith can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("wraithBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OVERWORLD", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WRAITH_SPAWN_WEIGHT = builder.comment("Spawn weight of Wraiths in the biomes they can spawn in. [default:5]").defineInRange("wraithSpawnWeight", 5, 0, 1024);
            this.WRAITH_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Wraiths in the biomes they can spawn in. [default:1]").defineInRange("wraithMinGroupSize", 1, 0, 128);
            this.WRAITH_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Wraiths in the biomes they can spawn in. [default:1]").defineInRange("wraithMaxGroupSize", 1, 0, 128);
            this.NECROMANCER_BIOME_TYPES = builder.comment("Add biome types that the Necromancer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("necromancerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SANDY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.NECROMANCER_SPAWN_WEIGHT = builder.comment("Spawn weight of Necromancers in the biomes they can spawn in. [default:5]").defineInRange("necromancerSpawnWeight", 5, 0, 1024);
            this.NECROMANCER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Necromancers in the biomes they can spawn in. [default:1]").defineInRange("necromancerMinGroupSize", 1, 0, 128);
            this.NECROMANCER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Necromancers in the biomes they can spawn in. [default:1]").defineInRange("necromancerMaxGroupSize", 1, 0, 128);
            this.SKELETON_HORSEMAN_BIOME_TYPES = builder.comment("Add biome types that the Skeleton Horseman can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("skeletonHorsemanBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"OVERWORLD", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.SKELETON_HORSEMAN_SPAWN_WEIGHT = builder.comment("Spawn weight of Skeleton Horsemen in the biomes they can spawn in. [default:1]").defineInRange("skeletonHorsemanSpawnWeight", 1, 0, 1024);
            this.SKELETON_HORSEMAN_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Skeleton Horsemen in the biomes they can spawn in. [default:1]").defineInRange("skeletonHorsemanMinGroupSize", 1, 0, 32);
            this.SKELETON_HORSEMAN_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Skeleton Horsemen in the biomes they can spawn in. [default:1]").defineInRange("skeletonHorsemanMaxGroupSize", 1, 0, 32);
            this.MOUNTAINEER_BIOME_TYPES = builder.comment("Add biome types that the Mountaineer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("mountaineerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.MOUNTAINEER_SPAWN_WEIGHT = builder.comment("Spawn weight of Mountaineers in the biomes they can spawn in. [default:5]").defineInRange("mountaineerSpawnWeight", 5, 0, 1024);
            this.MOUNTAINEER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Mountaineers in the biomes they can spawn in. [default:1]").defineInRange("mountaineerMinGroupSize", 1, 0, 32);
            this.MOUNTAINEER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Mountaineers in the biomes they can spawn in. [default:4]").defineInRange("mountaineerMaxGroupSize", 4, 0, 32);
            this.WINDCALLER_BIOME_TYPES = builder.comment("Add biome types that the Windcaller can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("windcallerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WINDCALLER_SPAWN_WEIGHT = builder.comment("Spawn weight of Windcallers in the biomes they can spawn in. [default:5]").defineInRange("windcallerSpawnWeight", 5, 0, 1024);
            this.WINDCALLER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Windcallers in the biomes they can spawn in. [default:1]").defineInRange("windcallerMinGroupSize", 1, 0, 128);
            this.WINDCALLER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Windcallers in the biomes they can spawn in. [default:1]").defineInRange("windcallerMaxGroupSize", 1, 0, 128);
            this.GEOMANCER_BIOME_TYPES = builder.comment("Add biome types that the Geomancer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("geomancerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SAVANNA", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.GEOMANCER_SPAWN_WEIGHT = builder.comment("Spawn weight of Geomancers in the biomes they can spawn in. [default:5]").defineInRange("geomancerSpawnWeight", 5, 0, 1024);
            this.GEOMANCER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Geomancers in the biomes they can spawn in. [default:1]").defineInRange("geomancerMinGroupSize", 1, 0, 128);
            this.GEOMANCER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Geomancers in the biomes they can spawn in. [default:1]").defineInRange("geomancerMaxGroupSize", 1, 0, 128);
            this.ILLUSIONER_BIOME_TYPES = builder.comment("Add biome types that the Illusioner can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("illusionerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SNOWY", "MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!HOT", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ILLUSIONER_SPAWN_WEIGHT = builder.comment("Spawn weight of Illusioners in the biomes they can spawn in. [default:1]").defineInRange("illusionerSpawnWeight", 1, 0, 1024);
            this.ILLUSIONER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Illusioners in the biomes they can spawn in. [default:1]").defineInRange("illusionerMinGroupSize", 1, 0, 128);
            this.ILLUSIONER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Illusioners in the biomes they can spawn in. [default:1]").defineInRange("illusionerMaxGroupSize", 1, 0, 128);
            this.VINDICATOR_BIOME_TYPES = builder.comment("Add biome types that the Vindicator can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("vindicatorBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.VINDICATOR_SPAWN_WEIGHT = builder.comment("Spawn weight of Vindicators in the biomes they can spawn in. [default:5]").defineInRange("vindicatorSpawnWeight", 5, 0, 1024);
            this.VINDICATOR_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Vindicators in the biomes they can spawn in. [default:1]").defineInRange("vindicatorMinGroupSize", 1, 0, 128);
            this.VINDICATOR_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Vindicators in the biomes they can spawn in. [default:4]").defineInRange("vindicatorMaxGroupSize", 4, 0, 128);
            this.EVOKER_BIOME_TYPES = builder.comment("Add biome types that the Evoker can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("evokerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.EVOKER_SPAWN_WEIGHT = builder.comment("Spawn weight of Evokers in the biomes they can spawn in. [default:1]").defineInRange("evokerSpawnWeight", 1, 0, 1024);
            this.EVOKER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Evokers in the biomes they can spawn in. [default:1]").defineInRange("evokerMinGroupSize", 1, 0, 128);
            this.EVOKER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Evokers in the biomes they can spawn in. [default:1]").defineInRange("evokerMaxGroupSize", 1, 0, 128);
            this.PILLAGER_BIOME_TYPES = builder.comment("Add biome types that the Pillager can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("pillagerBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"SPOOKY", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.PILLAGER_SPAWN_WEIGHT = builder.comment("Spawn weight of Pillagers in the biomes they can spawn in. [default:5]").defineInRange("pillagerSpawnWeight", 5, 0, 1024);
            this.PILLAGER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Pillagers in the biomes they can spawn in. [default:1]").defineInRange("pillagerMinGroupSize", 1, 0, 128);
            this.PILLAGER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Pillagers in the biomes they can spawn in. [default:4]").defineInRange("pillagerMaxGroupSize", 4, 0, 128);
            this.WHISPERER_BIOME_TYPES = builder.comment("Add biome types that the Whisperer can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("whispererBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.WHISPERER_SPAWN_WEIGHT = builder.comment("Spawn weight of Whisperers in the biomes they can spawn in. [default:5]").defineInRange("whispererSpawnWeight", 5, 0, 1024);
            this.WHISPERER_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Whisperers in the biomes they can spawn in. [default:1]").defineInRange("whispererMinGroupSize", 1, 0, 128);
            this.WHISPERER_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Whisperers in the biomes they can spawn in. [default:4]").defineInRange("whispererMaxGroupSize", 4, 0, 128);
            this.LEAPLEAF_BIOME_TYPES = builder.comment("Add biome types that the Leapleaf can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("leapleafBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.LEAPLEAF_SPAWN_WEIGHT = builder.comment("Spawn weight of Leapleafs in the biomes they can spawn in. [default:5]").defineInRange("leapleafSpawnWeight", 5, 0, 1024);
            this.LEAPLEAF_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Leapleafs in the biomes they can spawn in. [default:1]").defineInRange("leapleafMinGroupSize", 1, 0, 128);
            this.LEAPLEAF_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Leapleafs in the biomes they can spawn in. [default:4]").defineInRange("leapleafMaxGroupSize", 4, 0, 128);
            this.QUICK_GROWING_VINE_BIOME_TYPES = builder.comment("Add biome types that the Quick-Growing Vines can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("quickGrowingVineBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.QUICK_GROWING_VINE_SPAWN_WEIGHT = builder.comment("Spawn weight of Quick-Growing Vines in the biomes they can spawn in. [default:5]").defineInRange("quickGrowingVineSpawnWeight", 5, 0, 1024);
            this.QUICK_GROWING_VINE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Quick-Growing Vines in the biomes they can spawn in. [default:1]").defineInRange("quickGrowingVineMinGroupSize", 1, 0, 128);
            this.QUICK_GROWING_VINE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Quick-Growing Vines in the biomes they can spawn in. [default:1]").defineInRange("quickGrowingVineMaxGroupSize", 1, 0, 128);
            this.POISON_QUILL_VINE_BIOME_TYPES = builder.comment("Add biome types that the Poison-Quill Vines can spawn in. \nPut a \"!\" before the type to prevent spawning in that biome type. \nLeave this blank if you don't want them to spawn at all.").defineList("poisonQuillVineBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"JUNGLE", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.POISON_QUILL_VINE_SPAWN_WEIGHT = builder.comment("Spawn weight of Poison-Quill Vines in the biomes they can spawn in. [default:5]").defineInRange("poisonQuillVineSpawnWeight", 5, 0, 1024);
            this.POISON_QUILL_VINE_MIN_GROUP_SIZE = builder.comment("Minimum spawn group size of Poison-Quill Vines in the biomes they can spawn in. [default:1]").defineInRange("poisonQuillVineMinGroupSize", 1, 0, 128);
            this.POISON_QUILL_VINE_MAX_GROUP_SIZE = builder.comment("Maximum spawn group size of Poison-Quill Vines in the biomes they can spawn in. [default:1]").defineInRange("poisonQuillVineMaxGroupSize", 1, 0, 128);
            builder.pop();
            builder.comment("Raid Configuration").push("raid_configuration");
            this.ENABLE_BIOME_SPECIFIC_RAIDERS = builder.comment("Enables logic for only allowing certain raiders to spawn as a part of raids in certain biome types.  \nThis will make the Mountaineers, Windcaller, Iceologer and Squall Golem only spawn as raiders in their allowed biomes. \nIf they are not allowed to spawn as part of a raid in a given biome, \nanother equivalent Illager type (Vindicator, Evoker, Ravager) will spawn instead. \nIf they are not configured to be added to raids, \nthey will replace their equivalent Illager type (Vindicator, Evoker, Ravager) in raids taking place in their allowed biomes. [true / false]").define("enableBiomeSpecificRaiders", false);
            this.SQUALL_GOLEM_BIOME_TYPES = builder.comment("Add biome types that the Squall Golem can spawn in (if biome-specific raiding is enabled). \nPut a \"!\" before the type to prevent spawning (in biome-specific raids) in that biome type. \nLeave this blank if you don't want them to spawn (in biome-specific raids) at all.").defineList("squallGolemBiomeTypes", (List)Lists.newArrayList((Object[])new String[]{"MOUNTAIN", "!SANDY", "!JUNGLE", "!FOREST", "!MUSHROOM", "!HOT", "!MUSHROOM", "!NETHER", "!END"}), itemRaw -> itemRaw instanceof String);
            this.ENABLE_MOUNTAINEERS_IN_RAIDS = builder.comment("Enable the addition of Mountaineers to raids. [true / false]").define("enableMountaineersInRaids", false);
            this.ENABLE_VINDICATOR_CHEFS_IN_RAIDS = builder.comment("Enable the addition of Vindicator Chefs to raids. [true / false]").define("enableVindicatorChefsInRaids", false);
            this.ENABLE_ARMORED_VINDICATORS_IN_RAIDS = builder.comment("Enable the addition of Armored Vindicators to raids. [true / false]").define("enableArmoredVindicatorsInRaids", true);
            this.ENABLE_ARMORED_MOUNTAINEERS_IN_RAIDS = builder.comment("Enable the addition of Armored Mountaineers to raids. [true / false]").define("enableArmoredMountaineersInRaids", false);
            this.ENABLE_ROYAL_GUARDS_IN_RAIDS = builder.comment("Enable the addition of Royal Guards to raids. [true / false]").define("enableRoyalGuardsInRaids", false);
            this.ENABLE_GEOMANCERS_IN_RAIDS = builder.comment("Enable the addition of Geomancers to raids. [true / false]").define("enableGeomancersInRaids", true);
            this.ENABLE_ILLUSIONERS_IN_RAIDS = builder.comment("Enable the addition of Illusioners to raids. [true / false]").define("enableIllusionersInRaids", false);
            this.ENABLE_ICEOLOGERS_IN_RAIDS = builder.comment("Enable the addition of Iceologers to raids. [true / false]").define("enableIceologersInRaids", false);
            this.ENABLE_WINDCALLERS_IN_RAIDS = builder.comment("Enable the addition of Windcallers to raids. [true / false]").define("enableWindcallersInRaids", false);
            this.ENABLE_ARMORED_PILLAGERS_IN_RAIDS = builder.comment("Enable the addition of Armored Pillagers to raids. [true / false]").define("enableArmoredPillagersInRaids", true);
            this.ENABLE_SQUALL_GOLEMS_IN_RAIDS = builder.comment("Enable the addition of Squall Golems to raids. [true / false]").define("enableSquallGolemsInRaids", true);
            this.ENABLE_REDSTONE_GOLEMS_IN_RAIDS = builder.comment("Enable the addition of Redstone Golems to raids. [true / false]").define("enableRedstoneGolemsInRaids", true);
            builder.pop();
            builder.comment("Vanilla Mob Configuration").push("vanilla_mob_configuration");
            this.ENABLE_STRONGER_HUSKS = builder.comment("Enable the addition of additional attributes to Husks to make them as powerful as they are in Minecraft Dungeons. [true / false]").define("enableStrongerHusks", true);
            this.ENABLE_RANGED_SPIDERS = builder.comment("Enables Spiders and Cave Spiders shooting webs as a ranged attack like they do in Minecraft Dungeons. [true / false]").define("enableRangedSpiders", true);
            this.ENABLE_CLONING_ILLUSIONERS = builder.comment("Enables Illusioners to have the same cloning behavior as they do in Minecraft Dungeons. [true / false]").define("enableCloningIllusioners", true);
            builder.pop();
        }
    }
}

