/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.google.common.collect.Maps;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.VindicatorEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmoredVindicatorEntity
extends VindicatorEntity {
    private static final DataParameter<Boolean> IS_DIAMOND = EntityDataManager.func_187226_a(ArmoredVindicatorEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public ArmoredVindicatorEntity(World world) {
        super((EntityType)ModEntityTypes.ARMORED_VINDICATOR.get(), world);
    }

    public ArmoredVindicatorEntity(EntityType<? extends VindicatorEntity> p_i50189_1_, World p_i50189_2_) {
        super(p_i50189_1_, p_i50189_2_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_DIAMOND, (Object)false);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return VindicatorEntity.func_234322_eI_().func_233815_a_(Attributes.field_233818_a_, 36.0).func_233815_a_(Attributes.field_233823_f_, 7.0).func_233814_a_(Attributes.field_233820_c_);
    }

    protected void func_180481_a(DifficultyInstance difficultyInstance) {
        if (this.func_213663_ek() == null) {
            if (this.isDiamond()) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.DIAMOND_VINDICATOR_HELMET.get()));
            } else {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.GOLD_VINDICATOR_HELMET.get()));
            }
            this.setWeaponBasedOnMod();
        }
    }

    private void setWeaponBasedOnMod() {
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item DOUBLE_AXE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "double_axe"));
            Item WHIRLWIND = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "whirlwind"));
            ItemStack doubleAxe = new ItemStack((IItemProvider)DOUBLE_AXE);
            ItemStack whirlwind = new ItemStack((IItemProvider)WHIRLWIND);
            ItemStack mainhandWeapon = this.isDiamond() ? whirlwind : doubleAxe;
            this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
        } else {
            this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151036_c));
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.isDiamond()) {
            compound.func_74757_a("Diamond", true);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Diamond", 99)) {
            this.setDiamond(compound.func_74767_n("Diamond"));
        }
    }

    public boolean isDiamond() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_DIAMOND);
    }

    public void setDiamond(boolean isDiamond) {
        this.field_70180_af.func_187227_b(IS_DIAMOND, (Object)isDiamond);
    }

    public boolean func_213637_dY() {
        return false;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        float diamondChance = this.field_70146_Z.nextFloat();
        if (diamondChance < 0.25f) {
            this.setDiamond(true);
            this.applyDiamondArmorBoosts();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    private void applyDiamondArmorBoosts() {
        this.func_110148_a(Attributes.field_233826_i_).func_233769_c_(new AttributeModifier("Diamond armor boost", 10.0, AttributeModifier.Operation.ADDITION));
        this.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("Diamond knockback resistance boost", 0.6, AttributeModifier.Operation.ADDITION));
        this.func_110148_a(Attributes.field_233823_f_).func_233769_c_(new AttributeModifier("Diamond attack boost", 1.0, AttributeModifier.Operation.ADDITION));
    }

    public void func_213660_a(int waveAmount, boolean b) {
        boolean applyEnchant;
        ItemStack mainhandWeapon = this.getWeaponBasedOnMod();
        ItemStack helmet = this.isDiamond() ? new ItemStack((IItemProvider)ModItems.DIAMOND_VINDICATOR_HELMET.get()) : new ItemStack((IItemProvider)ModItems.GOLD_VINDICATOR_HELMET.get());
        Raid raid = this.func_213663_ek();
        int enchantmentLevel = 1;
        if (waveAmount > raid.func_221306_a(Difficulty.NORMAL)) {
            enchantmentLevel = 2;
        }
        boolean bl = applyEnchant = this.field_70146_Z.nextFloat() <= raid.func_221308_w();
        if (applyEnchant) {
            HashMap weaponEnchantmentMap = Maps.newHashMap();
            HashMap armorEnchantmentMap = Maps.newHashMap();
            weaponEnchantmentMap.put(Enchantments.field_185302_k, enchantmentLevel);
            armorEnchantmentMap.put(Enchantments.field_180310_c, enchantmentLevel);
            EnchantmentHelper.func_82782_a((Map)weaponEnchantmentMap, (ItemStack)mainhandWeapon);
            EnchantmentHelper.func_82782_a((Map)armorEnchantmentMap, (ItemStack)helmet);
        }
        this.func_184201_a(EquipmentSlotType.MAINHAND, mainhandWeapon);
        this.func_184201_a(EquipmentSlotType.HEAD, helmet);
    }

    private ItemStack getWeaponBasedOnMod() {
        ItemStack mainhandWeapon;
        if (ModList.get().isLoaded("dungeons_gear")) {
            Item DOUBLE_AXE = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "double_axe"));
            Item WHIRLWIND = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("dungeons_gear", "whirlwind"));
            ItemStack doubleAxe = new ItemStack((IItemProvider)DOUBLE_AXE);
            ItemStack whirlwind = new ItemStack((IItemProvider)WHIRLWIND);
            mainhandWeapon = this.isDiamond() ? whirlwind : doubleAxe;
        } else {
            mainhandWeapon = new ItemStack((IItemProvider)Items.field_151036_c);
        }
        return mainhandWeapon;
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }
}

