/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.illagers;

import com.infamous.dungeons_mobs.entities.summonables.TornadoEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.mod.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.EvokerEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class WindcallerEntity
extends SpellcastingIllagerEntity {
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    public float prevCameraYaw;
    public float cameraYaw;

    public WindcallerEntity(World world) {
        super((EntityType)ModEntityTypes.WINDCALLER.get(), world);
    }

    public WindcallerEntity(EntityType<? extends SpellcastingIllagerEntity> type, World world) {
        super(type, world);
    }

    public boolean func_213637_dY() {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new CastingSpellGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new SummonTornadoGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return EvokerEntity.func_234289_eI_();
    }

    protected void func_180481_a(DifficultyInstance difficulty) {
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.WINDCALLER_STAFF.get()));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_180481_a(difficultyIn);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (super.func_184191_r(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).func_70668_bt() == CreatureAttribute.field_223225_d_) {
            return this.func_96124_cp() == null && entityIn.func_96124_cp() == null;
        }
        return false;
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_191246_bp;
    }

    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_219624_cV;
    }

    public AbstractIllagerEntity.ArmPose func_193077_p() {
        AbstractIllagerEntity.ArmPose illagerArmPose = super.func_193077_p();
        if (illagerArmPose == AbstractIllagerEntity.ArmPose.CROSSED) {
            return AbstractIllagerEntity.ArmPose.NEUTRAL;
        }
        return illagerArmPose;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateCape();
    }

    public void func_70098_U() {
        super.func_70098_U();
        this.prevCameraYaw = this.cameraYaw;
        this.cameraYaw = 0.0f;
    }

    private void updateCape() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double xDifference = this.func_226277_ct_() - this.chasingPosX;
        double yDifference = this.func_226278_cu_() - this.chasingPosY;
        double zDifference = this.func_226281_cx_() - this.chasingPosZ;
        double maxDelta = 10.0;
        if (xDifference > maxDelta) {
            this.prevChasingPosX = this.chasingPosX = this.func_226277_ct_();
        }
        if (zDifference > maxDelta) {
            this.prevChasingPosZ = this.chasingPosZ = this.func_226281_cx_();
        }
        if (yDifference > maxDelta) {
            this.prevChasingPosY = this.chasingPosY = this.func_226278_cu_();
        }
        if (xDifference < -maxDelta) {
            this.prevChasingPosX = this.chasingPosX = this.func_226277_ct_();
        }
        if (zDifference < -maxDelta) {
            this.prevChasingPosZ = this.chasingPosZ = this.func_226281_cx_();
        }
        if (yDifference < -maxDelta) {
            this.prevChasingPosY = this.chasingPosY = this.func_226278_cu_();
        }
        this.chasingPosX += xDifference * 0.25;
        this.chasingPosZ += zDifference * 0.25;
        this.chasingPosY += yDifference * 0.25;
    }

    class SummonTornadoGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private SummonTornadoGoal() {
            super((SpellcastingIllagerEntity)WindcallerEntity.this);
        }

        public boolean func_75250_a() {
            LivingEntity attackTarget = WindcallerEntity.this.func_70638_az();
            if (attackTarget != null) {
                boolean targetOnGround = attackTarget.func_233570_aj_();
                boolean targetCanBeSeen = WindcallerEntity.this.func_70685_l((Entity)attackTarget);
                return super.func_75250_a() && targetOnGround && targetCanBeSeen;
            }
            return false;
        }

        public boolean func_75253_b() {
            LivingEntity attackTarget = WindcallerEntity.this.func_70638_az();
            if (attackTarget != null) {
                boolean targetOnGround = attackTarget.func_233570_aj_();
                boolean targetCanBeSeen = WindcallerEntity.this.func_70685_l((Entity)attackTarget);
                return super.func_75253_b() && targetOnGround && targetCanBeSeen;
            }
            return false;
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            LivingEntity attackTarget = WindcallerEntity.this.func_70638_az();
            if (attackTarget != null) {
                this.summonTornado(attackTarget);
            }
        }

        private void summonTornado(LivingEntity livingEntity) {
            TornadoEntity tornadoEntity = new TornadoEntity(WindcallerEntity.this.field_70170_p, (LivingEntity)WindcallerEntity.this, livingEntity);
            tornadoEntity.addEffect(new EffectInstance(Effects.field_188424_y, 100, 1));
            tornadoEntity.setDuration(100);
            WindcallerEntity.this.field_70170_p.func_217376_c((Entity)tornadoEntity);
        }

        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191248_br;
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class CastingSpellGoal
    extends SpellcastingIllagerEntity.CastingASpellGoal {
        private CastingSpellGoal() {
            super((SpellcastingIllagerEntity)WindcallerEntity.this);
        }

        public void func_75246_d() {
            if (WindcallerEntity.this.func_70638_az() != null) {
                WindcallerEntity.this.func_70671_ap().func_75651_a((Entity)WindcallerEntity.this.func_70638_az(), (float)WindcallerEntity.this.func_184649_cE(), (float)WindcallerEntity.this.func_70646_bf());
            }
        }
    }
}

