/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.redstone;

import com.infamous.dungeons_mobs.entities.redstone.RedstoneMineEntity;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.infamous.dungeons_mobs.utils.GeomancyHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathFinder;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.WalkNodeProcessor;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;

public class RedstoneGolemEntity
extends AbstractRaiderEntity {
    private int attackTimer;
    private int mineAttackCooldown;
    private static final DataParameter<Boolean> SUMMONING_MINES = EntityDataManager.func_187226_a(RedstoneGolemEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public RedstoneGolemEntity(World worldIn) {
        super((EntityType)ModEntityTypes.REDSTONE_GOLEM.get(), worldIn);
    }

    public RedstoneGolemEntity(EntityType<? extends RedstoneGolemEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70749_g = new GolemLookController(this);
        this.field_70765_h = new GolemMovementController(this);
        this.field_70138_W = 1.0f;
        this.field_70728_aV = 40;
        this.mineAttackCooldown = 200;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SUMMONING_MINES, (Object)false);
    }

    public boolean isSummoningMines() {
        return (Boolean)this.field_70180_af.func_187225_a(SUMMONING_MINES);
    }

    public void setSummoningMines(boolean summoningMines) {
        this.field_70180_af.func_187227_b(SUMMONING_MINES, (Object)summoningMines);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(5, (Goal)new SummonRedstoneMinesGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, true));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.attackTimer > 0) {
            --this.attackTimer;
        }
        if (!this.field_70170_p.field_72995_K && this.mineAttackCooldown > 0) {
            --this.mineAttackCooldown;
        }
        this.handleLeafCollision();
        this.handleSteppingOnBlocks();
    }

    private void handleSteppingOnBlocks() {
        int k;
        int j;
        int i;
        BlockPos pos;
        BlockState blockstate;
        if (RedstoneGolemEntity.func_213296_b((Vector3d)this.func_213322_ci()) > 2.500000277905201E-7 && this.field_70146_Z.nextInt(5) == 0 && !(blockstate = this.field_70170_p.func_180495_p(pos = new BlockPos(i = MathHelper.func_76128_c((double)this.func_226277_ct_()), j = MathHelper.func_76128_c((double)(this.func_226278_cu_() - (double)0.2f)), k = MathHelper.func_76128_c((double)this.func_226281_cx_())))).isAir((IBlockReader)this.field_70170_p, pos)) {
            this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, blockstate).setPos(pos), this.func_226277_ct_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), this.func_226278_cu_() + 0.1, this.func_226281_cx_() + ((double)this.field_70146_Z.nextFloat() - 0.5) * (double)this.func_213311_cf(), 4.0 * ((double)this.field_70146_Z.nextFloat() - 0.5), 0.5, ((double)this.field_70146_Z.nextFloat() - 0.5) * 4.0);
        }
    }

    private void handleLeafCollision() {
        if (this.func_70089_S() && this.field_70123_F && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            boolean destroyedLeafBlock = false;
            AxisAlignedBB axisalignedbb = this.func_174813_aQ().func_186662_g(0.2);
            for (BlockPos blockpos : BlockPos.func_191531_b((int)MathHelper.func_76128_c((double)axisalignedbb.field_72340_a), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72338_b), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72339_c), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72336_d), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72337_e), (int)MathHelper.func_76128_c((double)axisalignedbb.field_72334_f))) {
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                Block block = blockstate.func_177230_c();
                if (!(block instanceof LeavesBlock)) continue;
                destroyedLeafBlock = this.field_70170_p.func_225521_a_(blockpos, true, (Entity)this) || destroyedLeafBlock;
            }
            if (!destroyedLeafBlock && this.field_70122_E) {
                this.func_70664_aZ();
            }
        }
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 200.0).func_233815_a_(Attributes.field_233821_d_, 0.25).func_233815_a_(Attributes.field_233820_c_, 1.0).func_233815_a_(Attributes.field_233823_f_, 30.0).func_233815_a_(Attributes.field_233824_g_, 3.0);
    }

    private float getAttackDamage() {
        return (float)this.func_233637_b_(Attributes.field_233823_f_);
    }

    private float getAttackKnockback() {
        return (float)this.func_233637_b_(Attributes.field_233824_g_);
    }

    protected int func_70682_h(int air) {
        return air;
    }

    public boolean func_70652_k(Entity entityIn) {
        this.attackTimer = 10;
        this.field_70170_p.func_72960_a((Entity)this, (byte)4);
        float attackDamage = this.getAttackDamage();
        float attackKnockback = this.getAttackKnockback();
        float adjustedAttackDamage = (int)attackDamage > 0 ? attackDamage / 2.0f + (float)this.field_70146_Z.nextInt((int)attackDamage) : attackDamage;
        boolean didAttack = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), adjustedAttackDamage);
        if (didAttack) {
            if (attackKnockback > 0.0f && entityIn instanceof LivingEntity) {
                LivingEntity attackTarget = (LivingEntity)entityIn;
                double ratioX = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                double ratioZ = -MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                double knockbackReduction = 0.5;
                this.forceKnockback(attackTarget, attackKnockback * 0.5f, ratioX, ratioZ, knockbackReduction);
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
            }
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        return didAttack;
    }

    private void forceKnockback(LivingEntity attackTarget, float strength, double ratioX, double ratioZ, double knockbackResistanceReduction) {
        LivingKnockBackEvent event = ForgeHooks.onLivingKnockBack((LivingEntity)attackTarget, (float)strength, (double)ratioX, (double)ratioZ);
        if (event.isCanceled()) {
            return;
        }
        strength = event.getStrength();
        ratioX = event.getRatioX();
        ratioZ = event.getRatioZ();
        if (!((strength = (float)((double)strength * (1.0 - attackTarget.func_233637_b_(Attributes.field_233820_c_) * knockbackResistanceReduction))) <= 0.0f)) {
            attackTarget.field_70160_al = true;
            Vector3d vector3d = attackTarget.func_213322_ci();
            Vector3d vector3d1 = new Vector3d(ratioX, 0.0, ratioZ).func_72432_b().func_186678_a((double)strength);
            attackTarget.func_213293_j(vector3d.field_72450_a / 2.0 - vector3d1.field_72450_a, attackTarget.func_233570_aj_() ? Math.min(0.4, vector3d.field_72448_b / 2.0 + (double)strength) : vector3d.field_72448_b, vector3d.field_72449_c / 2.0 - vector3d1.field_72449_c);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            this.func_184185_a(SoundEvents.field_226142_fM_, 1.0f, 1.0f);
        }
        return flag;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        BlockPos golemPos = this.func_233580_cy_();
        BlockPos posBeneathGolem = golemPos.func_177977_b();
        BlockState blockstateBeneathGolem = worldIn.func_180495_p(posBeneathGolem);
        if (!blockstateBeneathGolem.func_235719_a_((IBlockReader)worldIn, posBeneathGolem, (Entity)this)) {
            return false;
        }
        for (int i = 1; i < 4; ++i) {
            BlockState blockstateAboveGolem;
            BlockPos posAboveGolem = golemPos.func_177981_b(i);
            if (WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)posAboveGolem, (BlockState)(blockstateAboveGolem = worldIn.func_180495_p(posAboveGolem)), (FluidState)blockstateAboveGolem.func_204520_s(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get()))) continue;
            return false;
        }
        return WorldEntitySpawner.func_234968_a_((IBlockReader)worldIn, (BlockPos)golemPos, (BlockState)worldIn.func_180495_p(golemPos), (FluidState)Fluids.field_204541_a.func_207188_f(), (EntityType)((EntityType)ModEntityTypes.REDSTONE_GOLEM.get())) && worldIn.func_226668_i_((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 4) {
            this.attackTimer = 10;
            this.func_184185_a(SoundEvents.field_187596_cD, 1.0f, 1.0f);
        } else if (id == 5) {
            this.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
        } else {
            super.func_70103_a(id);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, (double)(0.875f * this.func_70047_e()), (double)(this.func_213311_cf() * 0.4f));
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187605_cG, 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187602_cF;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187599_cE;
    }

    protected PathNavigator func_175447_b(World worldIn) {
        return new Navigator((MobEntity)this, worldIn);
    }

    public void func_213660_a(int p_213660_1_, boolean p_213660_2_) {
    }

    public SoundEvent func_213654_dW() {
        return SoundEvents.field_226143_fP_;
    }

    public boolean func_213637_dY() {
        return false;
    }

    private boolean canSummonMines() {
        return this.mineAttackCooldown <= 0 && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.func_233570_aj_();
    }

    class SummonRedstoneMinesGoal
    extends Goal {
        static final int WARM_UP_TICKS = 100;
        static final int MINE_ATTACK_COOLDOWN = 200;
        private int warmUpTicks = 100;

        SummonRedstoneMinesGoal() {
        }

        public boolean func_75250_a() {
            return this.warmUpTicks > 0 && RedstoneGolemEntity.this.canSummonMines();
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75249_e() {
            RedstoneGolemEntity.this.func_70661_as().func_75499_g();
            RedstoneGolemEntity.this.setSummoningMines(true);
            RedstoneGolemEntity.this.field_70170_p.func_72960_a((Entity)RedstoneGolemEntity.this, (byte)5);
            RedstoneGolemEntity.this.func_184185_a(SoundEvents.field_191244_bn, 1.0f, 1.0f);
        }

        public void func_75246_d() {
            --this.warmUpTicks;
            if (this.warmUpTicks <= 0) {
                BlockPos centerPos = RedstoneGolemEntity.this.func_233580_cy_();
                for (int i = 0; i < 14; ++i) {
                    double randomNearbyX = (double)centerPos.func_177958_n() + RedstoneGolemEntity.this.field_70146_Z.nextGaussian() * 10.0;
                    double randomNearbyZ = (double)centerPos.func_177952_p() + RedstoneGolemEntity.this.field_70146_Z.nextGaussian() * 10.0;
                    BlockPos randomBlockPos = new BlockPos(randomNearbyX, (double)centerPos.func_177956_o(), randomNearbyZ);
                    if (!GeomancyHelper.canAllowBlockEntitySpawn((Entity)RedstoneGolemEntity.this, randomBlockPos)) continue;
                    RedstoneMineEntity redstoneMineEntity = new RedstoneMineEntity(RedstoneGolemEntity.this.field_70170_p, randomBlockPos.func_177958_n(), randomBlockPos.func_177956_o(), randomBlockPos.func_177952_p(), (LivingEntity)RedstoneGolemEntity.this);
                    RedstoneGolemEntity.this.field_70170_p.func_217376_c((Entity)redstoneMineEntity);
                }
            }
        }

        public void func_75251_c() {
            this.warmUpTicks = 100;
            RedstoneGolemEntity.this.mineAttackCooldown = 200;
            RedstoneGolemEntity.this.setSummoningMines(false);
        }
    }

    class AttackGoal
    extends MeleeAttackGoal {
        AttackGoal() {
            super((CreatureEntity)RedstoneGolemEntity.this, 1.0, true);
        }

        public boolean func_75250_a() {
            return super.func_75250_a() && !RedstoneGolemEntity.this.canSummonMines();
        }

        public boolean func_75253_b() {
            return super.func_75253_b() && !RedstoneGolemEntity.this.canSummonMines();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            float adjustedAttackerWidth = RedstoneGolemEntity.this.func_213311_cf() - 0.8f;
            float attackerWidthSquaredTimes4 = adjustedAttackerWidth * 2.0f * adjustedAttackerWidth * 2.0f;
            return attackerWidthSquaredTimes4 + attackTarget.func_213311_cf();
        }
    }

    static class GolemMovementController
    extends MovementController {
        RedstoneGolemEntity redstoneGolemEntity;

        GolemMovementController(RedstoneGolemEntity mob) {
            super((MobEntity)mob);
            this.redstoneGolemEntity = mob;
        }

        public void func_75641_c() {
            if (!this.redstoneGolemEntity.isSummoningMines()) {
                super.func_75641_c();
            }
        }
    }

    static class GolemLookController
    extends LookController {
        RedstoneGolemEntity redstoneGolemEntity;

        GolemLookController(RedstoneGolemEntity mob) {
            super((MobEntity)mob);
            this.redstoneGolemEntity = mob;
        }

        public void func_75649_a() {
            if (!this.redstoneGolemEntity.isSummoningMines()) {
                super.func_75649_a();
            }
        }
    }

    static class Processor
    extends WalkNodeProcessor {
        private Processor() {
        }

        protected PathNodeType func_215744_a(IBlockReader blockReader, boolean canBreakDoors, boolean canWalkThroughDoorways, BlockPos blockPos, PathNodeType pathNodeType) {
            return pathNodeType == PathNodeType.LEAVES ? PathNodeType.OPEN : super.func_215744_a(blockReader, canBreakDoors, canWalkThroughDoorways, blockPos, pathNodeType);
        }
    }

    static class Navigator
    extends GroundPathNavigator {
        public Navigator(MobEntity mobEntity, World world) {
            super(mobEntity, world);
        }

        protected PathFinder func_179679_a(int p_179679_1_) {
            this.field_179695_a = new Processor();
            return new PathFinder(this.field_179695_a, p_179679_1_);
        }
    }
}

