/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.entities.summonables;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.command.arguments.ParticleArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TornadoEntity
extends Entity {
    private static final Logger PRIVATE_LOGGER = LogManager.getLogger();
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(TornadoEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(TornadoEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> IGNORE_RADIUS = EntityDataManager.func_187226_a(TornadoEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<IParticleData> PARTICLE = EntityDataManager.func_187226_a(TornadoEntity.class, (IDataSerializer)DataSerializers.field_198166_i);
    private Potion potion = Potions.field_185229_a;
    private final List<EffectInstance> effects = Lists.newArrayList();
    private final Map<Entity, Integer> reapplicationDelayMap = Maps.newHashMap();
    private int duration = 600;
    private int waitTime = 20;
    private int reapplicationDelay = 20;
    private boolean colorSet;
    private int durationOnUse;
    private float radiusOnUse;
    private float radiusPerTick;
    private LivingEntity owner;
    private UUID ownerUniqueId;
    private LivingEntity target;
    private UUID targetUniqueId;

    public TornadoEntity(World world) {
        super((EntityType)ModEntityTypes.TORNADO.get(), world);
    }

    public TornadoEntity(EntityType<? extends TornadoEntity> cloud, World world) {
        super(cloud, world);
        this.field_70145_X = true;
        this.setRadius(3.0f);
    }

    public TornadoEntity(World worldIn, LivingEntity caster, double x, double y, double z) {
        this((EntityType<? extends TornadoEntity>)((EntityType)ModEntityTypes.TORNADO.get()), worldIn);
        this.setOwner(caster);
        this.func_70107_b(x, y, z);
    }

    public TornadoEntity(World world, LivingEntity caster, LivingEntity livingEntity) {
        this(world, caster, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
        this.setTarget(livingEntity);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(IGNORE_RADIUS, (Object)false);
        this.func_184212_Q().func_187214_a(PARTICLE, (Object)ParticleTypes.field_218418_af);
    }

    public void setRadius(float radiusIn) {
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radiusIn));
        }
    }

    public void func_213323_x_() {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        super.func_213323_x_();
        this.func_70107_b(d0, d1, d2);
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setPotion(Potion potionIn) {
        this.potion = potionIn;
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    private void updateFixedColor() {
        if (this.potion == Potions.field_185229_a && this.effects.isEmpty()) {
            this.func_184212_Q().func_187227_b(COLOR, (Object)0);
        } else {
            this.func_184212_Q().func_187227_b(COLOR, (Object)PotionUtils.func_185181_a((Collection)PotionUtils.func_185186_a((Potion)this.potion, this.effects)));
        }
    }

    public void addEffect(EffectInstance effect) {
        this.effects.add(effect);
        if (!this.colorSet) {
            this.updateFixedColor();
        }
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int colorIn) {
        this.colorSet = true;
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorIn);
    }

    public IParticleData getParticleData() {
        return (IParticleData)this.func_184212_Q().func_187225_a(PARTICLE);
    }

    public void setParticleData(IParticleData particleData) {
        this.func_184212_Q().func_187227_b(PARTICLE, (Object)particleData);
    }

    protected void setIgnoreRadius(boolean ignoreRadius) {
        this.func_184212_Q().func_187227_b(IGNORE_RADIUS, (Object)ignoreRadius);
    }

    public boolean shouldIgnoreRadius() {
        return (Boolean)this.func_184212_Q().func_187225_a(IGNORE_RADIUS);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int durationIn) {
        this.duration = durationIn;
    }

    public void func_70071_h_() {
        block20: {
            boolean flag1;
            float radius;
            boolean shouldIgnoreRadius;
            block18: {
                IParticleData iparticledata;
                block19: {
                    super.func_70071_h_();
                    shouldIgnoreRadius = this.shouldIgnoreRadius();
                    radius = this.getRadius();
                    if (!this.field_70170_p.field_72995_K) break block18;
                    iparticledata = this.getParticleData();
                    if (!shouldIgnoreRadius) break block19;
                    if (!this.field_70146_Z.nextBoolean()) break block20;
                    for (int i = 0; i < 2; ++i) {
                        float randWithin2Pi = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                        float adjustedSqrtFloat = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * 0.2f;
                        float adjustedCosine = MathHelper.func_76134_b((float)randWithin2Pi) * adjustedSqrtFloat;
                        float adjustedSine = MathHelper.func_76126_a((float)randWithin2Pi) * adjustedSqrtFloat;
                        this.field_70170_p.func_217404_b(iparticledata, true, this.func_226277_ct_() + (double)adjustedCosine, this.func_226278_cu_(), this.func_226281_cx_() + (double)adjustedSine, 0.0, 0.07, 0.0);
                    }
                    break block20;
                }
                float areaOfEffect = (float)Math.PI * radius * radius;
                int k1 = 0;
                while ((float)k1 < areaOfEffect) {
                    float randWithin2Pi = this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                    float adjustedSqrtFloat = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * radius;
                    float adjustedCosine = MathHelper.func_76134_b((float)randWithin2Pi) * adjustedSqrtFloat;
                    float adjustedSine = MathHelper.func_76126_a((float)randWithin2Pi) * adjustedSqrtFloat;
                    this.field_70170_p.func_195589_b(iparticledata, this.func_226277_ct_() + (double)adjustedCosine, this.func_226278_cu_(), this.func_226281_cx_() + (double)adjustedSine, 0.0, 0.07, 0.0);
                    ++k1;
                }
                break block20;
            }
            if (this.target != null) {
                this.func_70107_b(this.target.func_226277_ct_(), this.func_226278_cu_(), this.target.func_226281_cx_());
            }
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            boolean bl = flag1 = this.field_70173_aa < this.waitTime;
            if (shouldIgnoreRadius != flag1) {
                this.setIgnoreRadius(flag1);
            }
            if (flag1) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.5f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(radius);
            }
            if (this.field_70173_aa % 5 == 0) {
                this.reapplicationDelayMap.entrySet().removeIf(entry -> this.field_70173_aa >= (Integer)entry.getValue());
                ArrayList list = Lists.newArrayList();
                for (EffectInstance effectinstance1 : this.potion.func_185170_a()) {
                    list.add(new EffectInstance(effectinstance1.func_188419_a(), effectinstance1.func_76459_b() / 4, effectinstance1.func_76458_c(), effectinstance1.func_82720_e(), effectinstance1.func_188418_e()));
                }
                list.addAll(this.effects);
                if (list.isEmpty()) {
                    this.reapplicationDelayMap.clear();
                } else {
                    List list1 = this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ());
                    if (!list1.isEmpty()) {
                        for (LivingEntity livingentity : list1) {
                            double zDifference;
                            double xDifference;
                            double horizontalDistanceSquared;
                            if (this.reapplicationDelayMap.containsKey(livingentity) || !livingentity.func_184603_cC() || !((horizontalDistanceSquared = (xDifference = livingentity.func_226277_ct_() - this.func_226277_ct_()) * xDifference + (zDifference = livingentity.func_226281_cx_() - this.func_226281_cx_()) * zDifference) <= (double)(radius * radius))) continue;
                            this.reapplicationDelayMap.put((Entity)livingentity, this.field_70173_aa + this.reapplicationDelay);
                            for (EffectInstance effectinstance : list) {
                                if (effectinstance.func_188419_a().func_76403_b()) {
                                    effectinstance.func_188419_a().func_180793_a((Entity)this, (Entity)this.getOwner(), livingentity, effectinstance.func_76458_c(), 0.5);
                                    continue;
                                }
                                livingentity.func_195064_c(new EffectInstance(effectinstance));
                            }
                            if (this.radiusOnUse != 0.0f) {
                                if ((radius += this.radiusOnUse) < 0.5f) {
                                    this.func_70106_y();
                                    return;
                                }
                                this.setRadius(radius);
                            }
                            if (this.durationOnUse == 0) continue;
                            this.duration += this.durationOnUse;
                            if (this.duration > 0) continue;
                            this.func_70106_y();
                            return;
                        }
                    }
                }
            }
        }
    }

    public void setRadiusOnUse(float radiusOnUseIn) {
        this.radiusOnUse = radiusOnUseIn;
    }

    public void setRadiusPerTick(float radiusPerTickIn) {
        this.radiusPerTick = radiusPerTickIn;
    }

    public void setWaitTime(int waitTimeIn) {
        this.waitTime = waitTimeIn;
    }

    public void setOwner(@Nullable LivingEntity ownerIn) {
        this.owner = ownerIn;
        this.ownerUniqueId = ownerIn == null ? null : ownerIn.func_110124_au();
    }

    public void setTarget(@Nullable LivingEntity targetIn) {
        this.target = targetIn;
        this.targetUniqueId = targetIn == null ? null : targetIn.func_110124_au();
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.ownerUniqueId != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.ownerUniqueId)) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    @Nullable
    public LivingEntity getTarget() {
        Entity entity;
        if (this.target == null && this.targetUniqueId != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.targetUniqueId)) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
        return this.target;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.field_70173_aa = compound.func_74762_e("Age");
        this.duration = compound.func_74762_e("Duration");
        this.waitTime = compound.func_74762_e("WaitTime");
        this.reapplicationDelay = compound.func_74762_e("ReapplicationDelay");
        this.durationOnUse = compound.func_74762_e("DurationOnUse");
        this.radiusOnUse = compound.func_74760_g("RadiusOnUse");
        this.radiusPerTick = compound.func_74760_g("RadiusPerTick");
        this.setRadius(compound.func_74760_g("Radius"));
        if (compound.func_186855_b("Owner")) {
            this.ownerUniqueId = compound.func_186857_a("Owner");
        }
        if (compound.func_186855_b("Target")) {
            this.targetUniqueId = compound.func_186857_a("Target");
        }
        if (compound.func_150297_b("Particle", 8)) {
            try {
                this.setParticleData(ParticleArgument.func_197189_a((StringReader)new StringReader(compound.func_74779_i("Particle"))));
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                PRIVATE_LOGGER.warn("Couldn't load custom particle {}", (Object)compound.func_74779_i("Particle"), (Object)commandsyntaxexception);
            }
        }
        if (compound.func_150297_b("Color", 99)) {
            this.setColor(compound.func_74762_e("Color"));
        }
        if (compound.func_150297_b("Potion", 8)) {
            this.setPotion(PotionUtils.func_185187_c((CompoundNBT)compound));
        }
        if (compound.func_150297_b("Effects", 9)) {
            ListNBT listnbt = compound.func_150295_c("Effects", 10);
            this.effects.clear();
            for (int i = 0; i < listnbt.size(); ++i) {
                EffectInstance effectinstance = EffectInstance.func_82722_b((CompoundNBT)listnbt.func_150305_b(i));
                if (effectinstance == null) continue;
                this.addEffect(effectinstance);
            }
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Age", this.field_70173_aa);
        compound.func_74768_a("Duration", this.duration);
        compound.func_74768_a("WaitTime", this.waitTime);
        compound.func_74768_a("ReapplicationDelay", this.reapplicationDelay);
        compound.func_74768_a("DurationOnUse", this.durationOnUse);
        compound.func_74776_a("RadiusOnUse", this.radiusOnUse);
        compound.func_74776_a("RadiusPerTick", this.radiusPerTick);
        compound.func_74776_a("Radius", this.getRadius());
        compound.func_74778_a("Particle", this.getParticleData().func_197555_a());
        if (this.ownerUniqueId != null) {
            compound.func_186854_a("Owner", this.ownerUniqueId);
        }
        if (this.targetUniqueId != null) {
            compound.func_186854_a("Target", this.targetUniqueId);
        }
        if (this.colorSet) {
            compound.func_74768_a("Color", this.getColor());
        }
        if (this.potion != Potions.field_185229_a && this.potion != null) {
            compound.func_74778_a("Potion", Registry.field_212621_j.func_177774_c((Object)this.potion).toString());
        }
        if (!this.effects.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (EffectInstance effectinstance : this.effects) {
                listnbt.add((Object)effectinstance.func_82719_a(new CompoundNBT()));
            }
            compound.func_218657_a("Effects", (INBT)listnbt);
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        if (RADIUS.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return EntitySize.func_220314_b((float)(this.getRadius() * 2.0f), (float)0.5f);
    }
}

