/*
 * Decompiled with CFR 0.152.
 */
package com.infamous.dungeons_mobs.mixin;

import com.infamous.dungeons_mobs.config.DungeonsMobsConfig;
import com.infamous.dungeons_mobs.goals.RangedWebAttackGoal;
import com.infamous.dungeons_mobs.interfaces.IWebShooter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SpiderEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SpiderEntity.class})
public abstract class SpiderEntityMixin
extends MonsterEntity
implements IWebShooter {
    private static final DataParameter<Boolean> WEBSHOOTING = EntityDataManager.func_187226_a(SpiderEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    protected SpiderEntityMixin(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    @Inject(at={@At(value="RETURN")}, method={"registerGoals"})
    private void registerGoals(CallbackInfo callbackInfo) {
        if (((Boolean)DungeonsMobsConfig.COMMON.ENABLE_RANGED_SPIDERS.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(2, new RangedWebAttackGoal<SpiderEntityMixin>(this, 1.0, 60, 20.0f));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"registerData"})
    private void registerData(CallbackInfo callbackInfo) {
        this.field_70180_af.func_187214_a(WEBSHOOTING, (Object)false);
    }

    @Override
    public boolean shouldShootWeb() {
        return this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > 9.0;
    }

    @Override
    public boolean isTargetSlowedDown() {
        LivingEntity attackTarget = this.func_70638_az();
        if (attackTarget != null) {
            Vector3d motionMultiplier = (Vector3d)ObfuscationReflectionHelper.getPrivateValue(Entity.class, (Object)attackTarget, (String)"field_213328_B");
            if (motionMultiplier != null) {
                return motionMultiplier.field_72450_a <= 0.25 && motionMultiplier.field_72448_b <= 0.05 && motionMultiplier.field_72449_c <= 0.25;
            }
            return false;
        }
        return false;
    }

    @Override
    public void setWebShooting(boolean webShooting) {
        this.field_70180_af.func_187227_b(WEBSHOOTING, (Object)webShooting);
    }

    @Override
    public boolean isWebShooting() {
        return (Boolean)this.field_70180_af.func_187225_a(WEBSHOOTING);
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        this.shootWeb((MobEntity)this, target);
    }
}

