/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.client.event;

import azmalent.cuneiform.lib.registry.BlockRegistryHelper;
import azmalent.terraincognita.client.event.ColorHandler;
import azmalent.terraincognita.client.event.TooltipHandler;
import azmalent.terraincognita.client.gui.BasketContainerScreen;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModContainers;
import azmalent.terraincognita.common.registry.ModEntities;
import azmalent.terraincognita.common.registry.ModItems;
import azmalent.terraincognita.common.registry.ModParticles;
import azmalent.terraincognita.common.registry.ModTileEntities;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.Atlases;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.state.properties.ChestType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
public class ClientEventHandler {
    public static void registerListeners() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ClientEventHandler::clientSetup);
        bus.addListener(ClientEventHandler::onRegisterModels);
        bus.addListener(ClientEventHandler::onStitch);
        bus.addListener(ColorHandler::registerBlockColorHandlers);
        bus.addListener(ColorHandler::registerItemColorHandlers);
        bus.addListener(ModParticles::registerParticleFactories);
        TooltipHandler.registerListeners();
    }

    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ((BlockRegistryHelper)ModBlocks.HELPER).initRenderTypes());
        event.enqueueWork(ModItems::registerPropertyOverrides);
        ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainers.BASKET.get()), BasketContainerScreen::new);
    }

    public static void onRegisterModels(ModelRegistryEvent event) {
        ModEntities.registerRenderers();
        ModTileEntities.registerRenderers();
    }

    public static void onStitch(TextureStitchEvent.Pre event) {
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228746_e_)) {
            ModWoodTypes.VALUES.forEach(woodType -> event.addSprite(woodType.SIGN_TEXTURE));
            return;
        }
        if (event.getMap().func_229223_g_().equals((Object)Atlases.field_228747_f_)) {
            ModWoodTypes.VALUES.forEach(woodType -> {
                for (ChestType type : ChestType.field_196020_d) {
                    event.addSprite(woodType.getChestTexture(type, false));
                    event.addSprite(woodType.getChestTexture(type, true));
                }
            });
        }
    }
}

