/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.client.renderer.entity;

import azmalent.terraincognita.common.entity.butterfly.AbstractButterflyEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButterflyRenderer<T extends AbstractButterflyEntity>
extends MobRenderer<T, ButterflyModel<T>> {
    public ButterflyRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new ButterflyModel(), 0.2f);
    }

    @Nonnull
    public ResourceLocation getEntityTexture(T butterfly) {
        return ((AbstractButterflyEntity)((Object)butterfly)).getTexture();
    }

    protected void preRenderCallback(T butterfly, MatrixStack matrixStack, float partialTickTime) {
        float scale = ((AbstractButterflyEntity)((Object)butterfly)).getSizeModifier();
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    protected void applyRotations(T butterfly, @Nonnull MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        if (!((AbstractButterflyEntity)((Object)butterfly)).isLanded()) {
            matrixStack.func_227861_a_(0.0, (double)(0.1f + MathHelper.func_76134_b((float)(ageInTicks * 0.3f)) * 0.1f), 0.0);
        }
        super.func_225621_a_(butterfly, matrixStack, ageInTicks, rotationYaw, partialTicks);
    }

    public static class ButterflyModel<T extends AbstractButterflyEntity>
    extends EntityModel<T> {
        private final ModelRenderer body;
        private final ModelRenderer antennae;
        private final ModelRenderer leftWing;
        private final ModelRenderer rightWing;
        private static final float MIN_WING_ANGLE = 0.62831855f;
        private static final float MAX_WING_ANGLE = 2.5132742f;

        public ButterflyModel() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.body = new ModelRenderer((Model)this, 0, 0);
            this.body.func_78793_a(0.0f, 24.0f, 0.0f);
            this.body.func_78784_a(0, 0).func_228303_a_(-1.0f, -1.0f, -2.0f, 1.0f, 1.0f, 8.0f, 0.0f, true);
            this.antennae = new ModelRenderer((Model)this, 36, 12);
            this.antennae.func_78793_a(3.0f, -1.0f, -2.0f);
            this.body.func_78792_a(this.antennae);
            this.setModelRotation(this.antennae, 1.0472f, 0.0f, 0.0f);
            this.antennae.func_78784_a(29, 12).func_228303_a_(-7.0f, -4.0f, 0.0f, 7.0f, 4.0f, 0.0f, 0.0f, false);
            this.leftWing = new ModelRenderer((Model)this, 8, 11);
            this.leftWing.func_78793_a(0.0f, -0.5f, 2.0f);
            this.body.func_78792_a(this.leftWing);
            this.setModelRotation(this.leftWing, 1.5708f, 0.0f, 0.7854f);
            this.leftWing.func_228303_a_(0.0f, -7.0f, 0.0f, 0.0f, 13.0f, 8.0f, 0.0f, false);
            this.rightWing = new ModelRenderer((Model)this, 8, 11);
            this.rightWing.func_78793_a(-1.0f, -0.5f, 2.0f);
            this.body.func_78792_a(this.rightWing);
            this.setModelRotation(this.rightWing, 1.5708f, 0.0f, -0.7854f);
            this.rightWing.func_228303_a_(0.0f, -7.0f, 0.0f, 0.0f, 13.0f, 8.0f, 0.0f, true);
        }

        public void setRotationAngles(@Nonnull T butterfly, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            float wingAngle;
            this.body.field_78795_f = ((AbstractButterflyEntity)((Object)butterfly)).isLanded() ? 0.0f : -0.2618f;
            this.leftWing.field_78808_h = wingAngle = MathHelper.func_219799_g((float)((AbstractButterflyEntity)((Object)butterfly)).getWingRotation(ageInTicks), (float)0.62831855f, (float)2.5132742f);
            this.rightWing.field_78808_h = -wingAngle;
        }

        public void func_225598_a_(@Nonnull MatrixStack matrixStack, @Nonnull IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        private void setModelRotation(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }
    }
}

