/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block.plants;

import azmalent.terraincognita.common.block.plants.HangingPlantBlock;
import azmalent.terraincognita.common.data.ModBlockTags;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class HangingMossBlock
extends HangingPlantBlock
implements IGrowable {
    public static final VoxelShape TOP_SHAPE = HangingMossBlock.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final VoxelShape BOTTOM_SHAPE = HangingMossBlock.func_208617_a((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    public static final EnumProperty<Variant> VARIANT = EnumProperty.func_177709_a((String)"variant", Variant.class);

    public HangingMossBlock() {
        this.func_180632_j((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(VARIANT, (Comparable)((Object)Variant.SINGLE)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{VARIANT});
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return state.func_177229_b(VARIANT) == Variant.TOP ? TOP_SHAPE : BOTTOM_SHAPE;
    }

    @Override
    protected boolean isValidGround(BlockState state, BlockState ground, IBlockReader worldIn, BlockPos groundPos) {
        if (ground.func_177230_c() == this) {
            return ground.func_177229_b(VARIANT) != Variant.BOTTOM;
        }
        return ground.func_224755_d(worldIn, groundPos, Direction.DOWN) && ground.func_235714_a_(ModBlockTags.HANGING_MOSS_PLANTABLE_ON);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState ground = context.func_195991_k().func_180495_p(context.func_195995_a().func_177984_a());
        if (ground.func_177230_c() == this && ground.func_177229_b(VARIANT) != Variant.BOTTOM) {
            return (BlockState)this.func_176223_P().func_206870_a(VARIANT, (Comparable)((Object)Variant.BOTTOM));
        }
        return super.func_196258_a(context);
    }

    @Override
    @Nonnull
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            if (stateIn.func_177229_b(VARIANT) == Variant.SINGLE && facingState.func_177230_c() == this) {
                return super.func_196271_a((BlockState)stateIn.func_206870_a(VARIANT, (Comparable)((Object)Variant.TOP)), facing, facingState, worldIn, currentPos, facingPos);
            }
            if (stateIn.func_177229_b(VARIANT) == Variant.TOP && facingState.func_177230_c() != this) {
                return super.func_196271_a(this.func_176223_P(), facing, facingState, worldIn, currentPos, facingPos);
            }
        } else if (facing == Direction.UP) {
            if (facingState.func_177230_c() == this && facingState.func_177229_b(VARIANT) != Variant.BOTTOM) {
                return (BlockState)stateIn.func_206870_a(VARIANT, (Comparable)((Object)Variant.BOTTOM));
            }
            if (this.isValidGround(stateIn, facingState, (IBlockReader)worldIn, facingPos)) {
                return (BlockState)stateIn.func_206870_a(VARIANT, (Comparable)((Object)Variant.SINGLE));
            }
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_176473_a(@Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull BlockState blockState, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        return true;
    }

    public void func_225535_a_(@Nonnull ServerWorld world, @Nonnull Random random, @Nonnull BlockPos pos, BlockState state) {
        int numAttempts = 4;
        if (state.func_177229_b(VARIANT) == Variant.SINGLE && world.func_175623_d(pos.func_177977_b()) && random.nextBoolean()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)Variant.TOP)));
            world.func_175656_a(pos.func_177977_b(), (BlockState)state.func_206870_a(VARIANT, (Comparable)((Object)Variant.BOTTOM)));
            numAttempts = 2;
        }
        for (int i = 0; i < numAttempts; ++i) {
            BlockPos nextPos;
            BlockState moss = this.func_176223_P();
            int x = random.nextInt(4) - random.nextInt(4);
            int y = random.nextInt(2) - random.nextInt(2);
            int z = random.nextInt(4) - random.nextInt(4);
            if (x == 0 && z == 0 || !world.func_175623_d(nextPos = pos.func_177982_a(x, y, z)) || !moss.func_196955_c((IWorldReader)world, nextPos)) continue;
            world.func_175656_a(nextPos, moss);
        }
    }

    public static enum Variant implements IStringSerializable
    {
        SINGLE("single"),
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private Variant(String name) {
            this.name = name;
        }

        @Nonnull
        public String func_176610_l() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

