/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.block.signs;

import azmalent.terraincognita.common.block.woodtypes.ModWoodType;
import azmalent.terraincognita.common.integration.ModIntegration;
import azmalent.terraincognita.common.tile.ModSignTileEntity;
import azmalent.terraincognita.network.NetworkHandler;
import azmalent.terraincognita.network.message.UpdateSignMessage;
import azmalent.terraincognita.network.message.s2c.S2CEditSignMessage;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.AbstractSignBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.WoodType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public abstract class AbstractModSignBlock
extends AbstractSignBlock {
    protected final ModWoodType field_226943_c_;

    public AbstractModSignBlock(ModWoodType woodType) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodType.woodColor).func_200942_a().func_200943_b(1.0f).func_200947_a(SoundType.field_185848_a), WoodType.field_227038_a_);
        this.field_226943_c_ = woodType;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_204613_a});
    }

    @Nonnull
    public ActionResultType func_225533_a_(BlockState state, World worldIn, @Nonnull BlockPos pos, PlayerEntity player, @Nonnull Hand handIn, BlockRayTraceResult hit) {
        boolean canDye;
        ItemStack heldStack = player.func_184586_b(handIn);
        boolean canEdit = player.field_71075_bZ.field_75099_e;
        boolean bl = canDye = heldStack.func_77973_b() instanceof DyeItem && canEdit;
        if (worldIn.field_72995_K) {
            return canDye ? ActionResultType.SUCCESS : ActionResultType.CONSUME;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof ModSignTileEntity) {
            ModSignTileEntity sign = (ModSignTileEntity)te;
            if (canDye) {
                boolean setColor = sign.setTextColor(((DyeItem)heldStack.func_77973_b()).func_195962_g());
                if (setColor) {
                    UpdateSignMessage message = new UpdateSignMessage(pos, sign.signText, sign.getTextColor().func_196059_a());
                    NetworkHandler.sendToAllPlayers(message);
                    if (!player.func_184812_l_()) {
                        heldStack.func_190918_g(1);
                    }
                }
            } else if (canEdit && !this.doesSignHaveCommand(sign) && ModIntegration.QUARK.canEditSign(heldStack) && !player.func_225608_bj_()) {
                NetworkHandler.sendToPlayer((ServerPlayerEntity)player, new S2CEditSignMessage(pos));
                return ActionResultType.SUCCESS;
            }
            return sign.executeCommand(player) ? ActionResultType.SUCCESS : ActionResultType.PASS;
        }
        return ActionResultType.PASS;
    }

    private boolean doesSignHaveCommand(ModSignTileEntity sign) {
        for (ITextComponent itextcomponent : sign.signText) {
            ClickEvent clickevent;
            Style style;
            Style style2 = style = itextcomponent == null ? null : itextcomponent.func_150256_b();
            if (style == null || style.func_150235_h() == null || (clickevent = style.func_150235_h()).func_150669_a() != ClickEvent.Action.RUN_COMMAND) continue;
            return true;
        }
        return false;
    }

    public ResourceLocation getTexture() {
        return this.field_226943_c_.SIGN_TEXTURE;
    }

    public TileEntity func_196283_a_(IBlockReader world) {
        return new ModSignTileEntity();
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

