/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.entity.butterfly;

import azmalent.terraincognita.common.ModDamageSources;
import azmalent.terraincognita.common.entity.butterfly.ButterflyEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class AbstractButterflyEntity
extends CreatureEntity
implements IFlyingAnimal {
    public static final DataParameter<Float> SIZE_MODIFIER = EntityDataManager.func_187226_a(ButterflyEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected int flyingTicks = 0;
    protected int underWaterTicks = 0;
    protected float wingRotation = 0.5f;
    protected float targetWingRotation = 0.5f;

    protected AbstractButterflyEntity(EntityType<? extends AbstractButterflyEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 10, false);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, -1.0f);
        this.func_184644_a(PathNodeType.COCOA, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("SizeModifier", this.getSizeModifier());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("SizeModifier")) {
            this.setSizeModifier(compound.func_74760_g("SizeModifier"));
        } else {
            this.setSizeModifier(this.getRandomSizeModifier());
        }
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 4.0).func_233815_a_(Attributes.field_233822_e_, (double)2.4f).func_233815_a_(Attributes.field_233821_d_, (double)0.3f);
    }

    @Nonnull
    protected PathNavigator func_175447_b(@Nonnull World world) {
        FlyingPathNavigator navigator = new FlyingPathNavigator((MobEntity)this, world);
        navigator.func_192879_a(false);
        navigator.func_212239_d(false);
        navigator.func_192878_b(true);
        return navigator;
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_175623_d(pos) ? 10.0f : 0.0f;
    }

    protected abstract float getRandomSizeModifier();

    public float getSizeModifier() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE_MODIFIER)).floatValue();
    }

    protected void setSizeModifier(float sizeModifier) {
        this.field_70180_af.func_187227_b(SIZE_MODIFIER, (Object)Float.valueOf(sizeModifier));
    }

    public boolean isTired() {
        return false;
    }

    public boolean isLanded() {
        return false;
    }

    public abstract float getWingRotation(float var1);

    protected void func_70619_bc() {
        super.func_70619_bc();
        if (this.func_203005_aq()) {
            ++this.underWaterTicks;
            if (this.underWaterTicks > 20) {
                this.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        } else {
            this.underWaterTicks = 0;
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_213390_a(this.func_233580_cy_(), 22);
        this.setSizeModifier(this.getRandomSizeModifier());
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public abstract ResourceLocation getTexture();

    protected boolean func_191957_ae() {
        return false;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    public boolean func_189652_ae() {
        return true;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_225503_b_(float p_225503_1_, float p_225503_2_) {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    protected void func_184231_a(double distance, boolean onGround, @Nonnull BlockState state, @Nonnull BlockPos pos) {
    }

    protected void func_82167_n(Entity entity) {
    }

    protected void func_85033_bc() {
    }

    public boolean func_180431_b(@Nonnull DamageSource source) {
        return source == DamageSource.field_220302_v || source == DamageSource.field_76367_g || source == ModDamageSources.CALTROPS || super.func_180431_b(source);
    }

    @Nonnull
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223224_c_;
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return size.field_220316_b / 2.0f;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187850_fa;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187795_eZ;
    }
}

