/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.entity.butterfly.ai;

import azmalent.terraincognita.common.entity.butterfly.ButterflyEntity;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.block.TallFlowerBlock;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public class ButterflyLandOnFlowerGoal
extends MoveToBlockGoal {
    private final ButterflyEntity butterfly;

    public ButterflyLandOnFlowerGoal(ButterflyEntity butterfly, double speed, int searchRadius) {
        super((CreatureEntity)butterfly, speed, searchRadius);
        this.butterfly = butterfly;
    }

    public boolean func_75250_a() {
        return !this.butterfly.isLanded() && (this.butterfly.isTired() || this.butterfly.field_70170_p.func_226690_K_()) && super.func_75250_a();
    }

    public boolean func_75253_b() {
        return !this.butterfly.isLanded() && (this.butterfly.isTired() || this.butterfly.field_70170_p.func_226690_K_()) && super.func_75253_b();
    }

    public void func_75251_c() {
        this.butterfly.func_70661_as().func_75499_g();
    }

    protected boolean func_179488_a(@Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return this.canLandOnBlock(state) && !this.isBlockTaken(world, pos);
    }

    private boolean canLandOnBlock(BlockState state) {
        if (state.func_235714_a_((ITag)BlockTags.field_226148_H_) && state.func_177230_c() instanceof TallFlowerBlock) {
            return state.func_177229_b((Property)TallFlowerBlock.field_176492_b) == DoubleBlockHalf.UPPER;
        }
        return state.func_235714_a_((ITag)BlockTags.field_219746_E);
    }

    private boolean isBlockTaken(IWorldReader world, BlockPos pos) {
        VoxelShape shape = world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return true;
        }
        List entities = this.butterfly.field_70170_p.func_217357_a(ButterflyEntity.class, shape.func_197752_a().func_72321_a(0.5, 0.5, 0.5).func_186670_a(pos));
        return entities.stream().anyMatch(e -> pos.equals((Object)((ButterflyEntity)e).restGoal.restingPos));
    }

    public void func_75246_d() {
        super.func_75246_d();
        if (this.func_179487_f() && this.func_179488_a((IWorldReader)this.butterfly.field_70170_p, this.field_179494_b)) {
            BlockState state = this.butterfly.field_70170_p.func_180495_p(this.field_179494_b);
            VoxelShape shape = state.func_196954_c((IBlockReader)this.butterfly.field_70170_p, this.field_179494_b);
            if (shape.func_197766_b()) {
                return;
            }
            this.butterfly.setLanded(true);
            AxisAlignedBB aabb = shape.func_197752_a();
            double x = (double)this.field_179494_b.func_177958_n() + (aabb.field_72340_a + aabb.field_72336_d) / 2.0;
            double y = (double)this.field_179494_b.func_177956_o() + aabb.field_72337_e;
            double z = (double)this.field_179494_b.func_177952_p() + (aabb.field_72339_c + aabb.field_72334_f) / 2.0;
            if (state.func_177230_c() instanceof LilyPadBlock) {
                y += 0.1;
            } else if (state.func_177230_c() instanceof TallFlowerBlock) {
                y -= 0.25;
            }
            this.butterfly.func_70634_a(x, y, z);
            this.butterfly.func_213317_d(Vector3d.field_186680_a);
        }
    }
}

