/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.entity.butterfly.ai;

import azmalent.terraincognita.common.entity.butterfly.ButterflyEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class ButterflyRestGoal
extends Goal {
    private final ButterflyEntity butterfly;
    public BlockPos restingPos;
    private BlockState initialBlockState;
    private int ticks;

    public ButterflyRestGoal(ButterflyEntity butterfly) {
        this.butterfly = butterfly;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean func_75250_a() {
        if (this.butterfly.isLanded() && !this.butterfly.hasPlayersNearby()) {
            this.restingPos = this.butterfly.func_233580_cy_();
            return true;
        }
        return false;
    }

    public boolean func_75253_b() {
        return this.butterfly.isLanded() && (this.butterfly.isTired() || this.butterfly.field_70170_p.func_226690_K_()) && !this.butterfly.hasPlayersNearby();
    }

    public void func_75249_e() {
        this.initialBlockState = this.butterfly.field_70170_p.func_180495_p(this.restingPos);
        this.ticks = 0;
    }

    public void func_75251_c() {
        this.butterfly.setNotLanded();
        this.restingPos = null;
        this.initialBlockState = null;
        this.ticks = 0;
    }

    public void func_75246_d() {
        if (this.restingPos == null) {
            this.restingPos = this.butterfly.func_233580_cy_();
        }
        ++this.ticks;
        if (this.blockStateUpdated() || this.isBlockTaken(this.butterfly.field_70170_p, this.restingPos)) {
            this.butterfly.setNotLanded();
        } else if (this.butterfly.func_70681_au().nextInt(200) == 0) {
            if (this.ticks > 300) {
                this.butterfly.setTired(false);
                if (!this.butterfly.field_70170_p.func_226690_K_()) {
                    this.butterfly.setNotLanded();
                }
            } else {
                this.butterfly.field_70759_as = this.butterfly.func_70681_au().nextInt(360);
            }
        }
    }

    private boolean isBlockTaken(World world, BlockPos pos) {
        VoxelShape shape = world.func_180495_p(pos).func_196954_c((IBlockReader)world, pos);
        if (shape.func_197766_b()) {
            return true;
        }
        List entities = world.func_217357_a(ButterflyEntity.class, shape.func_197752_a().func_72321_a(0.5, 0.5, 0.5).func_186670_a(pos));
        return entities.stream().anyMatch(e -> e != this.butterfly && pos.equals((Object)((ButterflyEntity)e).restGoal.restingPos));
    }

    private boolean blockStateUpdated() {
        return this.initialBlockState != this.butterfly.field_70170_p.func_180495_p(this.butterfly.func_233580_cy_());
    }
}

