/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.event;

import azmalent.terraincognita.common.ModTweaks;
import azmalent.terraincognita.common.data.ModItemTags;
import azmalent.terraincognita.common.event.BiomeHandler;
import azmalent.terraincognita.common.event.BonemealHandler;
import azmalent.terraincognita.common.event.LootHandler;
import azmalent.terraincognita.common.event.TradeHandler;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.item.block.BasketItem;
import azmalent.terraincognita.common.recipe.WreathRecipe;
import azmalent.terraincognita.common.registry.ModBiomes;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModEffects;
import azmalent.terraincognita.common.registry.ModEntities;
import azmalent.terraincognita.common.registry.ModItems;
import azmalent.terraincognita.common.registry.ModRecipes;
import azmalent.terraincognita.common.world.ModConfiguredFeatures;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EventHandler {
    public static void registerListeners() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(EventHandler::setup);
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onUpdateRecipes);
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onPlayerUseItem);
        MinecraftForge.EVENT_BUS.addListener(EventHandler::onItemPickup);
        MinecraftForge.EVENT_BUS.addListener(BiomeHandler::onLoadBiome);
        MinecraftForge.EVENT_BUS.addListener(LootHandler::onLoadLootTable);
        MinecraftForge.EVENT_BUS.addListener(TradeHandler::setupWandererTrades);
        BonemealHandler.registerListeners();
    }

    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(ModConfiguredFeatures::registerFeatures);
        event.enqueueWork(ModBiomes::registerBiomes);
        ModBlocks.initToolInteractions();
        ModBlocks.initFlammability();
        ModItems.initFuelValues();
        ModEntities.registerAttributes();
        ModEntities.registerSpawns();
        ModRecipes.initCompostables();
        ModTweaks.modifyFlowerGradients();
    }

    public static void onUpdateRecipes(RecipesUpdatedEvent event) {
        for (ICraftingRecipe recipe : event.getRecipeManager().func_241447_a_(IRecipeType.field_222149_a)) {
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients.size() != 1) continue;
            ItemStack[] matchingStacks = ((Ingredient)ingredients.get(0)).func_193365_a();
            int n = matchingStacks.length;
            for (int i = 0; i < n; ++i) {
                Item input = matchingStacks[i].func_77973_b();
                Item output = recipe.func_77571_b().func_77973_b();
                if (!input.func_206844_a((ITag)ItemTags.field_219770_E) || !output.func_206844_a((ITag)Tags.Items.DYES)) continue;
                WreathRecipe.FLOWER_TO_DYE_MAP.put(input, (DyeItem)output.getItem());
            }
        }
    }

    public static void onPlayerUseItem(LivingEntityUseItemEvent.Start event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        EffectInstance effect = player.func_70660_b((Effect)ModEffects.STICKY_MOUTH.get());
        if (effect != null && event.getItem().func_222117_E()) {
            int multiplier = 2 << effect.func_76458_c();
            event.setDuration(event.getDuration() * multiplier);
        }
    }

    public static void onItemPickup(EntityItemPickupEvent event) {
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        ItemEntity itemEntity = event.getItem();
        ItemStack stack = itemEntity.func_92059_d().func_77946_l();
        PlayerEntity player = event.getPlayer();
        ItemStack basket = BasketItem.getBasketInHand(player);
        if (basket != null && !stack.func_190926_b() && stack.func_77973_b().func_206844_a(ModItemTags.BASKET_STORABLE)) {
            BasketStackHandler stackHandler = BasketItem.getStackHandler(basket);
            ItemStack remainingStack = ItemHandlerHelper.insertItemStacked((IItemHandler)stackHandler, (ItemStack)stack, (boolean)false);
            int numPickedUp = stack.func_190916_E() - remainingStack.func_190916_E();
            if (numPickedUp > 0) {
                event.setCanceled(true);
                itemEntity.func_92059_d().func_190918_g(numPickedUp);
                if (!itemEntity.func_174814_R()) {
                    itemEntity.field_70170_p.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((itemEntity.field_70170_p.field_73012_v.nextFloat() - itemEntity.field_70170_p.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                }
                player.func_71001_a((Entity)itemEntity, numPickedUp);
                player.field_71070_bA.func_75142_b();
            }
        }
    }
}

