/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.integration.quark;

import azmalent.cuneiform.lib.registry.BlockEntry;
import azmalent.terraincognita.common.block.woodtypes.ModWoodType;
import azmalent.terraincognita.common.integration.quark.block.TIHedgeBlock;
import azmalent.terraincognita.common.integration.quark.block.TILeafCarpetBlock;
import azmalent.terraincognita.common.integration.quark.block.TIVerticalSlabBlock;
import azmalent.terraincognita.common.integration.quark.block.TIWoodPostBlock;
import azmalent.terraincognita.common.registry.ModBlocks;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.ItemGroup;

public class QuarkWoodBlockSet {
    public final BlockEntry VERTICAL_PLANKS;
    public final BlockEntry VERTICAL_SLAB;
    public final BlockEntry BOOKSHELF;
    public final BlockEntry LADDER;
    public final BlockEntry POST;
    public final BlockEntry STRIPPED_POST;
    public final BlockEntry HEDGE;
    public final BlockEntry LEAF_CARPET;

    public QuarkWoodBlockSet(ModWoodType woodType) {
        String name = woodType.name;
        MaterialColor barkColor = woodType.barkColor;
        MaterialColor woodColor = woodType.woodColor;
        this.VERTICAL_PLANKS = ModBlocks.HELPER.newBuilder("vertical_" + name + "_planks", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)).withItemGroup(ItemGroup.field_78030_b).build();
        this.VERTICAL_SLAB = ModBlocks.HELPER.newBuilder(name + "_vertical_slab", TIVerticalSlabBlock::new, AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a)).withItemGroup(ItemGroup.field_78030_b).build();
        this.BOOKSHELF = ModBlocks.HELPER.newBuilder(name + "_bookshelf", AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)woodColor).func_200943_b(1.5f).func_200947_a(SoundType.field_185848_a)).withItemGroup(ItemGroup.field_78030_b).build();
        this.LADDER = ModBlocks.HELPER.newBuilder(name + "_ladder", LadderBlock::new, AbstractBlock.Properties.func_200950_a((AbstractBlock)Blocks.field_150468_ap)).cutoutRender().build();
        this.POST = ModBlocks.HELPER.newBuilder(name + "_post", () -> new TIWoodPostBlock(barkColor)).cutoutRender().build();
        this.STRIPPED_POST = ModBlocks.HELPER.newBuilder("stripped_" + name + "_post", () -> new TIWoodPostBlock(woodColor)).cutoutRender().build();
        this.HEDGE = ModBlocks.HELPER.newBuilder(name + "_hedge", () -> new TIHedgeBlock(woodColor)).cutoutMippedRender().build();
        this.LEAF_CARPET = ModBlocks.HELPER.newBuilder(name + "_leaf_carpet", TILeafCarpetBlock::new).cutoutMippedRender().build();
    }
}

