/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.inventory;

import azmalent.terraincognita.TerraIncognita;
import azmalent.terraincognita.common.inventory.BasketStackHandler;
import azmalent.terraincognita.common.registry.ModContainers;
import azmalent.terraincognita.common.tile.BasketTileEntity;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class BasketContainer
extends Container {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;
    public static final int SIZE = 9;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_HEIGHT = 3;
    private static final int PLAYER_INVENTORY_WIDTH = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int SLOT_OFFSET = 18;
    private static final int PLAYER_INVENTORY_X = 8;
    private static final int PLAYER_INVENTORY_Y = 84;
    private static final int HOTBAR_Y = 142;
    private static final int BASKET_INVENTORY_X = 62;
    private static final int BASKET_INVENTORY_Y = 18;
    private final ItemStack heldStack;

    public BasketContainer(int id, PlayerInventory playerInventory, PacketBuffer buffer) {
        this(id, playerInventory, new BasketStackHandler(), ItemStack.field_190927_a);
    }

    public BasketContainer(int id, PlayerInventory playerInventory, BasketStackHandler stackHandler, BasketTileEntity te) {
        this(id, playerInventory, stackHandler, ItemStack.field_190927_a);
    }

    public BasketContainer(int id, PlayerInventory playerInventory, BasketStackHandler stackHandler, ItemStack heldStack) {
        super((ContainerType)ModContainers.BASKET.get(), id);
        this.heldStack = heldStack;
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i, 8 + 18 * i, 142));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int slotIndex = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.func_75146_a(new Slot((IInventory)playerInventory, slotIndex, xpos, ypos));
            }
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 3; ++col) {
                int x = 62 + col * 18;
                int y = 18 + row * 18;
                this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)stackHandler, row * 3 + col, x, y));
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot sourceSlot = (Slot)this.field_75151_b.get(index);
        if (sourceSlot == null || !sourceSlot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        ItemStack sourceStack = sourceSlot.func_75211_c();
        if (index < 36) {
            if (!this.func_75135_a(sourceStack, 36, 45, false)) {
                return ItemStack.field_190927_a;
            }
        } else if (index < 45) {
            if (!this.func_75135_a(sourceStack, 0, 36, false)) {
                return ItemStack.field_190927_a;
            }
        } else {
            TerraIncognita.LOGGER.warn("Invalid slot index:" + index);
            return ItemStack.field_190927_a;
        }
        if (sourceStack.func_190916_E() == 0) {
            sourceSlot.func_75215_d(ItemStack.field_190927_a);
        } else {
            sourceSlot.func_75218_e();
        }
        sourceSlot.func_190901_a(player, sourceStack);
        return sourceStack.func_77946_l();
    }

    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        return this.heldStack.func_190926_b() || player.func_184614_ca() == this.heldStack || player.func_184592_cb() == this.heldStack;
    }
}

