/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.registry;

import azmalent.cuneiform.common.event.FuelHandler;
import azmalent.cuneiform.common.item.ModSpawnEggItem;
import azmalent.terraincognita.common.block.woodtypes.ModWoodType;
import azmalent.terraincognita.common.entity.butterfly.ButterflyEntity;
import azmalent.terraincognita.common.item.JamItem;
import azmalent.terraincognita.common.item.NotchCarrotItem;
import azmalent.terraincognita.common.item.TaffyItem;
import azmalent.terraincognita.common.item.WreathItem;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModEntities;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.Items;
import net.minecraft.item.SoupItem;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModItems {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"terraincognita");
    public static final RegistryObject<TaffyItem> TAFFY = ITEMS.register("taffy", TaffyItem::new);
    public static final RegistryObject<NotchCarrotItem> NOTCH_CARROT = ITEMS.register("notch_carrot", NotchCarrotItem::new);
    public static final RegistryObject<Item> FIDDLEHEAD = ITEMS.register("fiddlehead", () -> new Item(ModItems.foodProps(Foods.FIDDLEHEAD)));
    public static final RegistryObject<Item> CLAYED_ROOT = ITEMS.register("clayed_root", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78039_h)));
    public static final RegistryObject<Item> BAKED_ROOT = ITEMS.register("baked_root", () -> new Item(ModItems.foodProps(Foods.BAKED_ROOT)));
    public static final RegistryObject<Item> KELP_SOUP = ITEMS.register("kelp_soup", () -> new SoupItem(ModItems.foodProps(Foods.KELP_SOUP).func_200917_a(1)));
    public static final RegistryObject<Item> BERRY_SORBET = ITEMS.register("berry_sorbet", () -> new SoupItem(ModItems.foodProps(Foods.BERRY_SORBET).func_200917_a(1)));
    public static final RegistryObject<WreathItem> WREATH = ITEMS.register("flower_band", WreathItem::new);
    public static final RegistryObject<Item> SOUR_BERRIES = ITEMS.register("sour_berries", () -> new Item(ModItems.foodProps(Foods.SOUR_BERRIES)));
    public static final RegistryObject<Item> SOUR_BERRY_PIE = ITEMS.register("sour_berry_pie", () -> new Item(ModItems.foodProps(Foods.SOUR_BERRY_PIE)));
    public static final RegistryObject<Item> SOUR_BERRY_JAM = ITEMS.register("sour_berry_jam", () -> new JamItem(ModItems.foodProps(Foods.SOUR_BERRY_JAM).func_200917_a(16)));
    public static final RegistryObject<Item> HAZELNUT = ITEMS.register("hazelnut", () -> new Item(ModItems.foodProps(Foods.HAZELNUT)));
    public static final RegistryObject<Item> HONEY_HAZELNUT = ITEMS.register("honey_hazelnut", () -> new Item(ModItems.foodProps(Foods.HONEY_HAZELNUT)));
    public static final RegistryObject<Item> HAZELNUT_COOKIE = ITEMS.register("hazelnut_cookie", () -> new Item(ModItems.foodProps(Foods.HAZELNUT_COOKIE)));
    public static final RegistryObject<ModSpawnEggItem<ButterflyEntity>> BUTTERFLY_SPAWN_EGG = ModItems.spawnEgg("butterfly", ModEntities.BUTTERFLY, 12594947, 987158);

    private static Item.Properties foodProps(Food food) {
        return new Item.Properties().func_200916_a(ItemGroup.field_78039_h).func_221540_a(food);
    }

    private static <T extends Entity> RegistryObject<ModSpawnEggItem<T>> spawnEgg(String entityId, RegistryObject<EntityType<T>> type, int primaryColor, int secondaryColor) {
        return ITEMS.register(entityId + "_spawn_egg", () -> new ModSpawnEggItem((Supplier)type, primaryColor, secondaryColor));
    }

    public static void initFuelValues() {
        for (ModWoodType woodType : ModWoodTypes.VALUES) {
            FuelHandler.registerFuel((IItemProvider)woodType.LOG, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.STRIPPED_LOG, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.WOOD, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.STRIPPED_WOOD, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.PLANKS, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.SLAB, (int)150);
            FuelHandler.registerFuel((IItemProvider)woodType.STAIRS, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.FENCE, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.FENCE_GATE, (int)300);
            FuelHandler.registerFuel((IItemProvider)woodType.SIGN, (int)200);
            FuelHandler.registerFuel((IItemProvider)woodType.DOOR, (int)200);
            FuelHandler.registerFuel((IItemProvider)woodType.TRAPDOOR, (int)300);
        }
        FuelHandler.registerFuel((IItemProvider)ModBlocks.REEDS, (int)100);
        FuelHandler.registerFuel((IItemProvider)ModBlocks.PEAT, (int)2400);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerPropertyOverrides() {
        ItemModelsProperties.func_239418_a_((Item)Items.field_222115_pz, (ResourceLocation)new ResourceLocation("fiddlehead"), (stack, world, livingEntity) -> stack.func_77942_o() && stack.func_77978_p().func_74764_b("fiddlehead") ? 1.0f : 0.0f);
    }

    public static class Foods {
        public static final Food TAFFY = new Food.Builder().func_221456_a(3).func_221454_a(0.3f).func_221455_b().func_221453_d();
        public static final Food NOTCH_CARROT = new Food.Builder().func_221456_a(6).func_221454_a(1.2f).effect(() -> new EffectInstance(Effects.field_76444_x, 2400, 3), 1.0f).effect(() -> new EffectInstance(Effects.field_76428_l, 400, 1), 1.0f).effect(() -> new EffectInstance(Effects.field_76439_r, 12000), 1.0f).effect(() -> new EffectInstance(Effects.field_76424_c, 6000, 1), 1.0f).func_221455_b().func_221453_d();
        public static final Food FIDDLEHEAD = new Food.Builder().func_221456_a(3).func_221454_a(0.5f).func_221457_c().func_221453_d();
        public static final Food BAKED_ROOT = new Food.Builder().func_221456_a(5).func_221454_a(0.6f).effect(() -> new EffectInstance(Effects.field_76422_e, 300), 1.0f).func_221453_d();
        public static final Food KELP_SOUP = new Food.Builder().func_221456_a(6).func_221454_a(0.6f).func_221453_d();
        public static final Food BERRY_SORBET = new Food.Builder().func_221456_a(5).func_221454_a(0.5f).func_221453_d();
        public static final Food SOUR_BERRIES = new Food.Builder().func_221456_a(2).func_221454_a(0.1f).func_221453_d();
        public static final Food SOUR_BERRY_PIE = new Food.Builder().func_221456_a(6).func_221454_a(0.3f).func_221453_d();
        public static final Food SOUR_BERRY_JAM = new Food.Builder().func_221456_a(4).func_221454_a(0.2f).func_221453_d();
        public static final Food HAZELNUT = new Food.Builder().func_221456_a(2).func_221454_a(0.2f).func_221457_c().func_221453_d();
        public static final Food HONEY_HAZELNUT = new Food.Builder().func_221456_a(4).func_221454_a(0.4f).func_221457_c().func_221453_d();
        public static final Food HAZELNUT_COOKIE = new Food.Builder().func_221456_a(2).func_221454_a(0.1f).func_221453_d();
    }
}

