/*
 * Decompiled with CFR 0.152.
 */
package azmalent.terraincognita.common.registry;

import azmalent.terraincognita.TIConfig;
import azmalent.terraincognita.common.recipe.FiddleheadSuspiciousStewAdditionRecipe;
import azmalent.terraincognita.common.recipe.FiddleheadSuspiciousStewRecipe;
import azmalent.terraincognita.common.recipe.WreathRecipe;
import azmalent.terraincognita.common.registry.ModBlocks;
import azmalent.terraincognita.common.registry.ModItems;
import azmalent.terraincognita.common.registry.ModWoodTypes;
import java.util.function.Function;
import net.minecraft.block.ComposterBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.item.crafting.SpecialRecipeSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class ModRecipes {
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"terraincognita");
    public static final RegistryObject<SpecialRecipeSerializer<?>> FIDDLEHEAD_SUSPICIOUS_STEW = ModRecipes.registerRecipe("fiddlehead_suspicious_stew", FiddleheadSuspiciousStewRecipe::new);
    public static RegistryObject<SpecialRecipeSerializer<?>> FIDDLEHEAD_SUSPICIOUS_STEW_ADDITION = ModRecipes.registerRecipe("fiddlehead_suspicious_stew_addition", FiddleheadSuspiciousStewAdditionRecipe::new);
    public static final RegistryObject<SpecialRecipeSerializer<?>> WREATH = ModRecipes.registerRecipe("flower_band", WreathRecipe::new);

    private static RegistryObject<SpecialRecipeSerializer<?>> registerRecipe(String id, Function<ResourceLocation, SpecialRecipe> constructor) {
        return RECIPES.register(id, () -> new SpecialRecipeSerializer(constructor));
    }

    public static void registerCompostable(RegistryObject<? extends Item> item, float value) {
        ComposterBlock.field_220299_b.put((Object)item.get(), value);
    }

    public static void registerCompostable(IItemProvider itemProvider, float value) {
        ComposterBlock.field_220299_b.put((Object)itemProvider.func_199767_j(), value);
    }

    public static void initCompostables() {
        if (TIConfig.Misc.additionalCompostables.get().booleanValue()) {
            ComposterBlock.field_220299_b.put((Object)Items.field_221599_aA, 0.3f);
            ComposterBlock.field_220299_b.put((Object)Items.field_222068_kQ, 0.65f);
            ComposterBlock.field_220299_b.put((Object)Items.field_151170_bI, 0.65f);
            ComposterBlock.field_220299_b.put((Object)Items.field_185161_cS, 1.0f);
            ComposterBlock.field_220299_b.put((Object)Items.field_185162_cT, 1.0f);
            ComposterBlock.field_220299_b.put((Object)Items.field_221663_bT, 1.0f);
        }
        ModBlocks.FLOWERS.forEach(flower -> ModRecipes.registerCompostable(flower, 0.65f));
        ModBlocks.LOTUSES.forEach(lotus -> ModRecipes.registerCompostable((IItemProvider)lotus, 0.65f));
        ModBlocks.SWEET_PEAS.forEach(sweetPea -> ModRecipes.registerCompostable((IItemProvider)sweetPea, 0.65f));
        ModWoodTypes.VALUES.forEach(woodType -> {
            ModRecipes.registerCompostable(woodType.SAPLING, 0.3f);
            ModRecipes.registerCompostable((IItemProvider)woodType.LEAVES, 0.3f);
        });
        ModRecipes.registerCompostable((IItemProvider)ModBlocks.SMALL_LILY_PAD, 0.3f);
        ModRecipes.registerCompostable(ModBlocks.REEDS, 0.5f);
        ModRecipes.registerCompostable(ModBlocks.CARIBOU_MOSS, 0.3f);
        ModRecipes.registerCompostable((IItemProvider)ModBlocks.ROOTS, 0.5f);
        ModRecipes.registerCompostable((IItemProvider)ModBlocks.HANGING_MOSS, 0.3f);
        ModRecipes.registerCompostable(ModItems.SOUR_BERRIES, 0.3f);
        ModRecipes.registerCompostable((IItemProvider)ModBlocks.SOUR_BERRY_SPROUTS, 0.3f);
        ModRecipes.registerCompostable(ModItems.FIDDLEHEAD, 0.65f);
        ModRecipes.registerCompostable(ModItems.WREATH, 1.0f);
        ModRecipes.registerCompostable((IItemProvider)ModWoodTypes.APPLE.BLOSSOMING_LEAVES, 0.3f);
        ModRecipes.registerCompostable(ModItems.HAZELNUT, 0.3f);
        ModRecipes.registerCompostable(ModItems.HAZELNUT_COOKIE, 0.85f);
    }
}

